/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import org.jetbrains.annotations.NotNull;

public class CidrDebuggerUtil {
    @NlsSafe
    @NotNull
    public static String getExceptionMessage(Exception e) {
        String string = StringUtil.notNullize((String)e.getMessage(), (String)e.getClass().getSimpleName());
        if (string == null) {
            CidrDebuggerUtil.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public static <T> ReadActionResult<T> runInReadActionWithRetries(@NotNull Computable<? extends T> action, @NotNull Expirable expirable) {
        if (action == null) {
            CidrDebuggerUtil.$$$reportNull$$$0(1);
        }
        if (expirable == null) {
            CidrDebuggerUtil.$$$reportNull$$$0(2);
        }
        Ref res = Ref.create();
        int MAX_ATTEMPTS = 32;
        for (int attempt = 0; attempt < 32; ++attempt) {
            if (expirable.isExpired()) {
                ReadActionResult readActionResult = ReadActionResult.interrupted();
                if (readActionResult == null) {
                    CidrDebuggerUtil.$$$reportNull$$$0(3);
                }
                return readActionResult;
            }
            if (ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> res.set(action.compute()))) {
                ReadActionResult<Object> readActionResult = ReadActionResult.ok(res.get());
                if (readActionResult == null) {
                    CidrDebuggerUtil.$$$reportNull$$$0(4);
                }
                return readActionResult;
            }
            ProgressIndicatorUtils.yieldToPendingWriteActions();
        }
        CidrDebuggerLog.LOG.warn("Interrupted runInReadActionWithRetries() after 32 attempts");
        ReadActionResult readActionResult = ReadActionResult.interrupted();
        if (readActionResult == null) {
            CidrDebuggerUtil.$$$reportNull$$$0(5);
        }
        return readActionResult;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/CidrDebuggerUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expirable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getExceptionMessage";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrDebuggerUtil";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "runInReadActionWithRetries";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "runInReadActionWithRetries";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class ReadActionResult<T> {
        public final T value;
        public final boolean wasCompleted;

        private ReadActionResult(T value, boolean wasCompleted) {
            this.value = value;
            this.wasCompleted = wasCompleted;
        }

        static <T> ReadActionResult<T> ok(T value) {
            return new ReadActionResult<T>(value, true);
        }

        static <T> ReadActionResult<T> interrupted() {
            return new ReadActionResult<Object>(null, false);
        }
    }
}

