/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.diagnostics;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.RSyncUtil;
import com.intellij.util.PathMapper;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.io.PathKt;
import com.jetbrains.cidr.cpp.diagnostics.CdIndenter;
import com.jetbrains.cidr.cpp.diagnostics.CdToolchainsKt;
import com.jetbrains.cidr.cpp.toolchains.CMakeExecutableTool;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.cpp.toolchains.GDB;
import com.jetbrains.cidr.cpp.toolchains.Make;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.project.workspace.CidrWorkspace;
import com.jetbrains.cidr.project.workspace.WorkspaceWithEnvironment;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.system.MappedHost;
import com.jetbrains.cidr.system.PathMapperWrapper;
import com.jetbrains.cidr.system.RemoteDeploymentHelper;
import com.jetbrains.cidr.system.RemoteHost;
import com.jetbrains.cidr.system.RemoteUtil;
import com.jetbrains.cidr.toolchains.EnvironmentProblems;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.constant.Constable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000^\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u001a\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u001a\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000eH\u0002\u001a\u0010\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0018\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u001a\u0016\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001d\u001a\u000e\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u000e\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020!\u001aE\u0010\"\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u00032\b\b\u0001\u0010$\u001a\u00020\t2!\u0010%\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b'\u0012\b\b(\u0012\u0004\b\b(#\u0012\u0004\u0012\u00020\u00010&H\u0002\u001a\u0018\u0010)\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006*"}, d2={"checkConnection", "", "remoteHost", "Lcom/jetbrains/cidr/system/HostMachine;", "checkRemoteFS", "checkRemoteRsync", "checkRemoteTar", "checkRsyncDownload", "collectToolchains", "", "project", "Lcom/intellij/openapi/project/Project;", "getAllEnvironments", "", "Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "getAllProjectEnvironments", "getCredentials", "Lcom/intellij/remote/RemoteCredentials;", "processCPPEnvironment", "", "log", "Lcom/jetbrains/cidr/cpp/diagnostics/CdIndenter;", "environment", "processCheck", "processDevOptions", "processGeneralToolchainInfo", "toolchain", "Lcom/jetbrains/cidr/cpp/toolchains/CPPToolchains$Toolchain;", "processRemoteHost", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "processSystemInfo", "stackTraceToString", "t", "", "test", "host", "testName", "check", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "testRemoteHost", "intellij.clion.diagnostics"})
public final class CdToolchainsKt {
    @NotNull
    public static final String collectToolchains(@Nullable Project project) {
        CdIndenter log = new CdIndenter(4);
        CdToolchainsKt.processSystemInfo(log);
        log.put(new Object[0]);
        Iterable $this$forEach$iv = CdToolchainsKt.getAllEnvironments(project);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CPPEnvironment it = (CPPEnvironment)element$iv;
            boolean bl = false;
            CdToolchainsKt.processCPPEnvironment(log, it);
            log.put(new Object[0]);
        }
        return log.getResult();
    }

    public static final void processSystemInfo(@NotNull CdIndenter log) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        ApplicationInfo appInfo = ApplicationInfoImpl.getInstance();
        ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
        ApplicationNamesInfo namesInfo = applicationNamesInfo;
        Object[] objectArray = new Object[1];
        StringBuilder stringBuilder = new StringBuilder().append("IDE: ").append(namesInfo.getFullProductName()).append(" (build #");
        ApplicationInfo applicationInfo = appInfo;
        Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"appInfo");
        objectArray[0] = stringBuilder.append(applicationInfo.getBuild().asString()).append(')').toString();
        log.put(objectArray);
        log.put("OS: " + SystemInfo.OS_NAME + " (" + SystemInfo.OS_VERSION + ", " + SystemInfo.OS_ARCH + ')');
        CPPToolchains cPPToolchains = CPPToolchains.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)cPPToolchains, (String)"CPPToolchains.getInstance()");
        CPPToolchains cppToolchains = cPPToolchains;
        Object[] objectArray2 = new Object[1];
        StringBuilder stringBuilder2 = new StringBuilder().append("Default toolchain: ");
        Object object = cppToolchains.getDefaultToolchain();
        if (object == null || (object = object.getName()) == null) {
            object = "UNKNOWN";
        }
        objectArray2[0] = stringBuilder2.append((String)object).toString();
        log.put(objectArray2);
        CdToolchainsKt.processDevOptions(log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void processDevOptions(CdIndenter log) {
        Function2<String, Boolean, CdIndenter> $fun$logOption$1 = new Function2<String, Boolean, CdIndenter>(log){
            final /* synthetic */ CdIndenter $log;

            @NotNull
            public final CdIndenter invoke(@NotNull String option, boolean intOption) {
                Intrinsics.checkNotNullParameter((Object)option, (String)"option");
                return this.$log.put(option + " = " + (intOption ? (Constable)Integer.valueOf(Registry.intValue((String)option)) : (Constable)Boolean.valueOf(Registry.is((String)option))));
            }

            public static /* synthetic */ CdIndenter invoke$default(processDevOptions.1 var0, String string, boolean bl, int n, Object object) {
                if ((n & 2) != 0) {
                    bl = false;
                }
                return var0.invoke(string, bl);
            }
            {
                this.$log = cdIndenter;
                super(2);
            }
        };
        log.put("Options:");
        CdIndenter this_$iv = log;
        boolean $i$f$scope = false;
        this_$iv.indent();
        try {
            boolean bl = false;
            processDevOptions.1.invoke$default($fun$logOption$1, "clion.remote.use.rsync", false, 2, null);
            processDevOptions.1.invoke$default($fun$logOption$1, "clion.remote.compress.tar", false, 2, null);
            $fun$logOption$1.invoke("clion.remote.tar.timeout", true);
            processDevOptions.1.invoke$default($fun$logOption$1, "clion.remote.resync.system.cache", false, 2, null);
            processDevOptions.1.invoke$default($fun$logOption$1, "clion.remote.upload.external.changes", false, 2, null);
        }
        finally {
            this_$iv.unIndent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static final void processRemoteHost(@NotNull CdIndenter log, @NotNull CidrToolEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        v0 = environment.getHostMachine();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"environment.hostMachine");
        if (!v0.isRemote()) {
            return;
        }
        v1 = remoteHost = environment.getHostMachine();
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"remoteHost");
        v2 = v1.getHostId();
        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"remoteHost.hostId");
        hostId = v2;
        if (!(environment instanceof CPPEnvironment)) ** GOTO lbl-1000
        v3 = ((CPPEnvironment)environment).getToolSet();
        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"environment.toolSet");
        if (v3.isWSL()) {
            v4 = true;
        } else lbl-1000:
        // 2 sources

        {
            v4 = false;
        }
        isWsl = v4;
        log.put(new Object[]{"Remote Host: " + remoteHost.getName() + " (" + hostId + ')', isWsl != false ? " is WSL" : ""});
        this_$iv = log;
        $i$f$scope = false;
        this_$iv.indent();
        try {
            $i$a$-scope-CdToolchainsKt$processRemoteHost$1 = false;
            CdToolchainsKt.testRemoteHost(log, remoteHost);
            if (environment instanceof CPPEnvironment) {
                CdToolchainsKt.processCPPEnvironment(log, (CPPEnvironment)environment);
            }
        }
        finally {
            this_$iv.unIndent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void processCPPEnvironment(CdIndenter log, CPPEnvironment environment) {
        ProgressManager.checkCanceled();
        CPPToolchains.Toolchain toolchain = environment.getToolchain();
        Intrinsics.checkNotNullExpressionValue((Object)toolchain, (String)"environment.toolchain");
        CPPToolchains.Toolchain toolchain2 = toolchain;
        HostMachine hostMachine = environment.getHostMachine();
        Intrinsics.checkNotNullExpressionValue((Object)hostMachine, (String)"environment.hostMachine");
        HostMachine hostMachine2 = hostMachine;
        log.put("Toolchain: " + toolchain2.getName());
        CdIndenter this_$iv = log;
        boolean $i$f$scope = false;
        this_$iv.indent();
        try {
            CMakeExecutableTool it;
            boolean bl;
            boolean bl2;
            CMakeExecutableTool cMakeExecutableTool;
            boolean bl3 = false;
            CdToolchainsKt.processGeneralToolchainInfo(log, toolchain2);
            CMakeExecutableTool cMakeExecutableTool2 = environment.getCMake();
            if (cMakeExecutableTool2 != null) {
                cMakeExecutableTool = cMakeExecutableTool2;
                bl2 = false;
                bl = false;
                it = cMakeExecutableTool;
                boolean bl4 = false;
                Object[] objectArray = new Object[1];
                StringBuilder stringBuilder = new StringBuilder().append("cmake (").append(it.readVersion()).append("): ");
                CMakeExecutableTool cMakeExecutableTool3 = it;
                Intrinsics.checkNotNullExpressionValue((Object)cMakeExecutableTool3, (String)"it");
                objectArray[0] = stringBuilder.append(cMakeExecutableTool3.getExecutablePath()).toString();
                log.put(objectArray);
            }
            Make make = environment.getMake();
            if (make != null) {
                cMakeExecutableTool = make;
                bl2 = false;
                bl = false;
                it = cMakeExecutableTool;
                boolean bl5 = false;
                Object[] objectArray = new Object[1];
                StringBuilder stringBuilder = new StringBuilder().append("make (").append(it.readVersion()).append("): ");
                CMakeExecutableTool cMakeExecutableTool4 = it;
                Intrinsics.checkNotNullExpressionValue((Object)cMakeExecutableTool4, (String)"it");
                objectArray[0] = stringBuilder.append(cMakeExecutableTool4.getExecutablePath()).toString();
                log.put(objectArray);
            }
            GDB gDB = environment.getGDB();
            if (gDB != null) {
                cMakeExecutableTool = gDB;
                bl2 = false;
                bl = false;
                it = cMakeExecutableTool;
                boolean bl6 = false;
                Object[] objectArray = new Object[1];
                StringBuilder stringBuilder = new StringBuilder().append("gdb (").append(it.readVersion()).append("): ");
                CMakeExecutableTool cMakeExecutableTool5 = it;
                Intrinsics.checkNotNullExpressionValue((Object)cMakeExecutableTool5, (String)"it");
                objectArray[0] = stringBuilder.append(cMakeExecutableTool5.getExecutablePath()).toString();
                log.put(objectArray);
            }
            if (hostMachine2 instanceof MappedHost) {
                log.put("Path Mappings:");
                PathMapper pathMapper = ((MappedHost)hostMachine2).getPathMapper();
                Intrinsics.checkNotNullExpressionValue((Object)pathMapper, (String)"hostMachine.pathMapper");
                PathMapper pathMapper2 = pathMapper;
                if (pathMapper2 instanceof PathMapperWrapper) {
                    PathMapper pathMapper3 = ((PathMapperWrapper)pathMapper2).getOriginal();
                    Intrinsics.checkNotNullExpressionValue((Object)pathMapper3, (String)"pathMapper.original");
                    pathMapper2 = pathMapper3;
                }
                CdIndenter this_$iv2 = log;
                boolean $i$f$scope2 = false;
                this_$iv2.indent();
                try {
                    boolean bl7 = false;
                    if (pathMapper2 instanceof PathMappingSettings) {
                        List list = ((PathMappingSettings)pathMapper2).getPathMappings();
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"pathMapper.pathMappings");
                        Iterable $this$forEach$iv = list;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            PathMappingSettings.PathMapping it2 = (PathMappingSettings.PathMapping)element$iv;
                            boolean bl8 = false;
                            Object[] objectArray = new Object[1];
                            StringBuilder stringBuilder = new StringBuilder();
                            PathMappingSettings.PathMapping pathMapping = it2;
                            Intrinsics.checkNotNullExpressionValue((Object)pathMapping, (String)"it");
                            objectArray[0] = stringBuilder.append(pathMapping.getLocalRoot()).append(" -> ").append(it2.getRemoteRoot()).toString();
                            log.put(objectArray);
                        }
                    }
                }
                finally {
                    this_$iv2.unIndent();
                }
            }
            String string = RemoteDeploymentHelper.getRootPath((String)hostMachine2.getHostId());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"RemoteDeploymentHelper.g\u2026tPath(hostMachine.hostId)");
            String rootPath = string;
            CharSequence charSequence = rootPath;
            bl = false;
            if (charSequence.length() == 0) {
                rootPath = "not specified";
            }
            log.put("Root Path: " + rootPath);
            if (hostMachine2 instanceof RemoteHost) {
                Object[] objectArray = new Object[1];
                StringBuilder stringBuilder = new StringBuilder().append("Header-roots cache: ");
                File file = ((RemoteHost)hostMachine2).getCacheDirectory();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"hostMachine.cacheDirectory");
                objectArray[0] = stringBuilder.append(file.getAbsolutePath()).toString();
                log.put(objectArray);
            }
        }
        finally {
            this_$iv.unIndent();
        }
    }

    private static final void processGeneralToolchainInfo(CdIndenter log, CPPToolchains.Toolchain toolchain) {
        block1: {
            String it;
            boolean bl;
            boolean bl2;
            String string;
            log.put("OS: " + toolchain.getOSType());
            log.put("Kind: " + toolchain.getToolSetKind());
            String string2 = toolchain.getCustomCCompilerPath();
            if (string2 != null) {
                string = string2;
                bl2 = false;
                bl = false;
                it = string;
                boolean bl3 = false;
                log.put("c: " + it);
            }
            String string3 = toolchain.getCustomCXXCompilerPath();
            if (string3 == null) break block1;
            string = string3;
            bl2 = false;
            bl = false;
            it = string;
            boolean bl4 = false;
            log.put("cxx: " + it);
        }
    }

    private static final void testRemoteHost(CdIndenter log, HostMachine remoteHost) {
        boolean isConnected2 = CdToolchainsKt.test(log, remoteHost, "test connection", (Function1<? super HostMachine, Boolean>)((Function1)testRemoteHost.isConnected.1.INSTANCE));
        if (isConnected2) {
            CdToolchainsKt.test(log, remoteHost, "run remote process", (Function1<? super HostMachine, Boolean>)((Function1)testRemoteHost.1.INSTANCE));
            CdToolchainsKt.test(log, remoteHost, "remote FS", (Function1<? super HostMachine, Boolean>)((Function1)testRemoteHost.2.INSTANCE));
            CdToolchainsKt.test(log, remoteHost, "tar", (Function1<? super HostMachine, Boolean>)((Function1)testRemoteHost.3.INSTANCE));
            if (SystemInfo.isUnix) {
                CdToolchainsKt.test(log, remoteHost, "rsync local", (Function1<? super HostMachine, Boolean>)((Function1)testRemoteHost.4.INSTANCE));
                CdToolchainsKt.test(log, remoteHost, "rsync remote", (Function1<? super HostMachine, Boolean>)((Function1)testRemoteHost.5.INSTANCE));
                CdToolchainsKt.test(log, remoteHost, "rsync download", (Function1<? super HostMachine, Boolean>)((Function1)testRemoteHost.6.INSTANCE));
            }
        }
    }

    private static final boolean checkConnection(HostMachine remoteHost) {
        return RemoteUtil.checkConnection((RemoteCredentials)CdToolchainsKt.getCredentials(remoteHost));
    }

    private static final boolean processCheck(HostMachine remoteHost) {
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(new String[]{"pwd"});
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"ProgressManager.getInstance()");
        ProcessOutput processOutput = remoteHost.runProcess(generalCommandLine, progressManager.getProgressIndicator(), 5000);
        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"remoteHost.runProcess(\n \u2026.progressIndicator, 5000)");
        ProcessOutput output = processOutput;
        return output.getExitCode() == 0 && StringUtil.isNotEmpty((String)output.getStdout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean checkRemoteFS(HostMachine remoteHost) {
        Path path = remoteHost.createTempDirectory("host_info", null);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"remoteHost.createTempDirectory(\"host_info\", null)");
        Path tmp = path;
        try {
            Path file = Files.createFile(tmp.resolve("file.txt"), new FileAttribute[0]);
            String testString = "Hello, CLion!";
            Path path2 = file;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"file");
            PathKt.write$default((Path)path2, (CharSequence)testString, null, (boolean)false, (int)2, null);
            Path path3 = remoteHost.getPath(((Object)file.toAbsolutePath()).toString(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"remoteHost.getPath(file.\u2026bsolutePath().toString())");
            Path filePath = path3;
            boolean bl = Intrinsics.areEqual((Object)testString, (Object)PathKt.readText((Path)filePath));
            return bl;
        }
        finally {
            PathKt.delete$default((Path)tmp, (boolean)false, (int)1, null);
        }
    }

    private static final boolean checkRemoteTar(HostMachine remoteHost) {
        return RemoteUtil.isTarInstalled((RemoteUtil.CommandRunner)new RemoteUtil.CommandRunner(remoteHost){
            final /* synthetic */ HostMachine $remoteHost;

            @NotNull
            public final ProcessOutput run(@NotNull GeneralCommandLine cmd) {
                Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
                ProgressManager progressManager = ProgressManager.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"ProgressManager.getInstance()");
                return this.$remoteHost.runProcess(cmd, progressManager.getProgressIndicator(), 5000);
            }
            {
                this.$remoteHost = hostMachine;
            }
        });
    }

    private static final boolean checkRemoteRsync(HostMachine remoteHost) {
        return RemoteUtil.isRsyncInstalled((RemoteUtil.CommandRunner)new RemoteUtil.CommandRunner(remoteHost){
            final /* synthetic */ HostMachine $remoteHost;

            @NotNull
            public final ProcessOutput run(@NotNull GeneralCommandLine cmd) {
                Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
                ProgressManager progressManager = ProgressManager.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"ProgressManager.getInstance()");
                return this.$remoteHost.runProcess(cmd, progressManager.getProgressIndicator(), 5000);
            }
            {
                this.$remoteHost = hostMachine;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean checkRsyncDownload(HostMachine remoteHost) throws IOException {
        RemoteCredentials credentials = CdToolchainsKt.getCredentials(remoteHost);
        Path path = remoteHost.createTempDirectory("remote", null);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"remoteHost.createTempDirectory(\"remote\", null)");
        Path remote = path;
        File file = FileUtil.createTempDirectory((String)"local", null);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"FileUtil.createTempDirectory(\"local\", null)");
        File local = file;
        File file2 = FileUtil.createTempFile((String)"log", null);
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"FileUtil.createTempFile(\"log\", null)");
        File logFile = file2;
        try {
            Path file3 = Files.createFile(remote.resolve("file.txt"), new FileAttribute[0]);
            String testString = "Hello, CLion!";
            Path path2 = file3;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"file");
            PathKt.write$default((Path)path2, (CharSequence)testString, null, (boolean)false, (int)2, null);
            String string = local.getPath();
            String string2 = ((Object)remote).toString();
            ProgressManager progressManager = ProgressManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"ProgressManager.getInstance()");
            RSyncUtil.downloadFolderWithRSync((String)string, (String)string2, (RemoteCredentials)credentials, (ProgressIndicator)progressManager.getProgressIndicator(), null, (String)logFile.getPath());
            String string3 = FileUtil.loadFile((File)new File(local, "file.txt"));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"FileUtil.loadFile(File(local, \"file.txt\"))");
            String text = string3;
            boolean bl = Intrinsics.areEqual((Object)testString, (Object)text);
            return bl;
        }
        finally {
            PathKt.delete$default((Path)remote, (boolean)false, (int)1, null);
            local.delete();
            logFile.delete();
        }
    }

    private static final boolean test(CdIndenter log, HostMachine host, @NonNls String testName, Function1<? super HostMachine, Boolean> check) {
        ProgressManager.checkCanceled();
        boolean status = false;
        try {
            status = (Boolean)check.invoke((Object)host);
            String statusStr = status ? "[OK]" : "[FAILED]";
            log.put(statusStr + ' ' + testName);
        }
        catch (Throwable t) {
            log.put("[ERROR] " + testName + "  ==>  ", CdToolchainsKt.stackTraceToString(t));
        }
        return status;
    }

    private static final RemoteCredentials getCredentials(HostMachine remoteHost) {
        RemoteCredentials remoteCredentials = RemoteUtil.getCredentials((HostMachine)remoteHost);
        if (remoteCredentials == null) {
            throw (Throwable)new IllegalStateException("Cannot find credentials by hostId");
        }
        return remoteCredentials;
    }

    @NotNull
    public static final String stackTraceToString(@NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        StringWriter writer = new StringWriter();
        t.printStackTrace(new PrintWriter(writer));
        String string = writer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writer.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<CPPEnvironment> getAllEnvironments(Project project) {
        void $this$distinctBy$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        String string;
        Collection collection;
        void $this$mapTo$iv$iv2;
        List<CPPEnvironment> projectEnvironments = project == null ? CollectionsKt.emptyList() : CdToolchainsKt.getAllProjectEnvironments(project);
        Iterable $this$map$iv2 = projectEnvironments;
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            CPPEnvironment cPPEnvironment = (CPPEnvironment)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            CPPToolchains.Toolchain toolchain = it.getToolchain();
            Intrinsics.checkNotNullExpressionValue((Object)toolchain, (String)"it.toolchain");
            string = toolchain.getName();
            collection.add(string);
        }
        HashSet toolchainsSet = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
        CPPToolchains cPPToolchains = CPPToolchains.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)cPPToolchains, (String)"CPPToolchains.getInstance()");
        List list = cPPToolchains.getToolchains();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"CPPToolchains.getInstance().toolchains");
        Iterable $i$f$map22 = list;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CPPToolchains.Toolchain bl = (CPPToolchains.Toolchain)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            void v3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"it");
            string = v3.getName();
            collection.add(string);
        }
        $this$map$iv = (List)destination$iv$iv2;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!toolchainsSet.contains(it))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            CPPEnvironment cPPEnvironment;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl = false;
            String it2 = (String)element$iv$iv;
            boolean bl3 = false;
            if (CPPToolchains.createCPPEnvironment((Project)project, null, (String)it2, (EnvironmentProblems)new EnvironmentProblems(), (boolean)false, null) == null) continue;
            boolean bl4 = false;
            boolean bl5 = false;
            CPPEnvironment it$iv$iv = cPPEnvironment;
            boolean bl6 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv2;
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            CPPEnvironment it3 = (CPPEnvironment)e$iv;
            boolean bl = false;
            CPPEnvironment cPPEnvironment = it3;
            Intrinsics.checkNotNullExpressionValue((Object)cPPEnvironment, (String)"it");
            CPPToolchains.Toolchain toolchain = cPPEnvironment.getToolchain();
            Intrinsics.checkNotNullExpressionValue((Object)toolchain, (String)"it.toolchain");
            String key$iv = toolchain.getName();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List otherEnvironments = list$iv;
        return CollectionsKt.plus((Collection)projectEnvironments, (Iterable)otherEnvironments);
    }

    private static final List<CPPEnvironment> getAllProjectEnvironments(Project project) {
        Object list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        boolean bl;
        WorkspaceWithEnvironment it$iv$iv;
        WorkspaceWithEnvironment workspaceWithEnvironment;
        boolean bl2;
        boolean bl3;
        CidrWorkspace it;
        boolean bl4;
        Object element$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        List list = CidrWorkspace.getInitializedWorkspaces((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"CidrWorkspace.getInitializedWorkspaces(project)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Object $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv$iv;
            element$iv$iv = element$iv$iv$iv = iterator.next();
            bl4 = false;
            it = (CidrWorkspace)element$iv$iv;
            boolean bl5 = false;
            CidrWorkspace cidrWorkspace = it;
            if (!(cidrWorkspace instanceof WorkspaceWithEnvironment)) {
                cidrWorkspace = null;
            }
            if ((WorkspaceWithEnvironment)cidrWorkspace == null) continue;
            bl3 = false;
            bl2 = false;
            it$iv$iv = workspaceWithEnvironment;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$mapNotNullTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv2 : $this$flatMapTo$iv$iv) {
            WorkspaceWithEnvironment it2 = (WorkspaceWithEnvironment)element$iv$iv2;
            boolean bl6 = false;
            list$iv$iv = it2.getEnvironment();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        $i$f$mapNotNull = false;
        $this$flatMapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        list$iv$iv = $this$forEach$iv$iv$iv.iterator();
        while (list$iv$iv.hasNext()) {
            Object element$iv$iv$iv = list$iv$iv.next();
            element$iv$iv = element$iv$iv$iv;
            bl4 = false;
            it = (CidrToolEnvironment)element$iv$iv;
            boolean bl7 = false;
            CidrWorkspace cidrWorkspace = it;
            if (!(cidrWorkspace instanceof CPPEnvironment)) {
                cidrWorkspace = null;
            }
            if ((CPPEnvironment)cidrWorkspace == null) continue;
            bl3 = false;
            bl2 = false;
            it$iv$iv = workspaceWithEnvironment;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$distinctBy$iv = (List)destination$iv$iv;
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            CPPEnvironment it3 = (CPPEnvironment)e$iv;
            boolean bl8 = false;
            CPPToolchains.Toolchain toolchain = it3.getToolchain();
            Intrinsics.checkNotNullExpressionValue((Object)toolchain, (String)"it.toolchain");
            String key$iv = toolchain.getName();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        return list$iv;
    }

    public static final /* synthetic */ boolean access$checkConnection(HostMachine remoteHost) {
        return CdToolchainsKt.checkConnection(remoteHost);
    }

    public static final /* synthetic */ boolean access$processCheck(HostMachine remoteHost) {
        return CdToolchainsKt.processCheck(remoteHost);
    }

    public static final /* synthetic */ boolean access$checkRemoteFS(HostMachine remoteHost) {
        return CdToolchainsKt.checkRemoteFS(remoteHost);
    }

    public static final /* synthetic */ boolean access$checkRemoteTar(HostMachine remoteHost) {
        return CdToolchainsKt.checkRemoteTar(remoteHost);
    }

    public static final /* synthetic */ boolean access$checkRemoteRsync(HostMachine remoteHost) {
        return CdToolchainsKt.checkRemoteRsync(remoteHost);
    }

    public static final /* synthetic */ boolean access$checkRsyncDownload(HostMachine remoteHost) {
        return CdToolchainsKt.checkRsyncDownload(remoteHost);
    }
}

