/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.execution.auth;

import com.intellij.util.proxy.CommonProxy;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.util.Args;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/httpClient/execution/auth/HttpClientCredentialsProvider;", "Lorg/apache/http/client/CredentialsProvider;", "()V", "internal", "Lorg/apache/http/impl/client/BasicCredentialsProvider;", "clear", "", "getCredentials", "Lorg/apache/http/auth/Credentials;", "authscope", "Lorg/apache/http/auth/AuthScope;", "setCredentials", "credentials", "Companion", "intellij.restClient"})
public final class HttpClientCredentialsProvider
implements CredentialsProvider {
    private final BasicCredentialsProvider internal = new BasicCredentialsProvider();
    private static final Map<String, String> SCHEME_MAP;
    @NotNull
    public static final Companion Companion;

    public void setCredentials(@NotNull AuthScope authscope, @NotNull Credentials credentials) {
        Intrinsics.checkNotNullParameter((Object)authscope, (String)"authscope");
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        this.internal.setCredentials(authscope, credentials);
    }

    @Nullable
    public Credentials getCredentials(@NotNull AuthScope authscope) {
        Intrinsics.checkNotNullParameter((Object)authscope, (String)"authscope");
        Args.notNull((Object)authscope, (String)"Auth scope");
        Credentials localcreds = this.internal.getCredentials(authscope);
        if (localcreds != null) {
            return localcreds;
        }
        String host = authscope.getHost();
        if (host != null) {
            String protocol;
            HttpHost origin = authscope.getOrigin();
            String string = protocol = origin != null ? origin.getSchemeName() : (authscope.getPort() == 443 ? "https" : "http");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"protocol");
            PasswordAuthentication systemcreds = HttpClientCredentialsProvider.Companion.getSystemCreds(string, authscope, Authenticator.RequestorType.SERVER);
            if (systemcreds == null) {
                systemcreds = HttpClientCredentialsProvider.Companion.getSystemCreds(protocol, authscope, Authenticator.RequestorType.PROXY);
            }
            if (systemcreds == null && (systemcreds = HttpClientCredentialsProvider.Companion.getProxyCredentials("http", authscope)) == null) {
                systemcreds = HttpClientCredentialsProvider.Companion.getProxyCredentials("https", authscope);
            }
            if (systemcreds != null) {
                Credentials credentials;
                String domain = System.getProperty("http.auth.ntlm.domain");
                if (domain != null) {
                    String string2 = systemcreds.getUserName();
                    char[] cArray = systemcreds.getPassword();
                    Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"systemcreds.password");
                    char[] cArray2 = cArray;
                    boolean bl = false;
                    return (Credentials)new NTCredentials(string2, new String(cArray2), null, domain);
                }
                if (StringsKt.equals((String)"NTLM", (String)authscope.getScheme(), (boolean)true)) {
                    String string3 = systemcreds.getUserName();
                    char[] cArray = systemcreds.getPassword();
                    Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"systemcreds.password");
                    char[] cArray3 = cArray;
                    boolean bl = false;
                    credentials = (Credentials)new NTCredentials(string3, new String(cArray3), null, null);
                } else {
                    String string4 = systemcreds.getUserName();
                    char[] cArray = systemcreds.getPassword();
                    Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"systemcreds.password");
                    char[] cArray4 = cArray;
                    boolean bl = false;
                    credentials = (Credentials)new UsernamePasswordCredentials(string4, new String(cArray4));
                }
                return credentials;
            }
        }
        return null;
    }

    public void clear() {
        this.internal.clear();
    }

    static {
        Companion = new Companion(null);
        SCHEME_MAP = new ConcurrentHashMap();
        String string = "Basic";
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.ROOT");
        Locale locale2 = locale;
        boolean bl = false;
        String string2 = string;
        boolean bl2 = false;
        String string3 = string2.toUpperCase(locale2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toUpperCase(locale)");
        SCHEME_MAP.put(string3, "Basic");
        string = "Digest";
        Locale locale3 = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale3, (String)"Locale.ROOT");
        locale2 = locale3;
        bl = false;
        string2 = string;
        bl2 = false;
        String string4 = string2.toUpperCase(locale2);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toUpperCase(locale)");
        SCHEME_MAP.put(string4, "Digest");
        string = "NTLM";
        Locale locale4 = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale4, (String)"Locale.ROOT");
        locale2 = locale4;
        bl = false;
        string2 = string;
        bl2 = false;
        String string5 = string2.toUpperCase(locale2);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toUpperCase(locale)");
        SCHEME_MAP.put(string5, "NTLM");
        string = "Negotiate";
        Locale locale5 = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale5, (String)"Locale.ROOT");
        locale2 = locale5;
        bl = false;
        string2 = string;
        bl2 = false;
        String string6 = string2.toUpperCase(locale2);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).toUpperCase(locale)");
        SCHEME_MAP.put(string6, "SPNEGO");
        string = "Kerberos";
        Locale locale6 = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale6, (String)"Locale.ROOT");
        locale2 = locale6;
        bl = false;
        string2 = string;
        bl2 = false;
        String string7 = string2.toUpperCase(locale2);
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).toUpperCase(locale)");
        SCHEME_MAP.put(string7, "Kerberos");
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\"\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/httpClient/execution/auth/HttpClientCredentialsProvider$Companion;", "", "()V", "SCHEME_MAP", "", "", "getProxyCredentials", "Ljava/net/PasswordAuthentication;", "protocol", "authscope", "Lorg/apache/http/auth/AuthScope;", "getSystemCreds", "requestorType", "Ljava/net/Authenticator$RequestorType;", "translateScheme", "key", "intellij.restClient"})
    public static final class Companion {
        private final String translateScheme(String key2) {
            if (key2 == null) {
                return null;
            }
            String s = (String)SCHEME_MAP.get(key2);
            String string = s;
            if (string == null) {
                string = key2;
            }
            return string;
        }

        private final PasswordAuthentication getSystemCreds(String protocol, AuthScope authscope, Authenticator.RequestorType requestorType) {
            CommonProxy.getInstance().ensureAuthenticator();
            return Authenticator.requestPasswordAuthentication(authscope.getHost(), null, authscope.getPort(), protocol, authscope.getHost() + ':' + authscope.getPort(), this.translateScheme(authscope.getScheme()), null, requestorType);
        }

        private final PasswordAuthentication getProxyCredentials(String protocol, AuthScope authscope) {
            block9: {
                String string = System.getProperty(protocol + ".proxyHost");
                if (string == null) {
                    return null;
                }
                String proxyHost = string;
                String string2 = System.getProperty(protocol + ".proxyPort");
                if (string2 == null) {
                    return null;
                }
                String proxyPort = string2;
                try {
                    Object object;
                    String proxyUser;
                    block11: {
                        block10: {
                            String string3 = proxyPort;
                            boolean bl = false;
                            AuthScope systemScope = new AuthScope(proxyHost, Integer.parseInt(string3));
                            if (authscope.match(systemScope) < 0) break block9;
                            String string4 = System.getProperty(protocol + ".proxyUser");
                            if (string4 == null) {
                                return null;
                            }
                            proxyUser = string4;
                            String proxyPassword = System.getProperty(protocol + ".proxyPassword");
                            object = proxyPassword;
                            if (object == null) break block10;
                            String string5 = object;
                            boolean bl2 = false;
                            String string6 = string5;
                            if (string6 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                            }
                            char[] cArray = string6.toCharArray();
                            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
                            object = cArray;
                            if (cArray != null) break block11;
                        }
                        object = new char[0];
                    }
                    return new PasswordAuthentication(proxyUser, (char[])object);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

