/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.text;

import com.intellij.grazie.grammar.strategy.GrammarCheckingStrategy;
import com.intellij.grazie.ide.language.LanguageGrammarChecking;
import com.intellij.grazie.text.StrategyTextExtractor;
import com.intellij.grazie.text.TextContent;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.LanguageExtensionPoint;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TextExtractor {
    private static final LanguageExtension<TextExtractor> EP = new LanguageExtension("com.intellij.grazie.textExtractor");
    private static final Key<CachedValue<Set<TextContent>>> CACHE = Key.create((String)"TextExtractor cache");
    private static final Pattern SUPPRESSION = Pattern.compile("\\s*noinspection\\s+([a-zA-Z_0-9.-]+(\\s*,\\s*[a-zA-Z_0-9.-]+)*)\\s*\\w*");

    @Nullable
    protected abstract TextContent buildTextContent(@NotNull PsiElement var1, @NotNull Set<TextContent.TextDomain> var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static TextContent findTextAt(@NotNull PsiElement psi, @NotNull Set<TextContent.TextDomain> allowedDomains) {
        if (psi == null) {
            TextExtractor.$$$reportNull$$$0(0);
        }
        if (allowedDomains == null) {
            TextExtractor.$$$reportNull$$$0(1);
        }
        JBIterable hierarchy = SyntaxTraverser.psiApi().parents((Object)psi);
        for (PsiElement each : hierarchy) {
            CachedValue cache = (CachedValue)each.getUserData(CACHE);
            if (cache == null) continue;
            CachedValue cachedValue = cache;
            synchronized (cachedValue) {
                for (TextContent content2 : (Set)cache.getValue()) {
                    if (!allowedDomains.contains((Object)content2.getDomain()) || !TextExtractor.isSuitable(content2, psi)) continue;
                    return content2;
                }
            }
        }
        Language fileLanguage = psi.getContainingFile().getLanguage();
        for (PsiElement each : hierarchy) {
            TextContent content2;
            RecursionGuard.StackStamp stamp = RecursionManager.markStack();
            Language psiLanguage = each.getLanguage();
            content2 = TextExtractor.doExtract(each, allowedDomains, psiLanguage);
            if (content2 == null && fileLanguage != psiLanguage) {
                content2 = TextExtractor.doExtract(each, allowedDomains, fileLanguage);
            }
            if (content2 != null && stamp.mayCacheNow()) {
                PsiElement parent = content2.getCommonParent();
                CachedValue cache = CachedValuesManager.getManager((Project)parent.getProject()).createCachedValue(() -> CachedValueProvider.Result.create(new LinkedHashSet(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
                CachedValue cachedValue = cache = (CachedValue)((UserDataHolderEx)parent).putUserDataIfAbsent(CACHE, (Object)cache);
                synchronized (cachedValue) {
                    ((Set)cache.getValue()).add(content2);
                }
            }
            if (content2 == null) continue;
            return TextExtractor.isSuitable(content2, psi) ? content2 : null;
        }
        return null;
    }

    private static boolean isSuitable(TextContent content2, PsiElement psi) {
        return content2.intersectsRange(psi.getTextRange()) && !TextExtractor.hasIntersectingInjection(content2, psi.getContainingFile()) && !TextExtractor.isSuppressionComment(content2);
    }

    private static boolean isSuppressionComment(TextContent content2) {
        return content2.getDomain() == TextContent.TextDomain.COMMENTS && SUPPRESSION.matcher(content2).matches();
    }

    @Nullable
    public static TextContent findUniqueTextAt(@NotNull PsiElement psi, @NotNull Set<TextContent.TextDomain> allowedDomains) {
        if (psi == null) {
            TextExtractor.$$$reportNull$$$0(2);
        }
        if (allowedDomains == null) {
            TextExtractor.$$$reportNull$$$0(3);
        }
        if (psi.getFirstChild() != null) {
            return null;
        }
        TextContent extracted = TextExtractor.findTextAt(psi, allowedDomains);
        return extracted != null && psi.getTextRange().contains(extracted.textOffsetToFile(0)) ? extracted : null;
    }

    private static boolean hasIntersectingInjection(TextContent content2, PsiFile file2) {
        return InjectedLanguageManager.getInstance((Project)file2.getProject()).findInjectedElementAt(file2, content2.textOffsetToFile(0)) != null;
    }

    private static TextContent doExtract(@NotNull PsiElement anyRoot, @NotNull Set<TextContent.TextDomain> allowedDomains, @NotNull Language language) {
        TextExtractor extractor;
        if (anyRoot == null) {
            TextExtractor.$$$reportNull$$$0(4);
        }
        if (allowedDomains == null) {
            TextExtractor.$$$reportNull$$$0(5);
        }
        if (language == null) {
            TextExtractor.$$$reportNull$$$0(6);
        }
        if ((extractor = (TextExtractor)EP.forLanguage(language)) != null) {
            TextContent roots = extractor.buildTextContent(anyRoot, allowedDomains);
            return roots != null && allowedDomains.contains((Object)roots.getDomain()) ? roots : null;
        }
        for (GrammarCheckingStrategy strategy : LanguageGrammarChecking.INSTANCE.allForLanguage(language)) {
            GrammarCheckingStrategy.TextDomain oldDomain;
            TextContent.TextDomain domain;
            if (!strategy.isMyContextRoot(anyRoot) || (domain = StrategyTextExtractor.convertDomain(oldDomain = strategy.getContextRootTextDomain(anyRoot))) == null || !allowedDomains.contains((Object)domain)) continue;
            return new StrategyTextExtractor(strategy).extractText(strategy.getRootsChain(anyRoot));
        }
        return null;
    }

    public static Set<Language> getSupportedLanguages() {
        HashSet<Language> result2 = new HashSet<Language>();
        ExtensionPoint ep = ApplicationManager.getApplication().getExtensionArea().getExtensionPoint(EP.getName());
        for (LanguageExtensionPoint point : ep.getExtensionList()) {
            ContainerUtil.addIfNotNull(result2, (Object)Language.findLanguageByID((String)point.language));
        }
        for (LanguageExtensionPoint point : LanguageGrammarChecking.EP_NAME.getExtensionList()) {
            ContainerUtil.addIfNotNull(result2, (Object)Language.findLanguageByID((String)point.language));
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allowedDomains";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anyRoot";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        objectArray2[1] = "com/intellij/grazie/text/TextExtractor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findTextAt";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findUniqueTextAt";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "doExtract";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

