/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.CTypeId;
import com.jetbrains.cidr.lang.types.OCNumericType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class OCRealType
extends OCNumericType {
    public static final OCRealType FLOAT = new OCRealType(CTypeId.FLOAT, "float", "%f", false);
    public static final OCRealType DOUBLE = new OCRealType(CTypeId.DOUBLE, "double", "%lf", false);
    public static final OCRealType LONG_DOUBLE = new OCRealType(CTypeId.LONG_DOUBLE, "long double", "%Lf", false);
    public static final OCRealType COMPLEX_FLOAT = new OCRealType(CTypeId.FLOAT, "float", null, true);
    public static final OCRealType COMPLEX_DOUBLE = new OCRealType(CTypeId.DOUBLE, "double", null, true);
    public static final OCRealType COMPLEX_LONG_DOUBLE = new OCRealType(CTypeId.LONG_DOUBLE, "long double", null, true);
    private static final List<OCRealType> BASIC_TYPES = Arrays.asList(FLOAT, DOUBLE, LONG_DOUBLE);
    private boolean myComplex;
    private String myText;
    private String myFormatString;

    public OCRealType() {
    }

    @NotNull
    public List<OCRealType> getBasicTypes() {
        List<OCRealType> list = BASIC_TYPES;
        if (list == null) {
            OCRealType.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            OCRealType.$$$reportNull$$$0(1);
        }
        if (first == null) {
            OCRealType.$$$reportNull$$$0(2);
        }
        if (second == null) {
            OCRealType.$$$reportNull$$$0(3);
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCRealType f = (OCRealType)first;
        OCRealType s = (OCRealType)second;
        if (!f.myTypeId.equals((Object)s.myTypeId)) {
            return false;
        }
        return Objects.equals(f.myText, s.myText);
    }

    @NotNull
    public static OCRealType literalType(@NotNull String text) {
        char suffix;
        if (text == null) {
            OCRealType.$$$reportNull$$$0(4);
        }
        if ((suffix = text.charAt(text.length() - 1)) == 'l' || suffix == 'L') {
            OCRealType oCRealType = LONG_DOUBLE;
            if (oCRealType == null) {
                OCRealType.$$$reportNull$$$0(5);
            }
            return oCRealType;
        }
        if (suffix == 'f' || suffix == 'F') {
            OCRealType oCRealType = FLOAT;
            if (oCRealType == null) {
                OCRealType.$$$reportNull$$$0(6);
            }
            return oCRealType;
        }
        OCRealType oCRealType = DOUBLE;
        if (oCRealType == null) {
            OCRealType.$$$reportNull$$$0(7);
        }
        return oCRealType;
    }

    public static OCRealType narrowestLiteralType(String text) {
        if (!Character.isDigit(text.charAt(text.length() - 1))) {
            return OCRealType.literalType(text);
        }
        try {
            BigDecimal dbl = new BigDecimal(text, MathContext.DECIMAL64);
            BigDecimal flt = new BigDecimal(text, MathContext.DECIMAL32);
            if (dbl.equals(flt)) {
                return FLOAT;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return DOUBLE;
    }

    private OCRealType(CTypeId precision, String text, String formatString, boolean complex) {
        this(precision, text, formatString, complex, false, false);
    }

    private OCRealType(CTypeId precision, String text, String formatString, boolean complex, boolean isConst, boolean isVolatile) {
        super(isConst, isVolatile);
        this.myFormatString = formatString;
        this.myTypeId = precision;
        this.myText = text;
        this.myComplex = complex;
    }

    public OCRealType cloneType(boolean isConst, boolean isVolatile) {
        return new OCRealType(this.getCTypeId(), this.getText(), this.getFormatString(), this.isComplex(), isConst, isVolatile);
    }

    @Override
    public boolean isComplex() {
        return this.myComplex;
    }

    public String getText() {
        return this.myText;
    }

    public OCRealType cloneWithComplexModifier() {
        if (this.myComplex) {
            return this;
        }
        OCRealType clone = (OCRealType)this.getShallowCopy();
        clone.myComplex = true;
        return clone;
    }

    public OCRealType cloneWithoutComplexModifier() {
        if (!this.myComplex) {
            return this;
        }
        OCRealType clone = (OCRealType)this.getShallowCopy();
        clone.myComplex = false;
        return clone;
    }

    @Override
    public <T> T accept(OCTypeVisitor<T> visitor) {
        return visitor.visitRealType(this);
    }

    @Override
    public int getRank(@NotNull OCResolveContext context) {
        if (context == null) {
            OCRealType.$$$reportNull$$$0(8);
        }
        return this.getSizeInBytes(context.getFile(), null, context.getProject()) << 6;
    }

    @Override
    public boolean isSigned() {
        return true;
    }

    @Override
    public String getFormatString() {
        return this.myFormatString;
    }

    @Override
    @NotNull
    public String getDefaultValue(@NotNull OCResolveContext context) {
        if (context == null) {
            OCRealType.$$$reportNull$$$0(9);
        }
        return "0";
    }

    @Override
    public int hashCode() {
        return (this.myComplex ? 997 : 991) * super.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/types/OCRealType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBasicTypes";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/types/OCRealType";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "literalType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "deepEqualStep";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "literalType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRank";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

