/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.inline;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.jetbrains.cidr.lang.OCRefactoringBundle;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.refactoring.inline.OCInlineActionHandlerBase;
import com.jetbrains.cidr.lang.refactoring.util.OCBindUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class OCInlineConstHandler
extends OCInlineActionHandlerBase<OCDeclarator> {
    @Override
    @NlsSafe
    protected String getElementKind(OCDeclarator element) {
        return "const";
    }

    public boolean canInlineElement(PsiElement element) {
        if (!(element instanceof OCDeclarator)) {
            return false;
        }
        OCSymbol symbol = ((OCDeclarator)element).getSymbol();
        return symbol instanceof OCDeclaratorSymbol && symbol.getKind().isGlobalVariable();
    }

    private static boolean isConstDecltype(@NotNull OCDeclarator element) {
        OCType elemType;
        if (element == null) {
            OCInlineConstHandler.$$$reportNull$$$0(0);
        }
        if (!((elemType = element.getType()) instanceof OCAutoType)) {
            return false;
        }
        OCAutoType autoType = (OCAutoType)elemType;
        OCResolveContext context = OCResolveContext.forPsi(element);
        OCSymbol expressionSymbol = autoType.getDecltypeExpressionSymbol(context);
        if (expressionSymbol instanceof OCDeclaratorSymbol) {
            OCDeclaratorSymbol declaratorSymbol = (OCDeclaratorSymbol)expressionSymbol;
            return declaratorSymbol.isConst();
        }
        return false;
    }

    @Override
    protected String checkValidness(@NotNull OCDeclarator element, @NotNull List<PsiElement> usages, PsiElement selectedUsage, @NotNull String elementNameWithKind, Editor editor, @NotNull Ref<PsiElement> elementData, @NotNull List<String> warnings, boolean silentMode) {
        if (element == null) {
            OCInlineConstHandler.$$$reportNull$$$0(1);
        }
        if (usages == null) {
            OCInlineConstHandler.$$$reportNull$$$0(2);
        }
        if (elementNameWithKind == null) {
            OCInlineConstHandler.$$$reportNull$$$0(3);
        }
        if (elementData == null) {
            OCInlineConstHandler.$$$reportNull$$$0(4);
        }
        if (warnings == null) {
            OCInlineConstHandler.$$$reportNull$$$0(5);
        }
        if (!((OCDeclaratorSymbol)element.getSymbol()).isConst() && !OCInlineConstHandler.isConstDecltype(element)) {
            return OCRefactoringBundle.message("dialog.message.variable.must.be.const", element.getName());
        }
        if (element.getInitializer() == null) {
            return OCRefactoringBundle.message("dialog.message.must.have.initializer", StringUtil.capitalize((String)elementNameWithKind));
        }
        return super.checkValidness(element, usages, selectedUsage, elementNameWithKind, editor, elementData, warnings, silentMode);
    }

    @Override
    protected void inlineUsage(PsiElement usage, OCDeclarator element, PsiElement elementData, Project project, Map<SmartPsiElementPointer, Pair<OCSymbol, OCVisibility>> elemsToEscalateVisibility) {
        if (!(usage instanceof OCReferenceElement)) {
            return;
        }
        OCExpression initializer = element.getInitializer();
        PsiElement expression = usage.getParent();
        assert (initializer != null);
        if (!(expression instanceof OCReferenceExpression)) {
            return;
        }
        TextRange range = initializer.getTextRange();
        PsiFile fileCopy = (PsiFile)initializer.getContainingFile().copy();
        if ((initializer = (OCExpression)OCCodeInsightUtil.findElementAtRange(fileCopy, range, initializer.getClass(), true)) != null) {
            OCBindUtil.encodeContextInfo(initializer, false);
            PsiElement newInitializer = OCParenthesesUtils.replaceExpressionAndAppendParentheses((OCExpression)expression, initializer);
            OCBindUtil.decodeContextInfo(newInitializer, null, elemsToEscalateVisibility);
        }
    }

    @Override
    @NotNull
    protected String getFeatureID() {
        return "refactoring.inlineConst";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementNameWithKind";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementData";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "warnings";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/refactoring/inline/OCInlineConstHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isConstDecltype";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkValidness";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

