/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.cidr.lang.generate.actions.OCActionContext;
import com.jetbrains.cidr.lang.generate.actions.OCObjCActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCClassActionHandlerBase;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCObjCClassTextActionHandlerBase<M extends OCMemberSymbol, C extends OCObjCActionContext<M>>
extends OCClassActionHandlerBase<OCClassSymbol, M, C> {
    protected abstract int getInsertPosition(PsiElement var1, int var2, PsiElement var3, List<M> var4, C var5);

    @NotNull
    protected abstract String getInsertText(@NotNull PsiElement var1, @Nullable PsiElement var2, @NotNull List<M> var3, @NotNull C var4);

    protected boolean shouldSelectResult(@NotNull OCBlockStatement body) {
        if (body == null) {
            OCObjCClassTextActionHandlerBase.$$$reportNull$$$0(0);
        }
        return false;
    }

    @Override
    protected Class<? extends OCSymbolDeclarator> getParentClass() {
        return OCClassDeclaration.class;
    }

    @Override
    protected void performAction(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file, @NotNull C actionContext, @NotNull List<M> chosenCandidates) {
        if (project == null) {
            OCObjCClassTextActionHandlerBase.$$$reportNull$$$0(1);
        }
        if (file == null) {
            OCObjCClassTextActionHandlerBase.$$$reportNull$$$0(2);
        }
        if (actionContext == null) {
            OCObjCClassTextActionHandlerBase.$$$reportNull$$$0(3);
        }
        if (chosenCandidates == null) {
            OCObjCClassTextActionHandlerBase.$$$reportNull$$$0(4);
        }
        LinkedList<PsiFile> files = new LinkedList<PsiFile>();
        for (PsiElement element : (List)this.getElementsToModify(actionContext).getFirst()) {
            files.add(element.getContainingFile());
        }
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])PsiUtilCore.toPsiFileArray(files)).withName(this.getActionTitle()).run(() -> {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.altInsert");
            int caretPos = editor != null ? editor.getCaretModel().getOffset() : -1;
            PsiElement at = null;
            if (editor != null && (at = file.findElementAt(caretPos)) == null) {
                at = file.getLastChild();
            }
            Pair<List<PsiElement>, Integer> pair = this.getElementsToModify(actionContext);
            List elements = (List)pair.getFirst();
            Integer originalElementIndex = (Integer)pair.getSecond();
            for (PsiElement element : elements) {
                if (FileModificationService.getInstance().prepareFileForWrite(element.getContainingFile())) continue;
                return;
            }
            for (int i2 = 0; i2 < elements.size(); ++i2) {
                PsiElement element;
                element = (PsiElement)elements.get(i2);
                if (!element.isValid()) continue;
                VirtualFile virtualFile = element.getContainingFile().getVirtualFile();
                if (virtualFile != null) {
                    CommandProcessor.getInstance().addAffectedFiles(project, new VirtualFile[]{virtualFile});
                }
                if (i2 == originalElementIndex) {
                    this.performAction(project, element, caretPos, at, chosenCandidates, actionContext);
                    continue;
                }
                this.performAction(project, element, -1, null, chosenCandidates, actionContext);
            }
        });
    }

    private Pair<List<PsiElement>, Integer> getElementsToModify(@NotNull C context) {
        if (context == null) {
            OCObjCClassTextActionHandlerBase.$$$reportNull$$$0(5);
        }
        int originalElementIndex = -1;
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
        List<OCSymbol> symbols = ((OCObjCActionContext)context).getSymbolsToModify();
        for (int i2 = 0; i2 < symbols.size(); ++i2) {
            PsiElement declaration;
            OCSymbol symbol = symbols.get(i2);
            if (symbol == null || (declaration = symbol.locateDefinition(((OCActionContext)context).getProject())) == null) continue;
            elements.add(declaration);
            if (!symbol.equals(((OCActionContext)context).getParent())) continue;
            originalElementIndex = i2;
        }
        return new Pair(elements, (Object)originalElementIndex);
    }

    protected void performAction(@NotNull Project project, @NotNull PsiElement element, int caretPos, @Nullable PsiElement at, @NotNull List<M> members, @NotNull C context) {
        if (project == null) {
            OCObjCClassTextActionHandlerBase.$$$reportNull$$$0(6);
        }
        if (element == null) {
            OCObjCClassTextActionHandlerBase.$$$reportNull$$$0(7);
        }
        if (members == null) {
            OCObjCClassTextActionHandlerBase.$$$reportNull$$$0(8);
        }
        if (context == null) {
            OCObjCClassTextActionHandlerBase.$$$reportNull$$$0(9);
        }
        PsiFile file = element.getContainingFile();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        if (document == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
        String insertText = this.getInsertText(element, at, members, context);
        if (insertText.isEmpty()) {
            return;
        }
        int insertOffset = this.getInsertPosition(element, caretPos, at, members, context);
        if (insertOffset == -1) {
            return;
        }
        RangeMarker rangeMarker = document.createRangeMarker(insertOffset, insertOffset);
        rangeMarker.setGreedyToRight(true);
        document.insertString(insertOffset, (CharSequence)insertText);
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        OCChangeUtil.reformatTextIfNotInjected(file, rangeMarker.getStartOffset(), rangeMarker.getEndOffset());
        OCImportSymbolFix.fixAllSymbolsRecursively((PsiElement)file, TextRange.create((Segment)rangeMarker));
        OCCodeInsightUtil.showCallableInEditorAndSelectBody(file, (Segment)rangeMarker, (Condition<? super OCBlockStatement>)((Condition)this::shouldSelectResult));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chosenCandidates";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "members";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/generate/handlers/OCObjCClassTextActionHandlerBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldSelectResult";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "performAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getElementsToModify";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

