/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.editor.completion.CallableInsertUtils;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FunctionDeclarationInsertHandler
implements InsertHandler<LookupElement> {
    @NotNull
    private final OCFunctionSymbol mySymbol;
    private String myInsertion;
    @NonNls
    private static final String CONST = "const";
    @NonNls
    private static final String VOLATILE = "volatile";

    FunctionDeclarationInsertHandler(@NotNull OCFunctionSymbol symbol) {
        if (symbol == null) {
            FunctionDeclarationInsertHandler.$$$reportNull$$$0(0);
        }
        this.mySymbol = symbol;
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        if (context == null) {
            FunctionDeclarationInsertHandler.$$$reportNull$$$0(1);
        }
        if (item == null) {
            FunctionDeclarationInsertHandler.$$$reportNull$$$0(2);
        }
        Project project = context.getProject();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        CaretModel caretModel = context.getEditor().getCaretModel();
        String defaultInsertion = item.getLookupString();
        int caretOffset = caretModel.getOffset() - defaultInsertion.length();
        Document document = context.getDocument();
        String insertion = this.getInsertion(context, item);
        document.replaceString(context.getStartOffset(), context.getTailOffset(), (CharSequence)insertion);
        PsiDocumentManager pdm = PsiDocumentManager.getInstance((Project)project);
        pdm.commitDocument(document);
        OCDeclaration method = (OCDeclaration)PsiTreeUtil.getParentOfType((PsiElement)context.getFile().findElementAt(caretOffset), OCDeclaration.class, (boolean)false);
        boolean hasType = false;
        if (method != null) {
            OCTypeElement typeElement = method.getTypeElement();
            if (typeElement != null && !OCElementUtil.isElementEmpty(typeElement) && method.getDeclarators().size() == 1) {
                OCDeclarator declarator = method.getDeclarators().get(0);
                hasType = this.mySymbol.getName().equals(declarator.getName());
            }
            if (!hasType && !this.mySymbol.getKind().isConstructorOrDestructor()) {
                OCElement before = typeElement != null ? typeElement : method;
                String returnType = this.mySymbol.getEffectiveType(project).getBestNameInContext(method, OCElementUtil.getReturnTypeTextWithModifiers(this.mySymbol, project));
                document.insertString(before.getTextRange().getStartOffset(), (CharSequence)(returnType + " "));
            }
        }
        CallableInsertUtils.moveCaretToCallableBody(context);
        if (context.getCompletionChar() == '{') {
            context.setAddCompletionChar(false);
        }
        OCChangeUtil.reformatTextIfNotInjected(context.getFile(), context.getStartOffset(), context.getStartOffset() + insertion.length());
    }

    private String getInsertion(InsertionContext context, LookupElement item) {
        boolean addEmptyBody = true;
        if (CallableInsertUtils.isReplaceCompletion(context)) {
            CaretModel caretModel = context.getEditor().getCaretModel();
            String defaultInsertion = item.getLookupString();
            int caretOffset = caretModel.getOffset() - defaultInsertion.length();
            OCDeclaration func = (OCDeclaration)PsiTreeUtil.getParentOfType((PsiElement)context.getFile().findElementAt(caretOffset), OCDeclaration.class, (boolean)false);
            if (func instanceof OCFunctionDefinition) {
                context.setTailOffset(((OCFunctionDefinition)func).getBody().getTextRange().getStartOffset());
                addEmptyBody = false;
            }
            if (CallableInsertUtils.isReplaceCompletionBeforeParen(context)) {
                return this.mySymbol.getName();
            }
        }
        assert (this.myInsertion != null);
        return addEmptyBody ? this.myInsertion + "{ }" : this.myInsertion;
    }

    public void calculateInsertion(@NotNull OCResolveContext context) {
        if (context == null) {
            FunctionDeclarationInsertHandler.$$$reportNull$$$0(3);
        }
        StringBuilder insertion = new StringBuilder();
        insertion.append(this.mySymbol.getName());
        insertion.append('(');
        if (!this.mySymbol.getType().hasNoParameters()) {
            List<OCDeclaratorSymbol> params = this.mySymbol.getParameterSymbols();
            for (int i2 = 0; i2 < params.size(); ++i2) {
                OCDeclaratorSymbol param = params.get(i2);
                OCType type = param.getType();
                if (i2 > 0) {
                    insertion.append(", ");
                }
                String name = !param.isUnnamed() ? param.getName() : "";
                insertion.append(type.getBestNameInContext(context)).append(" ").append(name);
            }
        }
        insertion.append(')');
        if (this.mySymbol.getType().isConst()) {
            insertion.append(" ").append(CONST).append(" ");
        }
        if (this.mySymbol.getType().isVolatile()) {
            insertion.append(" ").append(VOLATILE).append(" ");
        }
        this.myInsertion = insertion.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/editor/completion/FunctionDeclarationInsertHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "handleInsert";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateInsertion";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

