/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.codeInsight.highlighting.PairedBraceMatcherAdapter;
import com.intellij.lang.BracePair;
import com.intellij.lang.Language;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCBraceMatcher
extends PairedBraceMatcherAdapter {
    public static final BracePair[] PAIRS = new BracePair[]{new BracePair((IElementType)OCTokenTypes.LPAR, (IElementType)OCTokenTypes.RPAR, false), new BracePair((IElementType)OCTokenTypes.LBRACE, (IElementType)OCTokenTypes.RBRACE, true), new BracePair((IElementType)OCTokenTypes.LBRACKET, (IElementType)OCTokenTypes.RBRACKET, false), new BracePair((IElementType)OCTokenTypes.PROTOCOL_KEYWORD, (IElementType)OCTokenTypes.END_KEYWORD, false), new BracePair((IElementType)OCTokenTypes.INTERFACE_KEYWORD, (IElementType)OCTokenTypes.END_KEYWORD, false), new BracePair((IElementType)OCTokenTypes.IMPLEMENTATION_KEYWORD, (IElementType)OCTokenTypes.END_KEYWORD, false)};
    private static final int CONTEXT_ITERATIONS = 100;
    private static final int CURSOR_OFFSET = -1;

    public boolean isLBraceToken(@NotNull HighlighterIterator iterator, @NotNull CharSequence fileText, @NotNull FileType fileType) {
        if (iterator == null) {
            OCBraceMatcher.$$$reportNull$$$0(0);
        }
        if (fileText == null) {
            OCBraceMatcher.$$$reportNull$$$0(1);
        }
        if (fileType == null) {
            OCBraceMatcher.$$$reportNull$$$0(2);
        }
        if (!super.isLBraceToken(iterator, fileText, fileType)) {
            return false;
        }
        return OCBraceMatcher.braceIsValidForEditorActions(iterator, fileText);
    }

    public boolean isRBraceToken(@NotNull HighlighterIterator iterator, @NotNull CharSequence fileText, @NotNull FileType fileType) {
        if (iterator == null) {
            OCBraceMatcher.$$$reportNull$$$0(3);
        }
        if (fileText == null) {
            OCBraceMatcher.$$$reportNull$$$0(4);
        }
        if (fileType == null) {
            OCBraceMatcher.$$$reportNull$$$0(5);
        }
        if (!super.isRBraceToken(iterator, fileText, fileType)) {
            return false;
        }
        return OCBraceMatcher.braceIsValidForEditorActions(iterator, fileText);
    }

    private static boolean braceIsValidForEditorActions(@NotNull HighlighterIterator bracePosition, @NotNull CharSequence fileText) {
        Editor editor;
        if (bracePosition == null) {
            OCBraceMatcher.$$$reportNull$$$0(6);
        }
        if (fileText == null) {
            OCBraceMatcher.$$$reportNull$$$0(7);
        }
        if ((editor = OCBraceMatcher.getEditor(bracePosition)) == null) {
            return true;
        }
        int braceStart = bracePosition.getStart();
        HighlighterIterator iterator = editor.getHighlighter().createIterator(braceStart);
        boolean validBraceForPairing = true;
        iterator.retreat();
        boolean iteratorInTheSameLineWithBrace = true;
        int count = 0;
        while (!iterator.atEnd()) {
            IElementType ctt = iterator.getTokenType();
            if (ctt == OCTokenTypes.ELSE_DIRECTIVE || ctt == OCTokenTypes.ELIF_DIRECTIVE || OCTokenTypes.IF_DIRECTIVES.contains(ctt)) {
                validBraceForPairing = OCBraceMatcher.cursorInSameSection(editor, fileText, false, braceStart, -1);
                break;
            }
            if (ctt == OCTokenTypes.DEFINE_DIRECTIVE) {
                if (OCBraceMatcher.cursorInSameSection(editor, fileText, true, iterator.getStart(), -1)) {
                    validBraceForPairing = iteratorInTheSameLineWithBrace;
                    break;
                }
                if (OCBraceMatcher.cursorInSameSection(editor, fileText, true, iterator.getStart(), braceStart)) {
                    validBraceForPairing = false;
                    break;
                }
            } else if (ctt == OCTokenTypes.ENDIF_DIRECTIVE && OCBraceMatcher.skipBackwardToStartIfDirective(iterator)) break;
            iteratorInTheSameLineWithBrace &= !OCBraceMatcher.isMultilineWhitespace(iterator, fileText, ctt);
            if (++count > 100) break;
            iterator.retreat();
        }
        return validBraceForPairing;
    }

    private static boolean cursorInSameSection(@NotNull Editor editor, @NotNull CharSequence fileText, boolean newLineIsEndOfSection, int startBrace, int startAnchor) {
        IElementType ctt;
        boolean forward;
        if (editor == null) {
            OCBraceMatcher.$$$reportNull$$$0(8);
        }
        if (fileText == null) {
            OCBraceMatcher.$$$reportNull$$$0(9);
        }
        HighlighterIterator iterator = editor.getHighlighter().createIterator(startBrace);
        if (startAnchor == -1) {
            startAnchor = editor.getCaretModel().getOffset();
        }
        IElementType tt = iterator.getTokenType();
        boolean bl = forward = startAnchor > iterator.getStart();
        do {
            if (forward) {
                iterator.advance();
                if (iterator.atEnd() || startAnchor <= iterator.getStart()) {
                    return true;
                }
            } else {
                iterator.retreat();
                if (iterator.atEnd() || startAnchor >= iterator.getStart()) {
                    return true;
                }
            }
            ctt = iterator.getTokenType();
            if (newLineIsEndOfSection && OCBraceMatcher.isMultilineWhitespace(iterator, fileText, ctt)) {
                return false;
            }
            if (ctt == OCTokenTypes.ELSE_DIRECTIVE || ctt == OCTokenTypes.ELIF_DIRECTIVE) {
                return false;
            }
            if (forward || ctt != OCTokenTypes.ENDIF_DIRECTIVE || !OCBraceMatcher.skipBackwardToStartIfDirective(iterator)) continue;
            return false;
        } while (!forward || !OCTokenTypes.IF_DIRECTIVES.contains(ctt) || !OCBraceMatcher.skipForwardToEndIfDirective(iterator));
        return false;
    }

    private static boolean isMultilineWhitespace(@NotNull HighlighterIterator iterator, @NotNull CharSequence fileText, @NotNull IElementType ctt) {
        if (iterator == null) {
            OCBraceMatcher.$$$reportNull$$$0(10);
        }
        if (fileText == null) {
            OCBraceMatcher.$$$reportNull$$$0(11);
        }
        if (ctt == null) {
            OCBraceMatcher.$$$reportNull$$$0(12);
        }
        return ctt == TokenType.WHITE_SPACE && StringUtil.contains((CharSequence)fileText, (int)iterator.getStart(), (int)iterator.getEnd(), (char)'\n');
    }

    @Nullable
    private static Editor getEditor(@NotNull HighlighterIterator iterator) {
        if (iterator == null) {
            OCBraceMatcher.$$$reportNull$$$0(13);
        }
        if (iterator instanceof LexerEditorHighlighter.HighlighterIteratorImpl && ((LexerEditorHighlighter.HighlighterIteratorImpl)iterator).getClient() instanceof Editor) {
            return (Editor)((LexerEditorHighlighter.HighlighterIteratorImpl)iterator).getClient();
        }
        return null;
    }

    private static boolean skipBackwardToStartIfDirective(@NotNull HighlighterIterator iterator) {
        if (iterator == null) {
            OCBraceMatcher.$$$reportNull$$$0(14);
        }
        iterator.retreat();
        while (!iterator.atEnd() && !OCTokenTypes.IF_DIRECTIVES.contains(iterator.getTokenType())) {
            if (iterator.getTokenType() == OCTokenTypes.ENDIF_DIRECTIVE && OCBraceMatcher.skipBackwardToStartIfDirective(iterator)) {
                return true;
            }
            iterator.retreat();
        }
        return iterator.atEnd();
    }

    private static boolean skipForwardToEndIfDirective(@NotNull HighlighterIterator iterator) {
        if (iterator == null) {
            OCBraceMatcher.$$$reportNull$$$0(15);
        }
        iterator.advance();
        while (!iterator.atEnd() && iterator.getTokenType() != OCTokenTypes.ENDIF_DIRECTIVE) {
            if (OCTokenTypes.IF_DIRECTIVES.contains(iterator.getTokenType()) && OCBraceMatcher.skipForwardToEndIfDirective(iterator)) {
                return true;
            }
            iterator.advance();
        }
        return iterator.atEnd();
    }

    public OCBraceMatcher() {
        super((PairedBraceMatcher)new OCBraceMatcherInner(), (Language)OCLanguage.getInstance());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileText";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bracePosition";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ctt";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/editor/OCBraceMatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isLBraceToken";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isRBraceToken";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "braceIsValidForEditorActions";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "cursorInSameSection";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "isMultilineWhitespace";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getEditor";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "skipBackwardToStartIfDirective";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "skipForwardToEndIfDirective";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class OCBraceMatcherInner
    implements PairedBraceMatcher {
        private OCBraceMatcherInner() {
        }

        public BracePair @NotNull [] getPairs() {
            if (PAIRS == null) {
                OCBraceMatcherInner.$$$reportNull$$$0(0);
            }
            return PAIRS;
        }

        public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType lbraceType, @Nullable IElementType contextType) {
            if (lbraceType == null) {
                OCBraceMatcherInner.$$$reportNull$$$0(1);
            }
            if (contextType instanceof OCElementType) {
                return OCBraceMatcherInner.isPairedBracesAllowedBeforeTypeInJava(contextType);
            }
            return true;
        }

        private static boolean isPairedBracesAllowedBeforeTypeInJava(IElementType tokenType) {
            return OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(tokenType) || tokenType == OCTokenTypes.SEMICOLON || tokenType == OCTokenTypes.COMMA || tokenType == OCTokenTypes.RPAR || tokenType == OCTokenTypes.RBRACKET || tokenType == OCTokenTypes.RBRACE || tokenType == OCTokenTypes.LBRACE;
        }

        public int getCodeConstructStart(PsiFile file, int openingBraceOffset) {
            return openingBraceOffset;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/editor/OCBraceMatcher$OCBraceMatcherInner";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lbraceType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPairs";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/editor/OCBraceMatcher$OCBraceMatcherInner";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isPairedBracesAllowedBeforeType";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

