/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.dnd;

import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDSource;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.dnd.DraggedComponentsTree;
import com.intellij.openapi.graph.builder.dnd.GraphDnDSupport;
import com.intellij.openapi.graph.builder.dnd.SimpleDnDNode;
import com.intellij.openapi.graph.builder.dnd.SimpleDnDPanel;
import com.intellij.openapi.graph.builder.dnd.SimpleGraphDnDStructure;
import com.intellij.openapi.graph.builder.util.NodeFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public final class GraphDnDUtils {
    private GraphDnDUtils() {
    }

    public static <N, E, T> SimpleDnDPanel<T> createDnDActions(Project project, GraphBuilder<N, E> builder, GraphDnDSupport<N, T> support) {
        SimpleGraphDnDStructure graphDnDStructure = GraphDnDUtils.createStructure(project, support);
        final SimpleDnDPanel simpleDnDPanel = new SimpleDnDPanel(graphDnDStructure);
        DnDManager dndManager = DnDManager.getInstance();
        dndManager.registerSource(new MyDnDSource<N, T>(simpleDnDPanel.getTree(), support), (JComponent)((Object)simpleDnDPanel.getTree()));
        dndManager.registerTarget((DnDTarget)new MyDnDTarget<N, E, T>(builder, support){

            @Override
            public void drop(DnDEvent aEvent) {
                super.drop(aEvent);
                simpleDnDPanel.getBuilder().updateFromRoot();
            }
        }, builder.getView().getJComponent());
        Disposer.register(builder, (Disposable)simpleDnDPanel.getBuilder());
        return simpleDnDPanel;
    }

    private static <N, T> SimpleGraphDnDStructure createStructure(Project project, final GraphDnDSupport<N, T> support) {
        final Map<T, Pair<String, Icon>> dnDActions = support.getDnDActions();
        return new SimpleGraphDnDStructure(project){

            protected SimpleDnDNode<T>[] getChildren(Project project) {
                ArrayList<1> nodes = new ArrayList<1>();
                for (Object t : dnDActions.keySet()) {
                    Pair pair = (Pair)dnDActions.get(t);
                    nodes.add(new SimpleDnDNode<T>(project, t, (String)pair.getFirst(), (Icon)pair.getSecond()){

                        @Override
                        public boolean canStartDragging() {
                            return support.canStartDragging(this.getValue());
                        }
                    });
                }
                return nodes.toArray(new SimpleDnDNode[0]);
            }
        };
    }

    private static class MyDnDTarget<N, E, T>
    implements DnDTarget {
        private final GraphBuilder<N, E> myBuilder;
        private final GraphDnDSupport<N, T> mySupport;

        private MyDnDTarget(GraphBuilder<N, E> graphBuilder, GraphDnDSupport<N, T> support) {
            this.myBuilder = graphBuilder;
            this.mySupport = support;
        }

        public boolean update(DnDEvent aEvent) {
            aEvent.setDropPossible(true);
            return false;
        }

        public void drop(DnDEvent aEvent) {
            N nodeObject;
            Object attachedObject = aEvent.getAttachedObject();
            if (attachedObject != null && (nodeObject = this.mySupport.drop(attachedObject)) != null) {
                String nodeName = this.myBuilder.getGraphDataModel().getNodeName(nodeObject);
                NodeFactory.getInstance().createDraggedNode(this.myBuilder, nodeObject, nodeName, aEvent.getPoint());
            }
        }
    }

    private static class MyDnDSource<N, T>
    implements DnDSource {
        private final DraggedComponentsTree myTree;
        private final GraphDnDSupport<N, T> mySupport;

        MyDnDSource(DraggedComponentsTree tree, GraphDnDSupport<N, T> support) {
            this.myTree = tree;
            this.mySupport = support;
        }

        public boolean canStartDragging(DnDAction action, @NotNull Point dragOrigin) {
            SimpleDnDNode selectedNode;
            if (dragOrigin == null) {
                MyDnDSource.$$$reportNull$$$0(0);
            }
            return (selectedNode = (SimpleDnDNode)this.myTree.getSelectedNode()) != null && this.mySupport.canStartDragging(selectedNode.getValue());
        }

        public DnDDragStartBean startDragging(DnDAction action, @NotNull Point point) {
            if (point == null) {
                MyDnDSource.$$$reportNull$$$0(1);
            }
            return new DnDDragStartBean(((SimpleDnDNode)Objects.requireNonNull(this.myTree.getSelectedNode())).getValue());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dragOrigin";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "point";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/graph/builder/dnd/GraphDnDUtils$MyDnDSource";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canStartDragging";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "startDragging";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

