/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.testing.ctest;

import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.runner.GeneralTestEventsProcessor;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.jetbrains.cidr.cpp.execution.testing.ctest.CidrCTestBundle;
import com.jetbrains.cidr.cpp.execution.testing.ctest.CidrCTestProjectTestInfo;
import com.jetbrains.cidr.execution.testing.CidrFromTagInLineToGeneralTestEventsConverter;
import com.jetbrains.cidr.execution.testing.CidrTestEventProcessor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrCTestOutputToGeneralTestEventsConverter
extends CidrFromTagInLineToGeneralTestEventsConverter {
    private static final Logger LOG = Logger.getInstance(CidrCTestOutputToGeneralTestEventsConverter.class);
    @RegExp
    private static final String TIME = "\\s*((?:[0-9]*[.])?[0-9]+) sec\n";
    private final List<CidrCTestProjectTestInfo> myInfos;
    private final Map<String, RunTestInfo> myIndex2RunTestInfo;
    final Stack<String> myWaitForContinuationTestIndex;
    boolean myInitialized;
    String myLastNodeId;

    public CidrCTestOutputToGeneralTestEventsConverter(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties, @NotNull ExecutionConsole console, @Nullable List<CidrCTestProjectTestInfo> infos) {
        if (testFrameworkName == null) {
            CidrCTestOutputToGeneralTestEventsConverter.$$$reportNull$$$0(0);
        }
        if (consoleProperties == null) {
            CidrCTestOutputToGeneralTestEventsConverter.$$$reportNull$$$0(1);
        }
        if (console == null) {
            CidrCTestOutputToGeneralTestEventsConverter.$$$reportNull$$$0(2);
        }
        super(testFrameworkName, consoleProperties, new CidrTestEventProcessor("ctest"), console);
        this.myIndex2RunTestInfo = new HashMap<String, RunTestInfo>();
        this.myWaitForContinuationTestIndex = new Stack();
        this.myInitialized = false;
        this.myLastNodeId = null;
        this.myInfos = infos;
    }

    protected void setupTestTree(@NotNull GeneralTestEventsProcessor processor) {
        if (processor == null) {
            CidrCTestOutputToGeneralTestEventsConverter.$$$reportNull$$$0(3);
        }
        if (this.myInfos == null || this.myInfos.isEmpty()) {
            return;
        }
        for (CidrCTestProjectTestInfo info : this.myInfos) {
            String testName = info.getTestName();
            this.myIndex2RunTestInfo.put(Integer.toString(info.getTestNumber()), new RunTestInfo(testName));
            processor.onSuiteTreeNodeAdded(testName, "ctest://" + testName, null, testName, "0");
        }
        processor.onBuildTreeEnded();
    }

    protected void processLine(@NotNull Key outputType, @NotNull @NlsSafe String text) {
        if (outputType == null) {
            CidrCTestOutputToGeneralTestEventsConverter.$$$reportNull$$$0(4);
        }
        if (text == null) {
            CidrCTestOutputToGeneralTestEventsConverter.$$$reportNull$$$0(5);
        }
        CidrFromTagInLineToGeneralTestEventsConverter.TagWithAttr<Tag> tag = Tag.parse(text);
        GeneralTestEventsProcessor processor = this.getProcessor();
        if (!this.myInitialized) {
            processor.onTestsReporterAttached();
            this.myInitialized = true;
        }
        boolean summaryOutTag = false;
        boolean summaryErrTag = false;
        if (tag == null || (summaryOutTag = tag.getTag() == Tag.TEST_SUMMARY) || (summaryErrTag = tag.getTag() == Tag.TEST_ERR_SUMMARY)) {
            RunTestInfo info;
            RunTestInfo runTestInfo = info = this.myLastNodeId == null || summaryOutTag || summaryErrTag ? null : this.myIndex2RunTestInfo.get(this.myLastNodeId);
            if (info == null) {
                processor.onUncapturedOutput(text, outputType);
            } else {
                String testName = info.myTestName;
                this.process(this.myEventProcessor.testStdOut(testName, testName, outputType, text));
            }
            if (summaryOutTag) {
                this.myLastNodeId = null;
            }
            return;
        }
        Tag etag = (Tag)((Object)tag.getTag());
        switch (etag) {
            case TEST_PRE_START: {
                break;
            }
            case TEST_START: {
                String testName = tag.getAttr(CidrFromTagInLineToGeneralTestEventsConverter.Attr.NAME);
                LOG.assertTrue(testName != null);
                this.myLastNodeId = tag.getAttr(CidrFromTagInLineToGeneralTestEventsConverter.Attr.TEST_ID);
                this.myIndex2RunTestInfo.put(this.myLastNodeId, new RunTestInfo(testName));
                this.process(this.myEventProcessor.testStarted(testName, "0", testName, testName, null));
                break;
            }
            case TEST_FAILED_CONTINUATION: 
            case TEST_EXCEPTION_MESSAGE: {
                String message = tag.getAttr(CidrFromTagInLineToGeneralTestEventsConverter.Attr.MESSAGE);
                if (this.myWaitForContinuationTestIndex.isEmpty()) {
                    processor.onUncapturedOutput(text, outputType);
                    break;
                }
                String testId = this.myWaitForContinuationTestIndex.pop();
                RunTestInfo info = this.myIndex2RunTestInfo.get(testId);
                LOG.assertTrue(info != null);
                String testName = info.myTestName;
                if (message != null) {
                    this.process(this.myEventProcessor.testErrOut(testName, testName, message));
                }
                this.process(this.myEventProcessor.testFinished(testName, testName, String.valueOf(CidrCTestOutputToGeneralTestEventsConverter.parseDuration(tag.getAttr(CidrFromTagInLineToGeneralTestEventsConverter.Attr.TIME))), false));
                break;
            }
            case TEST_FAILED_WITH_EXIT_CODE: 
            case TEST_FAILED_WITH_MESSAGE_CONTINUATION: {
                String testId = tag.getAttr(CidrFromTagInLineToGeneralTestEventsConverter.Attr.TEST_ID);
                RunTestInfo info = this.myIndex2RunTestInfo.get(testId);
                LOG.assertTrue(info != null);
                info.mySuccess = false;
                String testName = tag.getAttr(CidrFromTagInLineToGeneralTestEventsConverter.Attr.NAME);
                String message = tag.getAttr(CidrFromTagInLineToGeneralTestEventsConverter.Attr.MESSAGE);
                if (message != null && testName != null) {
                    this.process(this.myEventProcessor.testErrOut(testName, testName, message));
                }
                this.myWaitForContinuationTestIndex.push(testId);
                break;
            }
            case TEST_FAILED_WITH_MESSAGE: 
            case TEST_PASSED: {
                String testId = tag.getAttr(CidrFromTagInLineToGeneralTestEventsConverter.Attr.TEST_ID);
                RunTestInfo info = this.myIndex2RunTestInfo.get(testId);
                LOG.assertTrue(info != null);
                String testName = info.myTestName;
                LOG.assertTrue(testName != null);
                long durationInMs = CidrCTestOutputToGeneralTestEventsConverter.parseDuration(tag.getAttr(CidrFromTagInLineToGeneralTestEventsConverter.Attr.TIME));
                if (etag == Tag.TEST_FAILED_WITH_MESSAGE) {
                    info.mySuccess = false;
                    String message = tag.getAttr(CidrFromTagInLineToGeneralTestEventsConverter.Attr.MESSAGE);
                    if (message != null) {
                        this.process(this.myEventProcessor.testErrOut(testName, testName, message));
                    }
                }
                boolean succeeded = info.mySuccess;
                this.process(this.myEventProcessor.testFinished(testName, testName, String.valueOf(durationInMs), succeeded));
                break;
            }
            case TEST_OUT: {
                RunTestInfo info = this.myIndex2RunTestInfo.get(tag.getAttr(CidrFromTagInLineToGeneralTestEventsConverter.Attr.TEST_ID));
                if (info == null) {
                    processor.onUncapturedOutput(text, outputType);
                    break;
                }
                String testName = info.myTestName;
                String message = tag.getAttr(CidrFromTagInLineToGeneralTestEventsConverter.Attr.MESSAGE);
                if (message == null) break;
                this.process(this.myEventProcessor.testStdOut(testName, testName, outputType, message));
                break;
            }
        }
    }

    private static long parseDuration(@Nullable String duration) {
        if (duration != null) {
            try {
                float durationInSec = Float.parseFloat(duration);
                return (long)(durationInSec * 1000.0f);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0L;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFrameworkName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleProperties";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/cpp/execution/testing/ctest/CidrCTestOutputToGeneralTestEventsConverter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setupTestTree";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "processLine";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static enum Tag {
        TEST_PRE_START("test ([0-9]+)\n"),
        TEST_START("\\s*Start\\s+([0-9]+):\\s+(.*)\\s*\n"),
        TEST_PASSED(".* Test\\s+#([0-9]+):\\s+(.*)\\s+[.]+\\s*Passed\\s*((?:[0-9]*[.])?[0-9]+) sec\n"),
        TEST_FAILED_WITH_EXIT_CODE(".* Test\\s+#([0-9]+):\\s+(.*)\\s+[.]+Exit code\\s*(.*)\n"),
        TEST_FAILED_WITH_MESSAGE(".* Test\\s+#([0-9]+):\\s+(.*)\\s+[.]+(.*?)[*]{3}(.*?)\\s*((?:[0-9]*[.])?[0-9]+) sec\n"),
        TEST_FAILED_WITH_MESSAGE_CONTINUATION(".* Test\\s+#([0-9]+):\\s+(.*)\\s+[.]+(.*?)[*]{3}(.*)\n"),
        TEST_EXCEPTION_MESSAGE("[*]{3}(.*?)\\s*((?:[0-9]*[.])?[0-9]+) sec\n"),
        TEST_FAILED_CONTINUATION("(.*?)\\s*((?:[0-9]*[.])?[0-9]+) sec\n"),
        TEST_OUT("([0-9]+):(.*)\n"),
        TEST_ERR_SUMMARY("Errors while running CTest\n"),
        TEST_SUMMARY("[0-9]+% tests passed, [0-9]+ tests failed out of [0-9]+\n");

        private final Pattern myTagPattern;

        private Tag(String pattern) {
            if (pattern == null) {
                Tag.$$$reportNull$$$0(0);
            }
            this.myTagPattern = Pattern.compile(pattern);
        }

        @Nullable
        public static CidrFromTagInLineToGeneralTestEventsConverter.TagWithAttr<Tag> parse(@NotNull String line) {
            if (line == null) {
                Tag.$$$reportNull$$$0(1);
            }
            for (Tag tag : Tag.values()) {
                Matcher matcher = tag.myTagPattern.matcher(line);
                if (!matcher.matches()) continue;
                HashMap<CidrFromTagInLineToGeneralTestEventsConverter.Attr, Object> attrs = new HashMap<CidrFromTagInLineToGeneralTestEventsConverter.Attr, Object>();
                switch (tag) {
                    case TEST_PRE_START: {
                        attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.TEST_ID, matcher.group(1));
                        break;
                    }
                    case TEST_START: {
                        attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.TEST_ID, matcher.group(1));
                        attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.NAME, matcher.group(2));
                        break;
                    }
                    case TEST_FAILED_WITH_EXIT_CODE: {
                        attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.TEST_ID, matcher.group(1));
                        attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.NAME, matcher.group(2));
                        attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.MESSAGE, "\n" + CidrCTestBundle.message("ctest.run.message.terminate", matcher.group(3)) + "\n");
                        break;
                    }
                    case TEST_FAILED_CONTINUATION: 
                    case TEST_EXCEPTION_MESSAGE: {
                        attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.MESSAGE, "\n" + matcher.group(1) + "\n");
                        attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.TIME, matcher.group(2));
                        break;
                    }
                    case TEST_FAILED_WITH_MESSAGE: {
                        attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.TIME, matcher.group(5));
                    }
                    case TEST_FAILED_WITH_MESSAGE_CONTINUATION: {
                        attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.TEST_ID, matcher.group(1));
                        attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.NAME, matcher.group(2));
                        attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.MESSAGE, matcher.group(4) + matcher.group(3) + "\n");
                        break;
                    }
                    case TEST_PASSED: {
                        attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.TEST_ID, matcher.group(1));
                        attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.NAME, matcher.group(2));
                        attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.TIME, matcher.group(3));
                        break;
                    }
                    case TEST_OUT: {
                        attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.TEST_ID, matcher.group(1));
                        attrs.put(CidrFromTagInLineToGeneralTestEventsConverter.Attr.MESSAGE, line);
                        break;
                    }
                }
                return new CidrFromTagInLineToGeneralTestEventsConverter.TagWithAttr((Object)tag, attrs);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/cpp/execution/testing/ctest/CidrCTestOutputToGeneralTestEventsConverter$Tag";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parse";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class RunTestInfo {
        public final String myTestName;
        public boolean mySuccess;

        RunTestInfo(@NotNull String name) {
            if (name == null) {
                RunTestInfo.$$$reportNull$$$0(0);
            }
            this.myTestName = name;
            this.mySuccess = true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/cpp/execution/testing/ctest/CidrCTestOutputToGeneralTestEventsConverter$RunTestInfo", "<init>"));
        }
    }
}

