/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.UIBundle;
import com.intellij.util.ObjectUtils;
import com.intellij.util.net.HttpConfigurable;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IOExceptionDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(IOExceptionDialog.class);
    private final JTextArea myErrorLabel;

    public IOExceptionDialog(@NlsContexts.DialogTitle String title, String errorText) {
        super((Project)null, true);
        this.setTitle(title);
        this.setOKButtonText(UIBundle.message("io.error.dialog.retry", new Object[0]));
        this.myErrorLabel = new JTextArea();
        this.myErrorLabel.setEditable(false);
        this.myErrorLabel.setText(errorText);
        this.myErrorLabel.setLineWrap(true);
        this.myErrorLabel.setWrapStyleWord(true);
        this.myErrorLabel.setFont(UIManager.getFont("Label.font"));
        this.myErrorLabel.setBackground(UIManager.getColor("Label.background"));
        this.myErrorLabel.setForeground(UIManager.getColor("Label.foreground"));
        this.init();
    }

    @Override
    @Nullable
    protected JComponent createCenterPanel() {
        return this.myErrorLabel;
    }

    @Override
    protected Action @NotNull [] createLeftSideActions() {
        Action[] actionArray = new Action[]{new AbstractAction(UIBundle.message("io.error.dialog.no.proxy", new Object[0])){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                HttpConfigurable.editConfigurable((JComponent)ObjectUtils.tryCast((Object)e.getSource(), JComponent.class));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/net/IOExceptionDialog$1", "actionPerformed"));
            }
        }};
        if (actionArray == null) {
            IOExceptionDialog.$$$reportNull$$$0(0);
        }
        return actionArray;
    }

    public static boolean showErrorDialog(@NlsContexts.DialogTitle String title, @NlsContexts.DetailedDescription String text2) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw new RuntimeException(title + ": " + text2);
        }
        Ref ok = new Ref((Object)false);
        try {
            ApplicationManager.getApplication().invokeAndWait(() -> {
                IOExceptionDialog dialog = new IOExceptionDialog(title, text2);
                dialog.show();
                ok.set((Object)dialog.isOK());
            });
        }
        catch (RuntimeException e) {
            LOG.info((Throwable)e);
        }
        return (Boolean)ok.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/net/IOExceptionDialog", "createLeftSideActions"));
    }
}

