/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actionSystem;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionHandlerBean;
import com.intellij.openapi.extensions.ExtensionPointName;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DynamicEditorActionHandler
extends EditorActionHandler {
    private static final List<EditorActionHandler> UPDATE_MARKER = new ArrayList<EditorActionHandler>();
    private static final ExtensionPointName<EditorActionHandlerBean> EDITOR_ACTION_HANDLER_EP = new ExtensionPointName("com.intellij.editorActionHandler");
    private final EditorAction myAction;
    private final EditorActionHandler myBaseHandler;
    private final AtomicReference<List<EditorActionHandler>> myCachedChain;
    private boolean myWorksInInjected;

    DynamicEditorActionHandler(@NotNull EditorAction editorAction, @NotNull EditorActionHandler baseHandler) {
        if (editorAction == null) {
            DynamicEditorActionHandler.$$$reportNull$$$0(0);
        }
        if (baseHandler == null) {
            DynamicEditorActionHandler.$$$reportNull$$$0(1);
        }
        this.myCachedChain = new AtomicReference();
        this.myAction = editorAction;
        this.myBaseHandler = baseHandler;
    }

    @Override
    public boolean runForAllCarets() {
        return this.getHandler().runForAllCarets();
    }

    @Override
    public boolean isEnabled(Editor editor, DataContext dataContext) {
        return this.getHandler().isEnabled(editor, dataContext);
    }

    @Override
    protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        if (editor == null) {
            DynamicEditorActionHandler.$$$reportNull$$$0(2);
        }
        if (caret == null) {
            DynamicEditorActionHandler.$$$reportNull$$$0(3);
        }
        return this.getHandler().isEnabledForCaret(editor, caret, dataContext);
    }

    @Override
    public void execute(@NotNull Editor editor, @Nullable DataContext dataContext) {
        if (editor == null) {
            DynamicEditorActionHandler.$$$reportNull$$$0(4);
        }
        this.getHandler().execute(editor, dataContext);
    }

    @Override
    protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
        if (editor == null) {
            DynamicEditorActionHandler.$$$reportNull$$$0(5);
        }
        this.getHandler().doExecute(editor, caret, dataContext);
    }

    @Override
    public boolean executeInCommand(@NotNull Editor editor, DataContext dataContext) {
        if (editor == null) {
            DynamicEditorActionHandler.$$$reportNull$$$0(6);
        }
        return this.getHandler().executeInCommand(editor, dataContext);
    }

    @Override
    public DocCommandGroupId getCommandGroupId(@NotNull Editor editor) {
        if (editor == null) {
            DynamicEditorActionHandler.$$$reportNull$$$0(7);
        }
        return this.getHandler().getCommandGroupId(editor);
    }

    @Override
    synchronized void setWorksInInjected(boolean worksInInjected) {
        super.setWorksInInjected(worksInInjected);
        this.myWorksInInjected = worksInInjected;
        this.clearCache();
    }

    @Override
    @Nullable
    <T> T getHandlerOfType(@NotNull Class<T> type) {
        if (type == null) {
            DynamicEditorActionHandler.$$$reportNull$$$0(8);
        }
        List<EditorActionHandler> chain = this.getHandlerChain();
        for (int i = chain.size() - 1; i >= 0; --i) {
            T handler = chain.get(i).getHandlerOfType(type);
            if (handler == null) continue;
            return handler;
        }
        return null;
    }

    @Nullable
    private EditorActionHandler getHandler() {
        List<EditorActionHandler> list = this.getHandlerChain();
        return list.isEmpty() ? null : list.get(list.size() - 1);
    }

    @NotNull
    private synchronized List<EditorActionHandler> getHandlerChain() {
        List<EditorActionHandler> cachedChain = this.myCachedChain.get();
        if (cachedChain != null && cachedChain != UPDATE_MARKER) {
            List<EditorActionHandler> list = cachedChain;
            if (list == null) {
                DynamicEditorActionHandler.$$$reportNull$$$0(9);
            }
            return list;
        }
        this.myCachedChain.set(UPDATE_MARKER);
        List<EditorActionHandlerBean> handlerBeans = DynamicEditorActionHandler.getRegisteredHandlers(this.myAction);
        ArrayList<EditorActionHandler> chain = new ArrayList<EditorActionHandler>(handlerBeans.size());
        chain.add(this.myBaseHandler);
        Application container = ApplicationManager.getApplication();
        for (EditorActionHandlerBean bean : handlerBeans) {
            EditorActionHandler handler;
            EditorActionHandler param = chain.isEmpty() ? null : (EditorActionHandler)chain.get(chain.size() - 1);
            try {
                Constructor constructor;
                Class beanImplementationClass = container.loadClass(bean.implementationClass, bean.pluginDescriptor);
                try {
                    constructor = beanImplementationClass.getDeclaredConstructor(EditorActionHandler.class);
                }
                catch (NoSuchMethodException ignore) {
                    constructor = null;
                }
                if (constructor == null) {
                    constructor = beanImplementationClass.getDeclaredConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    handler = (EditorActionHandler)constructor.newInstance(new Object[0]);
                } else {
                    constructor.setAccessible(true);
                    handler = (EditorActionHandler)constructor.newInstance(param);
                }
            }
            catch (Exception e) {
                Logger.getInstance(EditorActionHandlerBean.class).error((Throwable)new PluginException(e, bean.pluginDescriptor.getPluginId()));
                continue;
            }
            handler.setWorksInInjected(this.myWorksInInjected);
            chain.add(handler);
        }
        this.myCachedChain.compareAndSet(UPDATE_MARKER, chain);
        ArrayList<EditorActionHandler> arrayList = chain;
        if (arrayList == null) {
            DynamicEditorActionHandler.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @NotNull
    private static List<EditorActionHandlerBean> getRegisteredHandlers(@NotNull EditorAction editorAction) {
        String id;
        if (editorAction == null) {
            DynamicEditorActionHandler.$$$reportNull$$$0(11);
        }
        if ((id = ActionManager.getInstance().getId(editorAction)) == null) {
            List<EditorActionHandlerBean> list = Collections.emptyList();
            if (list == null) {
                DynamicEditorActionHandler.$$$reportNull$$$0(12);
            }
            return list;
        }
        List extensions2 = EDITOR_ACTION_HANDLER_EP.getExtensionList();
        ArrayList<EditorActionHandlerBean> result = new ArrayList<EditorActionHandlerBean>();
        for (int i = extensions2.size() - 1; i >= 0; --i) {
            EditorActionHandlerBean handlerBean = (EditorActionHandlerBean)extensions2.get(i);
            if (!handlerBean.action.equals(id)) continue;
            result.add(handlerBean);
        }
        ArrayList<EditorActionHandlerBean> arrayList = result;
        if (arrayList == null) {
            DynamicEditorActionHandler.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    void clearCache() {
        this.myCachedChain.set(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseHandler";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/actionSystem/DynamicEditorActionHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/actionSystem/DynamicEditorActionHandler";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandlerChain";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegisteredHandlers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledForCaret";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doExecute";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "executeInCommand";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCommandGroupId";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getHandlerOfType";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getRegisteredHandlers";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

