/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TemplateActionContext {
    @NotNull
    private final PsiFile myFile;
    @Nullable
    private final Editor myEditor;
    private final int myStartOffset;
    private final int myEndOffset;
    private final boolean myIsSurrounding;

    private TemplateActionContext(@NotNull PsiFile file, @Nullable Editor editor, int startOffset, int endOffset, boolean isSurrounding) {
        if (file == null) {
            TemplateActionContext.$$$reportNull$$$0(0);
        }
        this.myFile = file;
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
        this.myIsSurrounding = isSurrounding;
        this.myEditor = editor;
    }

    @NotNull
    public PsiFile getFile() {
        PsiFile psiFile = this.myFile;
        if (psiFile == null) {
            TemplateActionContext.$$$reportNull$$$0(1);
        }
        return psiFile;
    }

    @ApiStatus.Internal
    @Nullable
    public Editor getEditor() {
        return this.myEditor;
    }

    public boolean isSurrounding() {
        return this.myIsSurrounding;
    }

    @NotNull
    public TemplateActionContext withFile(@NotNull PsiFile file) {
        if (file == null) {
            TemplateActionContext.$$$reportNull$$$0(2);
        }
        return new TemplateActionContext(file, this.myEditor, this.myStartOffset, this.myEndOffset, this.myIsSurrounding);
    }

    public int getStartOffset() {
        return this.myStartOffset;
    }

    public int getEndOffset() {
        return this.myEndOffset;
    }

    @NotNull
    public static TemplateActionContext expanding(@NotNull PsiFile psiFile, @NotNull Editor editor) {
        if (psiFile == null) {
            TemplateActionContext.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            TemplateActionContext.$$$reportNull$$$0(4);
        }
        int editorOffset = editor.getCaretModel().getOffset();
        return TemplateActionContext.create(psiFile, editor, editorOffset, editorOffset, false);
    }

    @NotNull
    public static TemplateActionContext expanding(@NotNull PsiFile psiFile, int offset) {
        if (psiFile == null) {
            TemplateActionContext.$$$reportNull$$$0(5);
        }
        return TemplateActionContext.create(psiFile, null, offset, offset, false);
    }

    @NotNull
    public static TemplateActionContext surrounding(@NotNull PsiFile psiFile, @NotNull Editor editor) {
        PsiElement endElement;
        if (psiFile == null) {
            TemplateActionContext.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            TemplateActionContext.$$$reportNull$$$0(7);
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        int start = selectionModel.getSelectionStart();
        int end = selectionModel.getSelectionEnd();
        PsiElement startElement = psiFile.findElementAt(start);
        if (startElement instanceof PsiWhiteSpace) {
            start = Math.min(startElement.getTextRange().getEndOffset(), end);
        }
        if ((endElement = psiFile.findElementAt(end)) != startElement && endElement instanceof PsiWhiteSpace) {
            end = Math.max(start, endElement.getTextRange().getStartOffset());
        }
        return TemplateActionContext.create(psiFile, editor, start, end, true);
    }

    @NotNull
    public static TemplateActionContext create(@NotNull PsiFile psiFile, @Nullable Editor editor, int startOffset, int endOffset, boolean isSurrounding) {
        if (psiFile == null) {
            TemplateActionContext.$$$reportNull$$$0(8);
        }
        return new TemplateActionContext(psiFile, editor, startOffset, endOffset, isSurrounding);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/TemplateActionContext";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/TemplateActionContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "withFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "expanding";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "surrounding";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

