/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.pattern;

import com.intellij.copyright.CopyrightManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.maddyhome.idea.copyright.pattern.CommentInfo;
import com.maddyhome.idea.copyright.pattern.CopyrightVariablesProvider;
import com.maddyhome.idea.copyright.pattern.CopyrightVariablesProviders;
import com.maddyhome.idea.copyright.pattern.DateInfo;
import com.maddyhome.idea.copyright.pattern.FileInfo;
import com.maddyhome.idea.copyright.pattern.ModuleInfo;
import com.maddyhome.idea.copyright.pattern.ProjectInfo;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.log.SimpleLog4JLogSystem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VelocityHelper {
    private static VelocityEngine instance;

    public static String evaluate(@Nullable PsiFile file, @Nullable Project project, @Nullable Module module, @NotNull String template) {
        if (template == null) {
            VelocityHelper.$$$reportNull$$$0(0);
        }
        return VelocityHelper.evaluate(file, project, module, template, null);
    }

    public static String evaluate(@Nullable PsiFile file, @Nullable Project project, @Nullable Module module, @NotNull String template, @Nullable String oldComment) {
        CopyrightVariablesProvider variablesProvider;
        VirtualFile virtualFile;
        if (template == null) {
            VelocityHelper.$$$reportNull$$$0(1);
        }
        VelocityEngine engine = VelocityHelper.getEngine();
        VelocityContext vc = new VelocityContext();
        vc.put("today", (Object)new DateInfo());
        if (file != null) {
            vc.put("file", (Object)new FileInfo(file));
        }
        if (project != null) {
            vc.put("project", (Object)new ProjectInfo(project));
        }
        if (module != null) {
            vc.put("module", (Object)new ModuleInfo(module));
        }
        vc.put("username", (Object)System.getProperty("user.name"));
        vc.put("originalComment", (Object)new CommentInfo(oldComment));
        if (file != null && (virtualFile = PsiUtilCore.getVirtualFile((PsiElement)file)) != null && (variablesProvider = (CopyrightVariablesProvider)CopyrightVariablesProviders.INSTANCE.forFileType(virtualFile.getFileType())) != null) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            variablesProvider.collectVariables(context, project, module, file);
            for (Map.Entry entry : context.entrySet()) {
                vc.put((String)entry.getKey(), entry.getValue());
            }
        }
        try {
            StringWriter sw = new StringWriter();
            boolean stripLineBreak = false;
            if (((String)template).endsWith("$")) {
                template = (String)template + VelocityHelper.getVelocitySuffix();
                stripLineBreak = true;
            }
            engine.evaluate((Context)vc, (Writer)sw, CopyrightManager.class.getName(), (String)template);
            String result = sw.getBuffer().toString();
            return stripLineBreak ? StringUtil.trimEnd((String)result, (String)VelocityHelper.getVelocitySuffix()) : result;
        }
        catch (Exception e) {
            return "";
        }
    }

    private static String getVelocitySuffix() {
        return "\n";
    }

    public static void verify(String text) throws Exception {
        VelocityEngine engine = VelocityHelper.getEngine();
        VelocityContext vc = new VelocityContext();
        vc.put("today", (Object)new DateInfo());
        StringWriter sw = new StringWriter();
        if (((String)text).endsWith("$")) {
            text = (String)text + VelocityHelper.getVelocitySuffix();
        }
        engine.evaluate((Context)vc, (Writer)sw, CopyrightManager.class.getName(), (String)text);
    }

    private static synchronized VelocityEngine getEngine() {
        if (instance == null) {
            try {
                VelocityEngine engine = new VelocityEngine();
                ExtendedProperties extendedProperties = new ExtendedProperties();
                extendedProperties.addProperty("resource.loader", (Object)"file");
                extendedProperties.addProperty("parser.pool.size", (Object)"1");
                extendedProperties.addProperty("file.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.FileResourceLoader");
                extendedProperties.addProperty("file.resource.loader.path", (Object)(PathManager.getPluginsPath() + "/Copyright/resources"));
                extendedProperties.addProperty("runtime.log.logsystem.class", (Object)SimpleLog4JLogSystem.class.getName());
                extendedProperties.addProperty("runtime.log.logsystem.log4j.category", (Object)CopyrightManager.class.getName());
                engine.setExtendedProperties(extendedProperties);
                engine.init();
                instance = engine;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return instance;
    }

    private VelocityHelper() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/maddyhome/idea/copyright/pattern/VelocityHelper", "evaluate"));
    }
}

