/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.coverage.gcov;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.cidr.execution.coverage.CidrCoverageBundle;
import com.jetbrains.cidr.execution.coverage.CidrCoverageComposer;
import com.jetbrains.cidr.execution.coverage.CidrCoverageDataFileProvider;
import com.jetbrains.cidr.execution.coverage.CidrCoverageLogKt;
import com.jetbrains.cidr.execution.coverage.CidrCoverageUtil;
import com.jetbrains.cidr.execution.coverage.gcov.GCovCoverageComposer;
import com.jetbrains.cidr.execution.coverage.gcov.GCovCoverageToolProvider;
import com.jetbrains.cidr.execution.coverage.gcov.GCovUtils;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.system.HostMachine;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J0\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\bH\u0002J8\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageComposer;", "Lcom/jetbrains/cidr/execution/coverage/CidrCoverageComposer;", "()V", "afterProcessTerminated", "", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "environment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "event", "Lcom/intellij/execution/process/ProcessEvent;", "context", "Lcom/intellij/openapi/util/UserDataHolder;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "beforeProcessExecution", "cmdLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "getCoverageRootDirectory", "", "getOrCreateOutputCoverageDirectory", "Ljava/nio/file/Path;", "rootDirectory", "moveGcovFilesToOutputDirWithUniquePrefix", "targetDirectory", "processGcdaFile", "inputFile", "workingDirectory", "toolsProvider", "Lcom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageToolProvider;", "intellij.cidr.coverage"})
public class GCovCoverageComposer
extends CidrCoverageComposer {
    @Override
    public void beforeProcessExecution(@NotNull RunConfiguration configuration, @NotNull CidrToolEnvironment environment2, @NotNull GeneralCommandLine cmdLine, @NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)cmdLine, (String)"cmdLine");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void afterProcessTerminated(@NotNull RunConfiguration configuration, @NotNull CidrToolEnvironment environment2, @NotNull ProcessEvent event, @NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) {
        Path it;
        Object element$iv$iv2;
        void $this$groupByTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        String rootDirectory = this.getCoverageRootDirectory(configuration);
        if (rootDirectory == null) {
            CidrCoverageLogKt.getCidrCoverageLog().debug("gcov coverage root directory is null or not found");
            return;
        }
        Path path = environment2.getHostMachine().getPath(rootDirectory, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"environment.hostMachine.getPath(rootDirectory)");
        Path rootDirectoryPath = path;
        HostMachine hostMachine = environment2.getHostMachine();
        Intrinsics.checkNotNullExpressionValue((Object)hostMachine, (String)"environment.hostMachine");
        List<Path> gcdaFiles = GCovUtils.Companion.getGCDAFiles(hostMachine, rootDirectoryPath, true);
        GCovCoverageToolProvider gCovCoverageToolProvider = GCovCoverageToolProvider.Companion.getInstance(configuration);
        if (gCovCoverageToolProvider == null) {
            throw (Throwable)new ExecutionException(CidrCoverageBundle.message("gcov.tools.missing", new Object[0]));
        }
        GCovCoverageToolProvider toolsProvider = gCovCoverageToolProvider;
        Iterable $this$groupBy$iv = gcdaFiles;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo22 = false;
        for (Object element$iv$iv2 : $this$groupByTo$iv$iv2) {
            Object object;
            it = (Path)element$iv$iv2;
            boolean bl = false;
            String key$iv$iv = new File(((Object)it).toString()).getName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv2);
        }
        Map gcdaFilesGroupedByFileName = destination$iv$iv;
        $i$f$groupBy = false;
        List gcdaFilesToParallelProcess = new ArrayList();
        boolean $this$groupByTo$iv$iv2 = false;
        List gcdaFilesToSequentialProcess = new ArrayList();
        Map $this$forEach$iv = gcdaFilesGroupedByFileName;
        boolean $i$f$forEach = false;
        Map $i$f$groupByTo22 = $this$forEach$iv;
        boolean bl = false;
        element$iv$iv2 = $i$f$groupByTo22.entrySet().iterator();
        while (element$iv$iv2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = (Map.Entry)element$iv$iv2.next();
            boolean bl3 = false;
            if (((List)entry.getValue()).size() == 1) {
                gcdaFilesToParallelProcess.add(((List)entry.getValue()).get(0));
                continue;
            }
            gcdaFilesToSequentialProcess.addAll((Collection)entry.getValue());
        }
        CidrCoverageLogKt.getCidrCoverageLog().info("Number of .gcov files for parallel processing: " + gcdaFilesToParallelProcess.size());
        CidrCoverageLogKt.getCidrCoverageLog().info("Number of .gcov files for sequential processing: " + gcdaFilesToSequentialProcess.size());
        gcdaFilesToParallelProcess.parallelStream().forEach(new Consumer(this, rootDirectory, indicator, configuration, environment2, toolsProvider){
            final /* synthetic */ GCovCoverageComposer this$0;
            final /* synthetic */ String $rootDirectory;
            final /* synthetic */ ProgressIndicator $indicator;
            final /* synthetic */ RunConfiguration $configuration;
            final /* synthetic */ CidrToolEnvironment $environment;
            final /* synthetic */ GCovCoverageToolProvider $toolsProvider;

            public final void accept(Path it) {
                GCovCoverageComposer.access$processGcdaFile(this.this$0, ((Object)it).toString(), this.$rootDirectory, this.$indicator, this.$configuration, this.$environment, this.$toolsProvider);
            }
            {
                this.this$0 = gCovCoverageComposer;
                this.$rootDirectory = string;
                this.$indicator = progressIndicator;
                this.$configuration = runConfiguration;
                this.$environment = cidrToolEnvironment;
                this.$toolsProvider = gCovCoverageToolProvider;
            }
        });
        indicator.checkCanceled();
        Path outputDirectoryPath = this.getOrCreateOutputCoverageDirectory(rootDirectoryPath, environment2);
        HostMachine hostMachine2 = environment2.getHostMachine();
        Intrinsics.checkNotNullExpressionValue((Object)hostMachine2, (String)"environment.hostMachine");
        if (!CidrCoverageUtil.Companion.moveFilesWithExtensionInBatchMode(hostMachine2, ".gcov", rootDirectoryPath, outputDirectoryPath)) {
            throw (Throwable)new ExecutionException(CidrCoverageBundle.message("coverage.failed.to.move.files", new Object[0]));
        }
        Iterable $this$forEach$iv2 = gcdaFilesToSequentialProcess;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            it = (Path)element$iv;
            boolean bl4 = false;
            this.processGcdaFile(((Object)it).toString(), rootDirectory, indicator, configuration, environment2, toolsProvider);
            this.moveGcovFilesToOutputDirWithUniquePrefix(rootDirectoryPath, outputDirectoryPath, environment2);
        }
    }

    private final Path getOrCreateOutputCoverageDirectory(Path rootDirectory, CidrToolEnvironment environment2) {
        String string = FileUtil.join((String[])new String[]{((Object)rootDirectory).toString(), "coverage"});
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FileUtil.join(rootDirect\u2026y.toString(), \"coverage\")");
        String outputDirectory = string;
        Path path = environment2.getHostMachine().getPath(outputDirectory, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"environment.hostMachine.getPath(outputDirectory)");
        Path outputDirectoryPath = path;
        if (!Files.exists(outputDirectoryPath, new LinkOption[0])) {
            Files.createDirectory(outputDirectoryPath, new FileAttribute[0]);
        }
        return outputDirectoryPath;
    }

    private final void moveGcovFilesToOutputDirWithUniquePrefix(Path rootDirectory, Path targetDirectory, CidrToolEnvironment environment2) {
        Files.list(rootDirectory).filter(moveGcovFilesToOutputDirWithUniquePrefix.1.INSTANCE).forEach(new Consumer(environment2, targetDirectory){
            final /* synthetic */ CidrToolEnvironment $environment;
            final /* synthetic */ Path $targetDirectory;

            public final void accept(Path it) {
                String fileName = new File(((Object)it).toString()).getName();
                String newFileName = UUID.randomUUID().toString() + "#" + fileName;
                Files.move(it, this.$environment.getHostMachine().getPath(((Object)this.$targetDirectory).toString(), new String[]{newFileName}), StandardCopyOption.REPLACE_EXISTING);
            }
            {
                this.$environment = cidrToolEnvironment;
                this.$targetDirectory = path;
            }
        });
    }

    private final void processGcdaFile(String inputFile, String workingDirectory, ProgressIndicator indicator, RunConfiguration configuration, CidrToolEnvironment environment2, GCovCoverageToolProvider toolsProvider) {
        String string = environment2.toEnvPath(inputFile);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"environment.toEnvPath(inputFile)");
        GeneralCommandLine gcov = toolsProvider.createCommandLine(string, workingDirectory, configuration, environment2);
        if (gcov == null) {
            throw (Throwable)new ExecutionException(CidrCoverageBundle.message("coverage.tool.not.found", toolsProvider.getToolName(configuration)));
        }
        ProcessOutput processOutput = null;
        try {
            processOutput = environment2.getHostMachine().runProcess(gcov, indicator, -1);
        }
        catch (ExecutionException exception) {
            throw (Throwable)new ExecutionException(CidrCoverageBundle.message("gcov.tools.failed", exception.getMessage()));
        }
        String string2 = processOutput.getStderr();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"processOutput.stderr");
        CharSequence charSequence = string2;
        boolean bl = false;
        if (charSequence.length() > 0) {
            CidrCoverageLogKt.getCidrCoverageLog().warn(toolsProvider.getToolName(configuration) + " finished with stderr: " + processOutput.getStderr());
        }
        if (processOutput.getExitCode() != 0) {
            throw (Throwable)new ExecutionException(CidrCoverageBundle.message("gcov.tools.failed", processOutput.getStderr()));
        }
    }

    private final String getCoverageRootDirectory(RunConfiguration configuration) {
        CidrCoverageDataFileProvider cidrCoverageDataFileProvider = CidrCoverageDataFileProvider.Companion.getInstance(configuration, this.getCoverageRunnerId());
        return cidrCoverageDataFileProvider != null ? cidrCoverageDataFileProvider.getLocalCoverageDataPath(configuration) : null;
    }

    public GCovCoverageComposer() {
        super("gcov");
    }

    public static final /* synthetic */ void access$processGcdaFile(GCovCoverageComposer $this, String inputFile, String workingDirectory, ProgressIndicator indicator, RunConfiguration configuration, CidrToolEnvironment environment2, GCovCoverageToolProvider toolsProvider) {
        $this.processGcdaFile(inputFile, workingDirectory, indicator, configuration, environment2, toolsProvider);
    }
}

