/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.coverage;

import com.intellij.coverage.BaseCoverageSuite;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.ToolWindowManager;
import com.jetbrains.cidr.cpp.toolchains.WSLCidrUtil;
import com.jetbrains.cidr.execution.coverage.CidrCoverageLogKt;
import com.jetbrains.cidr.execution.coverage.CidrCoverageSuite;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.toolchains.CidrToolsUtil;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/jetbrains/cidr/execution/coverage/CidrCoverageUtil;", "", "()V", "Companion", "intellij.cidr.coverage"})
public final class CidrCoverageUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J&\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\tJ\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0011J\u001a\u0010\u0019\u001a\u00020\u001a2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\u001b\u001a\u00020\u0011J*\u0010\u001d\u001a\u00020\u001a2\b\b\u0001\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020$\u00a8\u0006%"}, d2={"Lcom/jetbrains/cidr/execution/coverage/CidrCoverageUtil$Companion;", "", "()V", "deleteFilesInBatchMode", "", "hostMachine", "Lcom/jetbrains/cidr/system/HostMachine;", "filesToDelete", "", "Ljava/nio/file/Path;", "workingDir", "", "getCoverageRunner", "Lcom/intellij/coverage/CoverageRunner;", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "getEnvironment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "coverageSuite", "Lcom/intellij/coverage/CoverageSuite;", "getRunConfiguration", "moveFilesWithExtensionInBatchMode", "extension", "sourceDir", "targetDir", "setEnvironment", "", "environment", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "showBalloon", "message", "messageType", "Lcom/intellij/openapi/ui/MessageType;", "listener", "Ljavax/swing/event/HyperlinkListener;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.cidr.coverage"})
    public static final class Companion {
        @Nullable
        public final CidrToolEnvironment getEnvironment(@Nullable CoverageSuite coverageSuite) {
            if (coverageSuite instanceof CidrCoverageSuite) {
                return ((CidrCoverageSuite)coverageSuite).getToolEnvironment();
            }
            return null;
        }

        public final void setEnvironment(@NotNull RunConfigurationBase<?> configuration, @NotNull CidrToolEnvironment environment2) {
            Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
            CoverageEnabledConfiguration coverageEnabledConfiguration = CoverageEnabledConfiguration.getOrCreate(configuration);
            Intrinsics.checkNotNullExpressionValue((Object)coverageEnabledConfiguration, (String)"CoverageEnabledConfigura\u2026etOrCreate(configuration)");
            CoverageSuite coverageSuite = coverageEnabledConfiguration.getCurrentCoverageSuite();
            Intrinsics.checkNotNullExpressionValue((Object)coverageSuite, (String)"CoverageEnabledConfigura\u2026ion).currentCoverageSuite");
            this.setEnvironment(coverageSuite, environment2);
        }

        public final void setEnvironment(@NotNull CoverageSuite coverageSuite, @NotNull CidrToolEnvironment environment2) {
            Intrinsics.checkNotNullParameter((Object)coverageSuite, (String)"coverageSuite");
            Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
            if (coverageSuite instanceof CidrCoverageSuite) {
                ((CidrCoverageSuite)coverageSuite).setToolEnvironment(environment2);
            }
        }

        public final void showBalloon(@NlsContexts.PopupContent @NotNull String message, @NotNull MessageType messageType, @Nullable HyperlinkListener listener, @NotNull Project project) {
            Application app$iv;
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)messageType, (String)"messageType");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ModalityState modalityState$iv = null;
            boolean $i$f$runInEdt = false;
            Application application = app$iv = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"app");
            if (application.isDispatchThread()) {
                boolean bl = false;
                ToolWindowManager.Companion.getInstance(project).notifyByBalloon("Coverage", messageType, message, null, listener);
            } else {
                boolean $i$f$invokeLater = false;
                Application application2 = ApplicationManager.getApplication();
                Runnable runnable2 = new Runnable(project, messageType, message, listener){
                    final /* synthetic */ Project $project$inlined;
                    final /* synthetic */ MessageType $messageType$inlined;
                    final /* synthetic */ String $message$inlined;
                    final /* synthetic */ HyperlinkListener $listener$inlined;
                    {
                        this.$project$inlined = project;
                        this.$messageType$inlined = messageType;
                        this.$message$inlined = string;
                        this.$listener$inlined = hyperlinkListener;
                    }

                    public final void run() {
                        boolean bl = false;
                        ToolWindowManager.Companion.getInstance(this.$project$inlined).notifyByBalloon("Coverage", this.$messageType$inlined, this.$message$inlined, null, this.$listener$inlined);
                    }
                };
                ModalityState modalityState = ModalityState.defaultModalityState();
                Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
                application2.invokeLater(runnable2, modalityState);
            }
        }

        @NotNull
        public final CoverageRunner getCoverageRunner(@NotNull RunConfiguration configuration) {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            CoverageEnabledConfiguration coverageEnabledConfiguration = CoverageEnabledConfiguration.getOrCreate((RunConfigurationBase)((RunConfigurationBase)configuration));
            Intrinsics.checkNotNullExpressionValue((Object)coverageEnabledConfiguration, (String)"CoverageEnabledConfigura\u2026 RunConfigurationBase<*>)");
            CoverageRunner coverageRunner = coverageEnabledConfiguration.getCoverageRunner();
            Intrinsics.checkNotNull((Object)coverageRunner);
            return coverageRunner;
        }

        @Nullable
        public final RunConfiguration getRunConfiguration(@Nullable CoverageSuite coverageSuite) {
            if (coverageSuite instanceof BaseCoverageSuite) {
                return (RunConfiguration)((BaseCoverageSuite)coverageSuite).getConfiguration();
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean deleteFilesInBatchMode(@NotNull HostMachine hostMachine, @NotNull List<? extends Path> filesToDelete, @NotNull String workingDir) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)hostMachine, (String)"hostMachine");
            Intrinsics.checkNotNullParameter(filesToDelete, (String)"filesToDelete");
            Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
            if (filesToDelete.isEmpty()) {
                return true;
            }
            if (!hostMachine.isRemote() || hostMachine instanceof WSLCidrUtil.WSLHost) {
                Iterable $this$forEach$iv = filesToDelete;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Path it = (Path)element$iv;
                    boolean bl = false;
                    Files.delete(it);
                }
                return true;
            }
            Iterable $i$f$forEach = filesToDelete;
            GeneralCommandLine generalCommandLine = new GeneralCommandLine(new String[]{"rm"}).withParameters(new String[]{"-f"});
            boolean $i$f$map = false;
            void element$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Path path = (Path)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                String string = it.toString();
                collection.add(string);
            }
            collection = (List)destination$iv$iv;
            GeneralCommandLine generalCommandLine2 = generalCommandLine.withParameters((List)collection).withWorkDirectory(workingDir);
            Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine2, (String)"GeneralCommandLine(\"rm\")\u2026WorkDirectory(workingDir)");
            GeneralCommandLine rmCommandLine = generalCommandLine2;
            ProcessOutput processOutput = hostMachine.runProcess(rmCommandLine, 60000);
            Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"hostMachine.runProcess(rmCommandLine, 60_000)");
            ProcessOutput output = processOutput;
            return CidrToolsUtil.checkSuccess((GeneralCommandLine)rmCommandLine, (ProcessOutput)output, (Logger)CidrCoverageLogKt.getCidrCoverageLog());
        }

        /*
         * WARNING - void declaration
         */
        public final boolean moveFilesWithExtensionInBatchMode(@NotNull HostMachine hostMachine, @NotNull String extension, @NotNull Path sourceDir, @NotNull Path targetDir) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)hostMachine, (String)"hostMachine");
            Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
            Intrinsics.checkNotNullParameter((Object)sourceDir, (String)"sourceDir");
            Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
            Stream<Path> stream = Files.list(sourceDir).filter(new Predicate(extension){
                final /* synthetic */ String $extension;

                public final boolean test(Path it) {
                    return StringsKt.endsWith$default((String)((Object)it).toString(), (String)this.$extension, (boolean)false, (int)2, null);
                }
                {
                    this.$extension = string;
                }
            });
            Intrinsics.checkNotNullExpressionValue(stream, (String)"Files.list(sourceDir).fi\u2026g().endsWith(extension) }");
            List filesToMove2 = StreamsKt.toList(stream);
            if (filesToMove2.isEmpty()) {
                return true;
            }
            if (!hostMachine.isRemote() || hostMachine instanceof WSLCidrUtil.WSLHost) {
                Iterable $this$forEach$iv = filesToMove2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Path it = (Path)element$iv;
                    boolean bl = false;
                    String string = ((Object)targetDir).toString();
                    String[] stringArray = new String[1];
                    Path path = it;
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"it");
                    stringArray[0] = ((Object)path.getFileName()).toString();
                    Files.move(it, hostMachine.getPath(string, stringArray), StandardCopyOption.REPLACE_EXISTING);
                }
                return true;
            }
            Iterable $i$f$forEach = filesToMove2;
            GeneralCommandLine generalCommandLine = new GeneralCommandLine(new String[]{"mv"}).withParameters(new String[]{"-f", "-t", ((Object)targetDir).toString()});
            boolean $i$f$map = false;
            void element$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Path path = (Path)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                String string = it.toString();
                collection.add(string);
            }
            collection = (List)destination$iv$iv;
            GeneralCommandLine generalCommandLine2 = generalCommandLine.withParameters((List)collection).withWorkDirectory(((Object)sourceDir).toString());
            Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine2, (String)"GeneralCommandLine(\"mv\")\u2026ory(sourceDir.toString())");
            GeneralCommandLine mvCommandLine = generalCommandLine2;
            ProcessOutput processOutput = hostMachine.runProcess(mvCommandLine, 60000);
            Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"hostMachine.runProcess(mvCommandLine, 60_000)");
            ProcessOutput output = processOutput;
            return CidrToolsUtil.checkSuccess((GeneralCommandLine)mvCommandLine, (ProcessOutput)output, (Logger)CidrCoverageLogKt.getCidrCoverageLog());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

