/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.gdbserver.remote;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.config.unified.SshConfigManager;
import com.jetbrains.cidr.cpp.CLionExecutionBundle;
import com.jetbrains.cidr.cpp.execution.gdbserver.DownloadType;
import com.jetbrains.cidr.cpp.execution.gdbserver.GdbServerRunConfiguration;
import com.jetbrains.cidr.cpp.execution.gdbserver.remote.RemoteGdbServerLauncher;
import com.jetbrains.cidr.cpp.execution.gdbserver.remote.RemoteGdbServerRunConfigurationSettingsEditor;
import com.jetbrains.cidr.execution.CidrCommandLineState;
import com.jetbrains.cidr.execution.CidrLauncher;
import com.jetbrains.cidr.system.RemoteDeploymentHelper;
import com.jetbrains.cidr.system.RemoteUtil;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteGdbServerRunConfiguration
extends GdbServerRunConfiguration
implements RunConfigurationWithSuppressedDefaultRunAction {
    static final String DEFAULT_GDB_SERVER = "/usr/bin/gdbserver";
    private String myHostId;
    private String mySshConfigName;
    private String myUploadFile;
    private String myDefaultGdbServerArgs;

    public RemoteGdbServerRunConfiguration(Project project, ConfigurationFactory factory, String name2) {
        super(project, factory, name2);
    }

    @Override
    @NotNull
    protected DownloadType defaultDownloadType() {
        DownloadType downloadType = DownloadType.ALWAYS;
        if (downloadType == null) {
            RemoteGdbServerRunConfiguration.$$$reportNull$$$0(0);
        }
        return downloadType;
    }

    @Override
    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return new RemoteGdbServerRunConfigurationSettingsEditor(this.getProject(), this.getHelper());
    }

    @Override
    public void readExternal(@NotNull Element parentElement) throws InvalidDataException {
        if (parentElement == null) {
            RemoteGdbServerRunConfiguration.$$$reportNull$$$0(1);
        }
        super.readExternal(parentElement);
        Element element = parentElement.getChild("custom-gdb-server");
        if (element != null) {
            this.myHostId = element.getAttributeValue("hostId");
            this.mySshConfigName = element.getAttributeValue("sshConfigName");
            if (this.mySshConfigName == null) {
                SshConfig sshConfig = RemoteDeploymentHelper.getSshConfig((String)this.myHostId);
                this.mySshConfigName = sshConfig != null ? sshConfig.getId() : null;
            }
            this.myUploadFile = element.getAttributeValue("uploadFile");
            this.myDefaultGdbServerArgs = element.getAttributeValue("defaultGdbServerArgs");
        }
    }

    @Override
    public void writeExternal(@NotNull Element parentElement) throws WriteExternalException {
        if (parentElement == null) {
            RemoteGdbServerRunConfiguration.$$$reportNull$$$0(2);
        }
        super.writeExternal(parentElement);
        Element element = parentElement.getChild("custom-gdb-server");
        assert (element != null);
        if (this.myHostId != null) {
            element.setAttribute("hostId", this.myHostId);
        }
        if (this.mySshConfigName != null) {
            element.setAttribute("sshConfigName", this.mySshConfigName);
        }
        if (this.myUploadFile != null) {
            element.setAttribute("uploadFile", this.myUploadFile);
        }
        if (this.myDefaultGdbServerArgs != null) {
            element.setAttribute("defaultGdbServerArgs", this.myDefaultGdbServerArgs);
        }
    }

    @Override
    protected void doCheckConfiguration(boolean checkExecutable) throws RuntimeConfigurationException {
        if (!RemoteDeploymentHelper.isRemoteDeploymentServiceAvailable()) {
            RuntimeConfigurationException error = new RuntimeConfigurationException(CLionExecutionBundle.message("gdbserver.plugin.remote.hosts.data.access.disabled", new Object[0]));
            error.setQuickFix(() -> ShowSettingsUtil.getInstance().showSettingsDialog(this.getProject(), PluginManagerConfigurable.class));
            throw error;
        }
        super.doCheckConfiguration(checkExecutable);
    }

    @Override
    protected boolean serverExecutableIsNotEmpty() {
        return true;
    }

    @Override
    protected boolean serverExecutableExists() {
        SshConfig sshConfig = SshConfigManager.getInstance((Project)this.getProject()).findConfigByName(this.mySshConfigName);
        RemoteCredentials credentials = RemoteUtil.toCredentials((SshConfig)sshConfig);
        if (credentials != null) {
            try {
                String gdbServer = StringUtil.defaultIfEmpty((String)this.getServerExecutable(), (String)DEFAULT_GDB_SERVER);
                String fileName = RemoteUtil.resolveToExecutable((RemoteCredentials)credentials, (String)gdbServer);
                return fileName != null && RemoteUtil.fileExists((RemoteCredentials)credentials, (String)fileName);
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
        return false;
    }

    @Nullable
    public CidrCommandLineState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment2) {
        if (executor == null) {
            RemoteGdbServerRunConfiguration.$$$reportNull$$$0(3);
        }
        if (environment2 == null) {
            RemoteGdbServerRunConfiguration.$$$reportNull$$$0(4);
        }
        RemoteGdbServerLauncher launcher = new RemoteGdbServerLauncher(environment2, this, this.getDebuggerData().getOrCreateDebuggerToolchain());
        return new CidrCommandLineState(environment2, (CidrLauncher)launcher);
    }

    public void setHostId(@Nullable String hostId) {
        this.myHostId = hostId;
    }

    @Nullable
    public String getHostId() {
        return this.myHostId;
    }

    @Nullable
    public String getSshConfigName() {
        return this.mySshConfigName;
    }

    public void setSshConfigName(@Nullable String sshConfigName) {
        this.mySshConfigName = sshConfigName;
    }

    public void setUploadFile(@Nullable String uploadFile) {
        this.myUploadFile = uploadFile;
    }

    @Nullable
    public String getUploadFile() {
        return this.myUploadFile;
    }

    public void setDefaultGdbServerArgs(@Nullable String defaultGdbServerArgs) {
        this.myDefaultGdbServerArgs = defaultGdbServerArgs;
    }

    public String getDefaultGdbServerArgs() {
        return this.myDefaultGdbServerArgs;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/gdbserver/remote/RemoteGdbServerRunConfiguration";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "defaultDownloadType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/gdbserver/remote/RemoteGdbServerRunConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

