/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution;

import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CidrExecutionUtil {
    public static boolean compiledWithCompilerSwitches(@NotNull CidrRunConfiguration configuration, @NotNull List<String> switchesToCheck) {
        ExecutionTarget target;
        OCResolveConfiguration resolveConfiguration;
        if (configuration == null) {
            CidrExecutionUtil.$$$reportNull$$$0(0);
        }
        if (switchesToCheck == null) {
            CidrExecutionUtil.$$$reportNull$$$0(1);
        }
        if ((resolveConfiguration = configuration.getResolveConfiguration(target = ExecutionTargetManager.getInstance((Project)configuration.getProject()).getActiveTarget())) == null) {
            return false;
        }
        for (CLanguageKind languageKind : CLanguageKind.values()) {
            OCCompilerSettings compilerSettings = resolveConfiguration.getCompilerSettings((OCLanguageKind)languageKind);
            CidrCompilerSwitches compilerSwitches = compilerSettings.getCompilerSwitches();
            if (compilerSwitches == null) continue;
            List switches = compilerSwitches.getList(CidrCompilerSwitches.Format.RAW);
            return switchesToCheck.stream().allMatch(switchToCheck -> CidrExecutionUtil.compiledWithCompilerSwitch(switches, switchToCheck));
        }
        return false;
    }

    public static boolean compiledWithCompilerSwitch(@NonNls @NotNull List<String> compilerSwitches, @NonNls @NotNull String compilerSwitch) {
        if (compilerSwitches == null) {
            CidrExecutionUtil.$$$reportNull$$$0(2);
        }
        if (compilerSwitch == null) {
            CidrExecutionUtil.$$$reportNull$$$0(3);
        }
        return compilerSwitches.stream().anyMatch(sw -> sw.startsWith(compilerSwitch) || sw.startsWith("/clang:" + compilerSwitch));
    }

    public static boolean compilerUsed(@NotNull CidrRunConfiguration configuration, OCCompilerKind ... compilers) {
        ExecutionTarget target;
        OCResolveConfiguration resolveConfiguration;
        if (configuration == null) {
            CidrExecutionUtil.$$$reportNull$$$0(4);
        }
        if (compilers == null) {
            CidrExecutionUtil.$$$reportNull$$$0(5);
        }
        if ((resolveConfiguration = configuration.getResolveConfiguration(target = ExecutionTargetManager.getInstance((Project)configuration.getProject()).getActiveTarget())) == null) {
            return false;
        }
        return Arrays.stream(CLanguageKind.values()).anyMatch(languageKind -> {
            OCCompilerSettings settings = resolveConfiguration.getCompilerSettings((OCLanguageKind)languageKind);
            return Arrays.stream(compilers).anyMatch(compiler -> compiler == settings.getCompilerKind());
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchesToCheck";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerSwitches";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerSwitch";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilers";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/cpp/execution/CidrExecutionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "compiledWithCompilerSwitches";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "compiledWithCompilerSwitch";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "compilerUsed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

