/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.clion.perf;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Version;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.LineByLineParser;
import com.intellij.profiler.MisConfiguredException;
import com.intellij.profiler.MisConfiguredExceptionKt;
import com.intellij.profiler.api.AttachableTargetProcess;
import com.intellij.profiler.api.ProfilerProcess;
import com.intellij.profiler.clion.PerfProfilerConfigurable;
import com.intellij.profiler.clion.perf.PerfProfilerProcess;
import com.intellij.profiler.clion.perf.PerfProfilerSettings;
import com.intellij.profiler.clion.perf.PerfUtils;
import com.intellij.profiler.clion.perf.RemoteKernelVariable;
import com.intellij.profiler.clion.perf.RemoteKernelVariablesFixer;
import com.intellij.profiler.dtrace.SimpleProfilerSettingsState;
import com.intellij.profiler.linux.HasInvalidVariables;
import com.intellij.profiler.linux.KernelVariable;
import com.intellij.profiler.linux.KernelVariablesChangeRequiredException;
import com.intellij.profiler.linux.KernelVariablesFixer;
import com.intellij.profiler.linux.KernelVariablesValidatorKt;
import com.intellij.profiler.linux.ValidationResult;
import com.intellij.util.VersionUtil;
import com.intellij.util.text.StringKt;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.cpp.toolchains.WSL;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.toolchains.CidrToolsUtil;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/intellij/profiler/clion/perf/PerfUtils;", "", "()V", "Companion", "intellij.profiler.clion"})
public final class PerfUtils {
    @NotNull
    private static final Lazy defaultPerfSettings$delegate;
    @NotNull
    private static final Pattern VERSION_PATTERN;
    @NotNull
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        defaultPerfSettings$delegate = LazyKt.lazy((Function0)Companion.defaultPerfSettings.2.INSTANCE);
        VERSION_PATTERN = new Regex("perf version ([0-9]+(?:\\.[0-9]+)+).*").toPattern();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\r\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f0\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J>\u0010\u0018\u001a\u001e\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u0002H\u001b0\u0019j\u000e\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u0002H\u001b`\u001c\"\u0004\b\u0000\u0010\u001a\"\u0004\b\u0001\u0010\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\u0018\u0010!\u001a\u00020\"2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010#\u001a\u0004\u0018\u00010$J\"\u0010%\u001a\u0006\u0012\u0002\b\u00030&2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010)\u001a\u00020*J\u0010\u0010+\u001a\u00020,2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010/\u001a\u000200J\u0016\u00101\u001a\b\u0012\u0004\u0012\u000203022\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u000e\u00104\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u00105\u001a\u0002062\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u00107\u001a\u0004\u0018\u0001082\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0018\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\u0007\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006;"}, d2={"Lcom/intellij/profiler/clion/perf/PerfUtils$Companion;", "", "()V", "VERSION_PATTERN", "Ljava/util/regex/Pattern;", "getVERSION_PATTERN", "()Ljava/util/regex/Pattern;", "defaultPerfSettings", "Lcom/intellij/profiler/dtrace/SimpleProfilerSettingsState;", "getDefaultPerfSettings", "()Lcom/intellij/profiler/dtrace/SimpleProfilerSettingsState;", "defaultPerfSettings$delegate", "Lkotlin/Lazy;", "attachPerfProfiler", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/profiler/api/ProfilerProcess;", "Lcom/intellij/profiler/api/AttachableTargetProcess;", "targetProcess", "backgroundOption", "Lcom/intellij/openapi/progress/PerformInBackgroundOption;", "environment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "project", "Lcom/intellij/openapi/project/Project;", "createLRUCache", "Ljava/util/LinkedHashMap;", "T", "V", "Lkotlin/collections/LinkedHashMap;", "maxCapacity", "", "loadFactor", "", "createOutputFilePath", "Ljava/nio/file/Path;", "outputDirectory", "", "createProcessHandler", "Lcom/intellij/execution/process/BaseProcessHandler;", "cl", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "parser", "Lcom/intellij/profiler/LineByLineParser;", "getKernelVariableFixer", "Lcom/intellij/profiler/linux/KernelVariablesFixer;", "getPerfVersion", "Lcom/intellij/openapi/util/Version;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getRequiredKernelVariables", "", "Lcom/intellij/profiler/linux/KernelVariable;", "getWSLVersion", "isWSL", "", "validateKernelVariables", "Lcom/intellij/profiler/linux/KernelVariablesChangeRequiredException;", "validatePerfSettings", "Lcom/intellij/profiler/MisConfiguredException;", "intellij.profiler.clion"})
    public static final class Companion {
        @NotNull
        public final SimpleProfilerSettingsState getDefaultPerfSettings() {
            Lazy lazy = defaultPerfSettings$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return (SimpleProfilerSettingsState)lazy.getValue();
        }

        @NotNull
        public final Pattern getVERSION_PATTERN() {
            return VERSION_PATTERN;
        }

        @NotNull
        public final BaseProcessHandler<?> createProcessHandler(@NotNull GeneralCommandLine cl, @NotNull CidrToolEnvironment environment2, @NotNull LineByLineParser parser) {
            Intrinsics.checkNotNullParameter((Object)cl, (String)"cl");
            Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            BaseProcessHandler baseProcessHandler = environment2.getHostMachine().createProcess(cl, false, false, false, true);
            Intrinsics.checkNotNullExpressionValue((Object)baseProcessHandler, (String)"environment.hostMachine.\u2026alse, false, false, true)");
            BaseProcessHandler processHandler = baseProcessHandler;
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(parser){
                final /* synthetic */ LineByLineParser $parser;

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                    if (Intrinsics.areEqual(outputType, (Object)ProcessOutputTypes.STDOUT)) {
                        String string = event.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.text");
                        LineByLineParser.consumeText$default((LineByLineParser)this.$parser, (String)string, null, (int)2, null);
                    }
                }
                {
                    this.$parser = $captured_local_variable$0;
                }
            });
            return processHandler;
        }

        @NotNull
        public final <T, V> LinkedHashMap<T, V> createLRUCache(int maxCapacity, float loadFactor) {
            return new LinkedHashMap<T, V>(maxCapacity, loadFactor, maxCapacity, loadFactor, true){
                final /* synthetic */ int $maxCapacity;
                final /* synthetic */ float $loadFactor;

                protected boolean removeEldestEntry(@Nullable Map.Entry<T, V> eldest) {
                    return this.size() > this.$maxCapacity;
                }
                {
                    this.$maxCapacity = $captured_local_variable$0;
                    this.$loadFactor = $captured_local_variable$1;
                    super($super_call_param$2, $super_call_param$3, $super_call_param$4);
                }
            };
        }

        @Nullable
        public final Version getPerfVersion(@NotNull CidrToolEnvironment environment2, @NotNull ProgressIndicator indicator) {
            Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            String perfExecutablePath = environment2.toEnvPath(PerfProfilerSettings.Companion.getInstance().getState().getExecutablePath());
            GeneralCommandLine cl = new GeneralCommandLine(new String[]{perfExecutablePath, "--version"});
            Ref ref = Ref.create();
            Intrinsics.checkNotNullExpressionValue((Object)ref, (String)"Ref.create<Version>()");
            Ref version = ref;
            BaseProcessHandler<?> handler2 = this.createProcessHandler(cl, environment2, new LineByLineParser(version){
                final /* synthetic */ Ref $version;

                public void consumeLine(@NotNull String line) {
                    Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                    if (this.$version.isNull()) {
                        this.$version.set((Object)VersionUtil.parseVersion((String)line, (Pattern[])new Pattern[]{PerfUtils.Companion.getVERSION_PATTERN()}));
                    }
                }
                {
                    this.$version = $captured_local_variable$0;
                }
            });
            CidrToolsUtil.runProcess(handler2, (ProgressIndicator)indicator, (int)-1);
            return !version.isNull() ? (Version)version.get() : null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isWSL(@NotNull CidrToolEnvironment environment2) {
            Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
            if (!(environment2 instanceof CPPEnvironment)) return false;
            CPPToolSet cPPToolSet = ((CPPEnvironment)environment2).getToolSet();
            Intrinsics.checkNotNullExpressionValue((Object)cPPToolSet, (String)"environment.toolSet");
            if (!cPPToolSet.isWSL()) return false;
            return true;
        }

        public final int getWSLVersion(@NotNull CidrToolEnvironment environment2) {
            Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
            if (!this.isWSL(environment2)) {
                return -1;
            }
            WSL wSL = (WSL)((CPPEnvironment)environment2).getToolSet();
            if (wSL == null) {
                return -1;
            }
            WSL wsl = wSL;
            WSLDistribution wSLDistribution = wsl.getWslDistribution();
            return wSLDistribution != null ? wSLDistribution.getVersion() : -1;
        }

        @Nullable
        public final MisConfiguredException validatePerfSettings(@NotNull CidrToolEnvironment environment2, @NotNull Project project) {
            MisConfiguredException misConfiguredException;
            Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            SimpleProfilerSettingsState state = PerfProfilerSettings.Companion.getInstance().getState();
            HostMachine hostMachine = environment2.getHostMachine();
            String string = state.getExecutablePath();
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                string2 = "";
            }
            Path path = hostMachine.getPath(string2, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"environment.hostMachine.\u2026executablePath.orEmpty())");
            Path perfPath = path;
            HostMachine hostMachine2 = environment2.getHostMachine();
            String string3 = state.getOutputDirectory();
            boolean bl2 = false;
            String string4 = string3;
            if (string4 == null) {
                string4 = "";
            }
            Path path2 = hostMachine2.getPath(string4, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"environment.hostMachine.\u2026utputDirectory.orEmpty())");
            Path outputDirectoryPath = path2;
            MisConfiguredException misConfiguredException2 = MisConfiguredExceptionKt.validateLocalPath$default((Path)perfPath, (String)"Perf executable", (Project)project, PerfProfilerConfigurable.class, null, (int)16, null);
            if (misConfiguredException2 == null) {
                misConfiguredException2 = misConfiguredException = (MisConfiguredException)MisConfiguredExceptionKt.validateFrequency((int)state.getSamplingFrequency(), (Project)project, PerfProfilerConfigurable.class);
            }
            if (misConfiguredException2 == null) {
                misConfiguredException = MisConfiguredExceptionKt.validateOutputDirectory((Path)outputDirectoryPath, (Project)project, PerfProfilerConfigurable.class);
            }
            return misConfiguredException;
        }

        @Nullable
        public final KernelVariablesChangeRequiredException validateKernelVariables(@NotNull CidrToolEnvironment environment2, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ValidationResult validationResult = KernelVariablesValidatorKt.checkKernelVariables(this.getRequiredKernelVariables(environment2), (KernelVariablesFixer)this.getKernelVariableFixer(environment2));
            if (validationResult instanceof HasInvalidVariables) {
                return new KernelVariablesChangeRequiredException((HasInvalidVariables)validationResult, project);
            }
            return null;
        }

        private final KernelVariablesFixer getKernelVariableFixer(CidrToolEnvironment environment2) {
            HostMachine hostMachine = environment2.getHostMachine();
            Intrinsics.checkNotNullExpressionValue((Object)hostMachine, (String)"environment.hostMachine");
            return hostMachine.isRemote() ? (KernelVariablesFixer)new RemoteKernelVariablesFixer(environment2) : new KernelVariablesFixer();
        }

        @NotNull
        public final Promise<? extends ProfilerProcess<? extends AttachableTargetProcess>> attachPerfProfiler(@NotNull AttachableTargetProcess targetProcess, @NotNull PerformInBackgroundOption backgroundOption, @NotNull CidrToolEnvironment environment2, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)targetProcess, (String)"targetProcess");
            Intrinsics.checkNotNullParameter((Object)backgroundOption, (String)"backgroundOption");
            Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            AsyncPromise result = new AsyncPromise();
            new Task.Backgroundable(environment2, targetProcess, project, result, backgroundOption, project, CommonProfilerBundleKt.commonProfilerMessage((String)"attach.task.title", (Object[])new Object[0]), true, backgroundOption){
                final /* synthetic */ CidrToolEnvironment $environment;
                final /* synthetic */ AttachableTargetProcess $targetProcess;
                final /* synthetic */ Project $project;
                final /* synthetic */ AsyncPromise $result;
                final /* synthetic */ PerformInBackgroundOption $backgroundOption;

                public void run(@NotNull ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    SimpleProfilerSettingsState settings = PerfProfilerSettings.Companion.getInstance().getState();
                    String perfPath = this.$environment.toEnvPath(settings.getExecutablePath());
                    Path outputFilePath = PerfUtils.Companion.createOutputFilePath(this.$environment, StringKt.nullize$default((String)settings.getOutputDirectory(), (boolean)false, (int)1, null));
                    GeneralCommandLine generalCommandLine = new GeneralCommandLine(new String[]{perfPath}).withParameters(new String[]{"record", "-p", String.valueOf(this.$targetProcess.getPid()), "--freq=" + settings.getSamplingFrequency()}).withParameters(settings.getDefaultCmdArgs()).withParameters(new String[]{"-o", this.$environment.toEnvPath(((Object)outputFilePath).toString())});
                    Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"GeneralCommandLine(perfP\u2026tputFilePath.toString()))");
                    GeneralCommandLine cl = generalCommandLine;
                    BaseProcessHandler baseProcessHandler = this.$environment.getHostMachine().createProcess(cl, false, false, false, false);
                    Intrinsics.checkNotNullExpressionValue((Object)baseProcessHandler, (String)"environment.hostMachine.\u2026lse, false, false, false)");
                    BaseProcessHandler perfRecordProcessHandler = baseProcessHandler;
                    if (perfRecordProcessHandler instanceof KillableProcessHandler) {
                        ((KillableProcessHandler)perfRecordProcessHandler).setShouldKillProcessSoftly(true);
                    }
                    perfRecordProcessHandler.startNotify();
                    PerfProfilerProcess perfProfilerProcess = new PerfProfilerProcess(perfRecordProcessHandler, true, outputFilePath, this.$targetProcess.getShortName(), this.$project, System.currentTimeMillis(), this.$environment, null, 128, null);
                    this.$result.setResult((Object)((Object)perfProfilerProcess));
                }
                {
                    this.$environment = $captured_local_variable$0;
                    this.$targetProcess = $captured_local_variable$1;
                    this.$project = $captured_local_variable$2;
                    this.$result = $captured_local_variable$3;
                    this.$backgroundOption = $captured_local_variable$4;
                    super($super_call_param$5, $super_call_param$6, $super_call_param$7, $super_call_param$8);
                }
            }.queue();
            return (Promise)result;
        }

        @NotNull
        public final Path createOutputFilePath(@NotNull CidrToolEnvironment environment2, @Nullable String outputDirectory) {
            Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
            CharSequence charSequence = outputDirectory;
            boolean bl = false;
            boolean bl2 = false;
            if (charSequence == null || charSequence.length() == 0) {
                HostMachine hostMachine = environment2.getHostMachine();
                Intrinsics.checkNotNullExpressionValue((Object)hostMachine, (String)"environment.hostMachine");
                Path path = Files.createTempFile(hostMachine.getTempDirectory(), "clion", "perf", new FileAttribute[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Files.createTempFile(env\u2026rectory, \"clion\", \"perf\")");
                return path;
            }
            Path path = Files.createTempFile(environment2.getHostMachine().getPath(outputDirectory, new String[0]), "clion", "perf", new FileAttribute[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Files.createTempFile(env\u2026ectory), \"clion\", \"perf\")");
            return path;
        }

        private final List<KernelVariable> getRequiredKernelVariables(CidrToolEnvironment environment2) {
            return CollectionsKt.listOf((Object[])new RemoteKernelVariable[]{new RemoteKernelVariable(environment2, "perf_event_paranoid", "1", (Function1<? super String, Boolean>)((Function1)getRequiredKernelVariables.1.INSTANCE)), new RemoteKernelVariable(environment2, "kptr_restrict", "0", (Function1<? super String, Boolean>)((Function1)getRequiredKernelVariables.2.INSTANCE))});
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

