/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.registry;

import com.intellij.openapi.util.NlsSafe;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangWorkspace;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface WorkspaceFile {
    @NlsSafe
    @NotNull
    public String getUrl();

    @NotNull
    public Set<Key<?>> keys();

    public <T> T get(@NotNull Key<T> var1);

    public <T> T getOrDefault(@NotNull Key<T> var1);

    public <T> void put(@NotNull Key<T> var1, T var2);

    public boolean hasKey(@NotNull Key<?> var1);

    public static final class Key<T> {
        @NotNull
        private final String key;
        @Nullable
        private final Supplier<T> defValueProvider;

        public Key(@NonNls @NotNull String key) {
            if (key == null) {
                Key.$$$reportNull$$$0(0);
            }
            this(key, null);
        }

        public Key(@NonNls @NotNull String key, @Nullable Supplier<T> defValueProvider) {
            if (key == null) {
                Key.$$$reportNull$$$0(1);
            }
            this.key = key;
            this.defValueProvider = defValueProvider;
        }

        @NonNls
        @NotNull
        public String getKey() {
            String string = this.key;
            if (string == null) {
                Key.$$$reportNull$$$0(2);
            }
            return string;
        }

        public T getValue(@NotNull WorkspaceFile wf) {
            if (wf == null) {
                Key.$$$reportNull$$$0(3);
            }
            return wf.get(this);
        }

        public T getValue(@NotNull ClangWorkspace<? extends WorkspaceFile> workspace, @NlsSafe @NotNull String url) {
            if (workspace == null) {
                Key.$$$reportNull$$$0(4);
            }
            if (url == null) {
                Key.$$$reportNull$$$0(5);
            }
            return (T)workspace.apply(url, wf -> this.getValue((WorkspaceFile)wf));
        }

        public T getValueOrDefault(@NotNull WorkspaceFile wf) {
            if (wf == null) {
                Key.$$$reportNull$$$0(6);
            }
            return wf.getOrDefault(this);
        }

        public T getValueOrDefault(@NotNull ClangWorkspace<? extends WorkspaceFile> workspace, @NlsSafe @NotNull String url) {
            if (workspace == null) {
                Key.$$$reportNull$$$0(7);
            }
            if (url == null) {
                Key.$$$reportNull$$$0(8);
            }
            return (T)workspace.apply(url, wf -> this.getValueOrDefault((WorkspaceFile)wf));
        }

        public T createDefaultValue() {
            return this.defValueProvider != null ? (T)this.defValueProvider.get() : null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key1 = (Key)o;
            return Objects.equals(this.key, key1.key);
        }

        public int hashCode() {
            return Objects.hash(this.key);
        }

        @NonNls
        public String toString() {
            return this.key;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/registry/WorkspaceFile$Key";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wf";
                    break;
                }
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "workspace";
                    break;
                }
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/registry/WorkspaceFile$Key";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getValueOrDefault";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

