/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.registry;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangHighlighting;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Trustworthiness;
import com.jetbrains.cidr.lang.daemon.clang.namehint.ClangNamehintInfo;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import com.jetbrains.sourceglider.contextSensitive.DFATuple;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public interface ClangParseResponse
extends UserDataHolderEx {
    public static final Key<Set<String>> UNSAVED_FILES = new Key("UnsavedFiles");
    public static final Key<Long> MODIFICATION_STAMP = new Key("ModificationStamp");
    public static final Key<Long> MODIFICATION_COUNT = new Key("ModificationCount");
    public static final Key<Long> PSI_GLOBAL_MODIFICATION_COUNTER = new Key("PsiGlobalModificationCounter");
    public static final Key<Trustworthiness> TRUSTWORTHINESS = new Key("Trustworthiness");

    @NotNull
    public String getUrl();

    public int getVersion();

    public boolean isCancellable();

    @NotNull
    public CompletableFuture<Boolean> getOperationState();

    @NotNull
    public CompletableFuture<Supplier<List<ClangDiagnostic>>> getDiagnostics();

    @NotNull
    public CompletableFuture<Supplier<List<ClangHighlighting>>> getHighlightings();

    @NotNull
    public CompletableFuture<Supplier<List<ClangTidyDiagnostic>>> getOurTidyDiagnostics();

    @NotNull
    public CompletableFuture<Supplier<List<ClangTidyDiagnostic>>> getTidyDiagnostics();

    @NotNull
    public CompletableFuture<Supplier<List<ClangDiagnostic>>> getClazyDiagnostics();

    @NotNull
    public CompletableFuture<Supplier<List<ClangNamehintInfo>>> getNamehints();

    @NotNull
    public CompletableFuture<Supplier<List<DFATuple>>> getDFAInput();

    @NotNull
    public CompletableFuture<Boolean> getCompletionCacheReady();

    @NotNull
    default public Trustworthiness getTrustworthiness() {
        Trustworthiness trustworthiness = (Trustworthiness)this.getUserData(TRUSTWORTHINESS);
        return trustworthiness != null ? trustworthiness : new Trustworthiness();
    }

    public static boolean isInDoneState(@NotNull ClangParseResponse file) {
        if (file == null) {
            ClangParseResponse.$$$reportNull$$$0(0);
        }
        return file.getOperationState().isDone();
    }

    public static boolean isInFinishedState(@NotNull ClangParseResponse file) {
        if (file == null) {
            ClangParseResponse.$$$reportNull$$$0(1);
        }
        try {
            return ClangParseResponse.isInDoneState(file) && file.getOperationState().get() != false;
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new AssertionError((Object)"How can this happen?!");
        }
    }

    public static boolean isInFailedState(@NotNull ClangParseResponse file) {
        if (file == null) {
            ClangParseResponse.$$$reportNull$$$0(2);
        }
        try {
            return ClangParseResponse.isInDoneState(file) && file.getOperationState().get() == false;
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new AssertionError((Object)"How can this happen?!");
        }
    }

    public static CompletableFuture<?>[] getAllAnswers(@NotNull ClangParseResponse file) {
        if (file == null) {
            ClangParseResponse.$$$reportNull$$$0(3);
        }
        return new CompletableFuture[]{file.getDiagnostics(), file.getHighlightings(), file.getCompletionCacheReady(), file.getDFAInput(), file.getNamehints(), file.getOurTidyDiagnostics(), file.getTidyDiagnostics(), file.getClazyDiagnostics()};
    }

    public static void completeAnswers(@NotNull ClangParseResponse file) {
        if (file == null) {
            ClangParseResponse.$$$reportNull$$$0(4);
        }
        for (CompletableFuture<?> future : ClangParseResponse.getAllAnswers(file)) {
            if (future.isDone()) continue;
            future.complete(null);
        }
    }

    public static void completeAnswersExceptionally(@NotNull ClangParseResponse file, @NotNull Throwable ex) {
        if (file == null) {
            ClangParseResponse.$$$reportNull$$$0(5);
        }
        if (ex == null) {
            ClangParseResponse.$$$reportNull$$$0(6);
        }
        for (CompletableFuture<?> future : ClangParseResponse.getAllAnswers(file)) {
            if (future.isDone()) continue;
            future.completeExceptionally(ex);
        }
    }

    public static boolean didAnswersCome(@NotNull ClangParseResponse file) {
        CompletableFuture<?>[] answers;
        if (file == null) {
            ClangParseResponse.$$$reportNull$$$0(7);
        }
        for (CompletableFuture<?> answer : answers = ClangParseResponse.getAllAnswers(file)) {
            if (answer.isDone() && !answer.isCompletedExceptionally()) continue;
            return false;
        }
        return true;
    }

    public static boolean areAnswersCompleted(@NotNull ClangParseResponse file) {
        CompletableFuture<?>[] answers;
        if (file == null) {
            ClangParseResponse.$$$reportNull$$$0(8);
        }
        for (CompletableFuture<?> answer : answers = ClangParseResponse.getAllAnswers(file)) {
            if (answer.isDone()) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ex";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/registry/ClangParseResponse";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isInDoneState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isInFinishedState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isInFailedState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getAllAnswers";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "completeAnswers";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "completeAnswersExceptionally";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "didAnswersCome";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "areAnswersCompleted";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

