/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java.actions;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.actions.DiagramCreateNewElementAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.services.GraphSelectionService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.uml.java.JavaUmlDataModel;
import com.intellij.uml.java.actions.CreateNewInfo;
import com.intellij.uml.java.actions.NewClassOnUmlDialog;
import com.intellij.uml.java.utils.DiagramJavaBundle;
import com.intellij.uml.java.utils.UmlJavaUtils;
import com.intellij.uml.utils.DiagramBundle;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CreateNewBase
extends DiagramCreateNewElementAction<PsiElement, CreateNewInfo> {
    protected CreateNewBase(@NotNull Supplier<@Nls String> dynamicName, Icon icon) {
        if (dynamicName == null) {
            CreateNewBase.$$$reportNull$$$0(0);
        }
        super(dynamicName, Presentation.NULL_STRING, icon);
    }

    protected abstract String getTitle();

    @Nullable
    protected abstract PsiClass create(PsiDirectory var1, String var2);

    @Override
    public CreateNewInfo prepare(@NotNull AnActionEvent e) {
        DiagramBuilder builder;
        if (e == null) {
            CreateNewBase.$$$reportNull$$$0(1);
        }
        if ((builder = CreateNewBase.getBuilder(e)) != null) {
            DiagramNode<?> node;
            PsiElement initialElement = ((JavaUmlDataModel)builder.getDataModel()).getInitialElement();
            PsiPackage psiPackage = null;
            List nodes = GraphSelectionService.getInstance().getSelectedNodes(builder.getGraph());
            if (nodes.size() == 1 && (node = builder.getNodeObject((Node)nodes.get(0))) != null && node.getIdentifyingElement() instanceof PsiPackage) {
                psiPackage = (PsiPackage)node.getIdentifyingElement();
            }
            if (psiPackage == null) {
                psiPackage = UmlJavaUtils.getPackage(initialElement);
            }
            if (psiPackage == null) {
                return null;
            }
            NewClassOnUmlDialog dialog = new NewClassOnUmlDialog(psiPackage);
            dialog.setTitle(DiagramJavaBundle.message("dialog.title.create.0", this.getTitle()));
            dialog.show();
            if (dialog.getExitCode() != 0) {
                return null;
            }
            if (dialog.getPsiDirectory() != null) {
                return new CreateNewInfo(dialog.getClassName(), dialog.getPsiDirectory(), dialog.getPackage());
            }
        }
        return null;
    }

    @Override
    public PsiElement createElement(DiagramDataModel<PsiElement> model, CreateNewInfo info, AnActionEvent event) {
        PsiDirectory directory = info.prepareDirectory();
        PsiClass cls = this.create(directory, info.fqn);
        if (cls == null) {
            ApplicationUtil.showDialogAfterWriteAction(() -> Messages.showErrorDialog((Project)model.getProject(), (String)DiagramBundle.message("cant.create.element", info.fqn, directory.getVirtualFile().getPath()), (String)DiagramBundle.message("error", new Object[0])));
            return null;
        }
        return cls;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/uml/java/actions/CreateNewBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "prepare";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

