/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.makefile;

import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.lang.makefile.MakefileLexerAdapter;
import com.jetbrains.lang.makefile.psi.MakefileTypes;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J \u0010\u0005\u001a\r\u0012\t\u0012\u00070\u0007\u00a2\u0006\u0002\b\b0\u00062\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\r"}, d2={"Lcom/jetbrains/lang/makefile/MakefileSyntaxHighlighter;", "Lcom/intellij/openapi/fileTypes/SyntaxHighlighterBase;", "()V", "getHighlightingLexer", "Lcom/jetbrains/lang/makefile/MakefileLexerAdapter;", "getTokenHighlights", "", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "Lorg/jetbrains/annotations/NotNull;", "tokenType", "Lcom/intellij/psi/tree/IElementType;", "(Lcom/intellij/psi/tree/IElementType;)[Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "Companion", "intellij.makefile"})
public final class MakefileSyntaxHighlighter
extends SyntaxHighlighterBase {
    @NotNull
    private static final TextAttributesKey COMMENT;
    @NotNull
    private static final TextAttributesKey DOCCOMMENT;
    @NotNull
    private static final TextAttributesKey KEYWORD;
    @NotNull
    private static final TextAttributesKey TARGET;
    @NotNull
    private static final TextAttributesKey SPECIAL_TARGET;
    @NotNull
    private static final TextAttributesKey SEPARATOR;
    @NotNull
    private static final TextAttributesKey PREREQUISITE;
    @NotNull
    private static final TextAttributesKey VARIABLE;
    @NotNull
    private static final TextAttributesKey VARIABLE_VALUE;
    @NotNull
    private static final TextAttributesKey STRING;
    @NotNull
    private static final TextAttributesKey LINE_SPLIT;
    @NotNull
    private static final TextAttributesKey TAB;
    @NotNull
    private static final TextAttributesKey FUNCTION;
    @NotNull
    private static final TextAttributesKey FUNCTION_PARAM;
    @NotNull
    private static final TextAttributesKey BRACES;
    @NotNull
    private static final TextAttributesKey PARENS;
    @NotNull
    private static final TextAttributesKey BAD_CHARACTER;
    private static final TextAttributesKey[] BAD_CHAR_KEYS;
    private static final TextAttributesKey[] SEPARATOR_KEYS;
    private static final TextAttributesKey[] KEYWORD_KEYS;
    private static final TextAttributesKey[] TARGET_KEYS;
    private static final TextAttributesKey[] PREREQUISITE_KEYS;
    private static final TextAttributesKey[] VARIABLE_KEYS;
    private static final TextAttributesKey[] VARIABLE_VALUE_KEYS;
    private static final TextAttributesKey[] STRING_KEYS;
    private static final TextAttributesKey[] LINE_SPLIT_KEYS;
    private static final TextAttributesKey[] TAB_KEYS;
    private static final TextAttributesKey[] COMMENT_KEYS;
    private static final TextAttributesKey[] DOCCOMMENT_KEYS;
    private static final TextAttributesKey[] BRACES_KEYS;
    private static final TextAttributesKey[] EMPTY_KEYS;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public TextAttributesKey[] getTokenHighlights(@NotNull IElementType tokenType) {
        Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
        IElementType iElementType = tokenType;
        return Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.DOC_COMMENT) ? DOCCOMMENT_KEYS : (Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.COMMENT) ? COMMENT_KEYS : (Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.TARGET) ? TARGET_KEYS : (Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.COLON) || Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.ASSIGN) || Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.SEMICOLON) || Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.PIPE) ? SEPARATOR_KEYS : (Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.KEYWORD_INCLUDE) || Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.KEYWORD_IFEQ) || Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.KEYWORD_IFNEQ) || Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.KEYWORD_IFDEF) || Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.KEYWORD_IFNDEF) || Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.KEYWORD_ELSE) || Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.KEYWORD_ENDIF) || Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.KEYWORD_DEFINE) || Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.KEYWORD_ENDEF) || Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.KEYWORD_UNDEFINE) || Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.KEYWORD_OVERRIDE) || Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.KEYWORD_EXPORT) || Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.KEYWORD_PRIVATE) || Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.KEYWORD_VPATH) || Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.DOLLAR) ? KEYWORD_KEYS : (Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.PREREQUISITE) ? PREREQUISITE_KEYS : (Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.VARIABLE) ? VARIABLE_KEYS : (Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.VARIABLE_VALUE) ? VARIABLE_VALUE_KEYS : (Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.SPLIT) ? LINE_SPLIT_KEYS : (Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.TAB) ? TAB_KEYS : (Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.STRING) ? STRING_KEYS : (Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.OPEN_PAREN) || Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.CLOSE_PAREN) || Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.OPEN_CURLY) || Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.CLOSE_CURLY) || Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.BACKTICK) ? BRACES_KEYS : (Intrinsics.areEqual((Object)iElementType, (Object)TokenType.BAD_CHARACTER) ? BAD_CHAR_KEYS : EMPTY_KEYS))))))))))));
    }

    @NotNull
    public MakefileLexerAdapter getHighlightingLexer() {
        return new MakefileLexerAdapter();
    }

    static {
        Companion = new Companion(null);
        TextAttributesKey textAttributesKey = TextAttributesKey.createTextAttributesKey((String)"MAKEFILE_COMMENT", (TextAttributesKey)DefaultLanguageHighlighterColors.LINE_COMMENT);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"createTextAttributesKey(\u2026ghterColors.LINE_COMMENT)");
        COMMENT = textAttributesKey;
        TextAttributesKey textAttributesKey2 = TextAttributesKey.createTextAttributesKey((String)"MAKEFILE_DOCCOMMENT", (TextAttributesKey)DefaultLanguageHighlighterColors.DOC_COMMENT);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey2, (String)"createTextAttributesKey(\u2026ighterColors.DOC_COMMENT)");
        DOCCOMMENT = textAttributesKey2;
        TextAttributesKey textAttributesKey3 = TextAttributesKey.createTextAttributesKey((String)"MAKEFILE_KEYWORD", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey3, (String)"createTextAttributesKey(\u2026ighlighterColors.KEYWORD)");
        KEYWORD = textAttributesKey3;
        TextAttributesKey textAttributesKey4 = TextAttributesKey.createTextAttributesKey((String)"MAKEFILE_TARGET", (TextAttributesKey)DefaultLanguageHighlighterColors.CLASS_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey4, (String)"createTextAttributesKey(\u2026lighterColors.CLASS_NAME)");
        TARGET = textAttributesKey4;
        TextAttributesKey textAttributesKey5 = TextAttributesKey.createTextAttributesKey((String)"MAKEFILE_SPECIAL_TARGET", (TextAttributesKey)DefaultLanguageHighlighterColors.PREDEFINED_SYMBOL);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey5, (String)"createTextAttributesKey(\u2026Colors.PREDEFINED_SYMBOL)");
        SPECIAL_TARGET = textAttributesKey5;
        TextAttributesKey textAttributesKey6 = TextAttributesKey.createTextAttributesKey((String)"MAKEFILE_SEPARATOR", (TextAttributesKey)DefaultLanguageHighlighterColors.OPERATION_SIGN);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey6, (String)"createTextAttributesKey(\u2026terColors.OPERATION_SIGN)");
        SEPARATOR = textAttributesKey6;
        TextAttributesKey textAttributesKey7 = TextAttributesKey.createTextAttributesKey((String)"MAKEFILE_PREREQUISITE", (TextAttributesKey)DefaultLanguageHighlighterColors.INSTANCE_METHOD);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey7, (String)"createTextAttributesKey(\u2026erColors.INSTANCE_METHOD)");
        PREREQUISITE = textAttributesKey7;
        TextAttributesKey textAttributesKey8 = TextAttributesKey.createTextAttributesKey((String)"MAKEFILE_VARIABLE", (TextAttributesKey)DefaultLanguageHighlighterColors.GLOBAL_VARIABLE);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey8, (String)"createTextAttributesKey(\u2026erColors.GLOBAL_VARIABLE)");
        VARIABLE = textAttributesKey8;
        TextAttributesKey textAttributesKey9 = TextAttributesKey.createTextAttributesKey((String)"MAKEFILE_VARIABLE_VALUE", (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey9, (String)"createTextAttributesKey(\u2026HighlighterColors.STRING)");
        VARIABLE_VALUE = textAttributesKey9;
        TextAttributesKey textAttributesKey10 = TextAttributesKey.createTextAttributesKey((String)"MAKEFILE_STRING", (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey10, (String)"createTextAttributesKey(\u2026HighlighterColors.STRING)");
        STRING = textAttributesKey10;
        TextAttributesKey textAttributesKey11 = TextAttributesKey.createTextAttributesKey((String)"MAKEFILE_LINE_SPLIT", (TextAttributesKey)DefaultLanguageHighlighterColors.VALID_STRING_ESCAPE);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey11, (String)"createTextAttributesKey(\u2026lors.VALID_STRING_ESCAPE)");
        LINE_SPLIT = textAttributesKey11;
        TextAttributesKey textAttributesKey12 = TextAttributesKey.createTextAttributesKey((String)"MAKEFILE_TAB", (TextAttributesKey)DefaultLanguageHighlighterColors.TEMPLATE_LANGUAGE_COLOR);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey12, (String)"createTextAttributesKey(\u2026.TEMPLATE_LANGUAGE_COLOR)");
        TAB = textAttributesKey12;
        TextAttributesKey textAttributesKey13 = TextAttributesKey.createTextAttributesKey((String)"MAKEFILE_FUNCTION", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey13, (String)"createTextAttributesKey(\u2026ighlighterColors.KEYWORD)");
        FUNCTION = textAttributesKey13;
        TextAttributesKey textAttributesKey14 = TextAttributesKey.createTextAttributesKey((String)"MAKEFILE_FUNCTION_PARAM", (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey14, (String)"createTextAttributesKey(\u2026HighlighterColors.STRING)");
        FUNCTION_PARAM = textAttributesKey14;
        TextAttributesKey textAttributesKey15 = TextAttributesKey.createTextAttributesKey((String)"MAKEFILE_BRACES", (TextAttributesKey)DefaultLanguageHighlighterColors.BRACES);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey15, (String)"createTextAttributesKey(\u2026HighlighterColors.BRACES)");
        BRACES = textAttributesKey15;
        TextAttributesKey textAttributesKey16 = TextAttributesKey.createTextAttributesKey((String)"MAKEFILE_PARENTHESES", (TextAttributesKey)DefaultLanguageHighlighterColors.PARENTHESES);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey16, (String)"createTextAttributesKey(\u2026ighterColors.PARENTHESES)");
        PARENS = textAttributesKey16;
        TextAttributesKey textAttributesKey17 = TextAttributesKey.createTextAttributesKey((String)"MAKEFILE_BAD_CHARACTER", (TextAttributesKey)HighlighterColors.BAD_CHARACTER);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey17, (String)"createTextAttributesKey(\u2026hterColors.BAD_CHARACTER)");
        BAD_CHARACTER = textAttributesKey17;
        BAD_CHAR_KEYS = new TextAttributesKey[]{BAD_CHARACTER};
        SEPARATOR_KEYS = new TextAttributesKey[]{SEPARATOR};
        KEYWORD_KEYS = new TextAttributesKey[]{KEYWORD};
        TARGET_KEYS = new TextAttributesKey[]{TARGET};
        PREREQUISITE_KEYS = new TextAttributesKey[]{PREREQUISITE};
        VARIABLE_KEYS = new TextAttributesKey[]{VARIABLE};
        VARIABLE_VALUE_KEYS = new TextAttributesKey[]{VARIABLE_VALUE};
        STRING_KEYS = new TextAttributesKey[]{STRING};
        LINE_SPLIT_KEYS = new TextAttributesKey[]{LINE_SPLIT};
        TAB_KEYS = new TextAttributesKey[]{TAB};
        COMMENT_KEYS = new TextAttributesKey[]{COMMENT};
        DOCCOMMENT_KEYS = new TextAttributesKey[]{DOCCOMMENT};
        BRACES_KEYS = new TextAttributesKey[]{BRACES, PARENS};
        EMPTY_KEYS = new TextAttributesKey[0];
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b/\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\b\u001a\r\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u00050\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0016\u0010\u000b\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0007R\u001b\u0010\r\u001a\r\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u00050\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0016\u0010\u000e\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u001b\u0010\u0010\u001a\r\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u00050\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0016\u0010\u0011\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0007R\u001b\u0010\u0013\u001a\r\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u00050\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0016\u0010\u0015\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0007R\u0016\u0010\u0017\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0007R\u0016\u0010\u0019\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0007R\u001b\u0010\u001b\u001a\r\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u00050\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0016\u0010\u001c\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0007R\u001b\u0010\u001e\u001a\r\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u00050\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0016\u0010\u001f\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0007R\u0016\u0010!\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0007R\u001b\u0010#\u001a\r\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u00050\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0016\u0010$\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0007R\u001b\u0010&\u001a\r\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u00050\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0016\u0010'\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0007R\u0016\u0010)\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u0007R\u001b\u0010+\u001a\r\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u00050\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0016\u0010,\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u0007R\u001b\u0010.\u001a\r\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u00050\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0016\u0010/\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u0007R\u001b\u00101\u001a\r\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u00050\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0016\u00102\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\u0007R\u001b\u00104\u001a\r\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u00050\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0016\u00105\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010\u0007R\u001b\u00107\u001a\r\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u00050\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u00068"}, d2={"Lcom/jetbrains/lang/makefile/MakefileSyntaxHighlighter$Companion;", "", "()V", "BAD_CHARACTER", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "Lorg/jetbrains/annotations/NotNull;", "getBAD_CHARACTER", "()Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "BAD_CHAR_KEYS", "", "[Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "BRACES", "getBRACES", "BRACES_KEYS", "COMMENT", "getCOMMENT", "COMMENT_KEYS", "DOCCOMMENT", "getDOCCOMMENT", "DOCCOMMENT_KEYS", "EMPTY_KEYS", "FUNCTION", "getFUNCTION", "FUNCTION_PARAM", "getFUNCTION_PARAM", "KEYWORD", "getKEYWORD", "KEYWORD_KEYS", "LINE_SPLIT", "getLINE_SPLIT", "LINE_SPLIT_KEYS", "PARENS", "getPARENS", "PREREQUISITE", "getPREREQUISITE", "PREREQUISITE_KEYS", "SEPARATOR", "getSEPARATOR", "SEPARATOR_KEYS", "SPECIAL_TARGET", "getSPECIAL_TARGET", "STRING", "getSTRING", "STRING_KEYS", "TAB", "getTAB", "TAB_KEYS", "TARGET", "getTARGET", "TARGET_KEYS", "VARIABLE", "getVARIABLE", "VARIABLE_KEYS", "VARIABLE_VALUE", "getVARIABLE_VALUE", "VARIABLE_VALUE_KEYS", "intellij.makefile"})
    public static final class Companion {
        @NotNull
        public final TextAttributesKey getCOMMENT() {
            return COMMENT;
        }

        @NotNull
        public final TextAttributesKey getDOCCOMMENT() {
            return DOCCOMMENT;
        }

        @NotNull
        public final TextAttributesKey getKEYWORD() {
            return KEYWORD;
        }

        @NotNull
        public final TextAttributesKey getTARGET() {
            return TARGET;
        }

        @NotNull
        public final TextAttributesKey getSPECIAL_TARGET() {
            return SPECIAL_TARGET;
        }

        @NotNull
        public final TextAttributesKey getSEPARATOR() {
            return SEPARATOR;
        }

        @NotNull
        public final TextAttributesKey getPREREQUISITE() {
            return PREREQUISITE;
        }

        @NotNull
        public final TextAttributesKey getVARIABLE() {
            return VARIABLE;
        }

        @NotNull
        public final TextAttributesKey getVARIABLE_VALUE() {
            return VARIABLE_VALUE;
        }

        @NotNull
        public final TextAttributesKey getSTRING() {
            return STRING;
        }

        @NotNull
        public final TextAttributesKey getLINE_SPLIT() {
            return LINE_SPLIT;
        }

        @NotNull
        public final TextAttributesKey getTAB() {
            return TAB;
        }

        @NotNull
        public final TextAttributesKey getFUNCTION() {
            return FUNCTION;
        }

        @NotNull
        public final TextAttributesKey getFUNCTION_PARAM() {
            return FUNCTION_PARAM;
        }

        @NotNull
        public final TextAttributesKey getBRACES() {
            return BRACES;
        }

        @NotNull
        public final TextAttributesKey getPARENS() {
            return PARENS;
        }

        @NotNull
        public final TextAttributesKey getBAD_CHARACTER() {
            return BAD_CHARACTER;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

