/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.system;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.ssh.RSyncUtil;
import com.intellij.ssh.attach.SshAttachHost;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.config.unified.SshConfigManager;
import com.intellij.ssh.nio.UnixSshFileSysProvider;
import com.intellij.ssh.ui.unified.SshUiData;
import com.intellij.util.PathMapper;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SLRUMap;
import com.intellij.util.io.PathKt;
import com.jetbrains.cidr.NamedPipe;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerPathManager;
import com.jetbrains.cidr.system.CidrProcessBuilder;
import com.jetbrains.cidr.system.CidrRSyncUtil;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.system.LocalHost;
import com.jetbrains.cidr.system.MappedHost;
import com.jetbrains.cidr.system.PathMapperWrapper;
import com.jetbrains.cidr.system.RemoteDeploymentHelper;
import com.jetbrains.cidr.system.RemoteHostUtil;
import com.jetbrains.cidr.system.RemoteUtil;
import com.jetbrains.cidr.system.SystemUtil;
import com.jetbrains.cidr.system.TarUtil;
import com.jetbrains.cidr.toolchains.CidrToolsUtil;
import com.jetbrains.cidr.toolchains.OSType;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class RemoteHost
implements MappedHost,
HostMachine {
    @NotNull
    private final String myId;
    @Nullable
    private final SshConfig mySshConfig;
    @NotNull
    private final OSType myOSType;
    @NotNull
    private final RemoteCredentials myCredentials;
    @NotNull
    private final PathMapper myPathMapper;
    @NotNull
    private final FileSystem myFS;
    @NotNull
    private final File myCacheDirectory;
    @NotNull
    private final @NotNull ConcurrentMap<@NotNull String, @NotNull String> myDownloadCache;
    @Nullable
    private final Project myProject;
    @NotNull
    private final @NotNull SLRUMap<@NotNull String, @NotNull String> mySymlinkCache;
    private Path myTempDirectory;
    private Boolean myIsTarAvailable;

    public RemoteHost(@Nullable String hostId, @NotNull SshConfig sshConfig, @NotNull OSType osType, @NotNull PathMapper pathMapper, @Nullable Project project) {
        if (sshConfig == null) {
            RemoteHost.$$$reportNull$$$0(0);
        }
        if (osType == null) {
            RemoteHost.$$$reportNull$$$0(1);
        }
        if (pathMapper == null) {
            RemoteHost.$$$reportNull$$$0(2);
        }
        this(hostId, sshConfig, RemoteHost.getCredentials(sshConfig), osType, pathMapper, project);
    }

    @TestOnly
    public RemoteHost(@Nullable String hostId, @NotNull RemoteCredentials credentials, @NotNull OSType osType, @NotNull PathMapper pathMapper, @Nullable Project project) {
        if (credentials == null) {
            RemoteHost.$$$reportNull$$$0(3);
        }
        if (osType == null) {
            RemoteHost.$$$reportNull$$$0(4);
        }
        if (pathMapper == null) {
            RemoteHost.$$$reportNull$$$0(5);
        }
        this(hostId, null, credentials, osType, pathMapper, project);
    }

    @NotNull
    RemoteCredentials getCredentials() {
        RemoteCredentials remoteCredentials = this.myCredentials;
        if (remoteCredentials == null) {
            RemoteHost.$$$reportNull$$$0(6);
        }
        return remoteCredentials;
    }

    @NotNull
    private static RemoteCredentials getCredentials(@NotNull SshConfig sshConfig) {
        SshUiData data;
        if (sshConfig == null) {
            RemoteHost.$$$reportNull$$$0(7);
        }
        Object object = (data = SshConfigManager.getInstance(null).findCurrentDataById(sshConfig.getId())) == null ? new SshUiData(sshConfig) : data.copyToCredentials();
        if (object == null) {
            RemoteHost.$$$reportNull$$$0(8);
        }
        return object;
    }

    private RemoteHost(@Nullable String hostId, @Nullable SshConfig sshConfig, @NotNull RemoteCredentials credentials, @NotNull OSType osType, @NotNull PathMapper pathMapper, @Nullable Project project) {
        if (credentials == null) {
            RemoteHost.$$$reportNull$$$0(9);
        }
        if (osType == null) {
            RemoteHost.$$$reportNull$$$0(10);
        }
        if (pathMapper == null) {
            RemoteHost.$$$reportNull$$$0(11);
        }
        this.myDownloadCache = new ConcurrentHashMap<String, String>();
        this.mySymlinkCache = new SLRUMap(10000, 10000);
        this.myTempDirectory = null;
        this.myIsTarAvailable = null;
        this.myId = hostId != null ? hostId : RemoteCredentialsHolder.getCredentialsString((RemoteCredentials)credentials);
        this.myOSType = osType;
        this.mySshConfig = sshConfig;
        this.myCredentials = credentials;
        this.myPathMapper = pathMapper;
        try {
            URI stub = new URI("ssh:///");
            this.myFS = new UnixSshFileSysProvider(credentials).newFileSystem(stub, Collections.emptyMap());
        }
        catch (IOException | URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        String hostName = credentials.getHost().replace(":", "-") + "_" + credentials.getPort();
        Object presentableId = hostId != null ? hostId : hostName;
        this.myCacheDirectory = Paths.get(PathManager.getSystemPath(), new String[]{".remote", hostName, presentableId}).toFile();
        FileUtil.createDirectory((File)this.myCacheDirectory);
        this.myProject = project;
    }

    public boolean isRemote() {
        return true;
    }

    @NotNull
    public OSType getOSType() {
        OSType oSType = this.myOSType;
        if (oSType == null) {
            RemoteHost.$$$reportNull$$$0(12);
        }
        return oSType;
    }

    @NotNull
    public CidrProcessBuilder createProcessBuilder() {
        CidrProcessBuilder cidrProcessBuilder = RemoteUtil.createRemoteProcess(this.myCredentials, this.myPathMapper);
        if (cidrProcessBuilder == null) {
            RemoteHost.$$$reportNull$$$0(13);
        }
        return cidrProcessBuilder;
    }

    public void destroyProcess(@NotNull BaseProcessHandler handler) {
        if (handler == null) {
            RemoteHost.$$$reportNull$$$0(14);
        }
        handler.destroyProcess();
        String command = handler.getCommandLine();
        GeneralCommandLine cmd = new GeneralCommandLine(new String[]{"pkill", "-9", "-f", command});
        try {
            this.runProcess(cmd, 0);
        }
        catch (ExecutionException e) {
            RemoteHostUtil.LOG.warn("Cannot destroy remote process: " + command, (Throwable)e);
        }
    }

    public void killProcessTree(@NotNull BaseProcessHandler handler) {
        if (handler == null) {
            RemoteHost.$$$reportNull$$$0(15);
        }
        if (RemoteHostUtil.LOG.isDebugEnabled()) {
            RemoteHostUtil.LOG.debug("RemoteHost: kill process tree: " + handler.getCommandLine());
        }
        RemoteUtil.killProcessTree(handler);
    }

    @NotNull
    public List<ProcessInfo> getProcessList() throws ExecutionException {
        List list = new SshAttachHost(this.myCredentials).getProcessList();
        if (list == null) {
            RemoteHost.$$$reportNull$$$0(16);
        }
        return list;
    }

    public int sendSignal(int pid, @NotNull String signalName) {
        if (signalName == null) {
            RemoteHost.$$$reportNull$$$0(17);
        }
        if (RemoteHostUtil.LOG.isDebugEnabled()) {
            RemoteHostUtil.LOG.debug("RemoteHost: send signal: " + signalName + " to pid: " + pid);
        }
        return SystemUtil.sendUnixSignal(this, pid, signalName);
    }

    @NotNull
    public Path getPath(String first, String ... more) {
        String[] others = new String[more.length];
        for (int i = 0; i < more.length; ++i) {
            others[i] = this.myPathMapper.convertToRemote(more[i]);
        }
        Path path = this.myFS.getPath(this.myPathMapper.convertToRemote(first), others);
        if (path == null) {
            RemoteHost.$$$reportNull$$$0(18);
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public String toCanonicalPath(@NotNull String filePath, boolean resolveSymlink) {
        String result;
        if (filePath == null) {
            RemoteHost.$$$reportNull$$$0(19);
        }
        SLRUMap<String, String> sLRUMap = this.mySymlinkCache;
        synchronized (sLRUMap) {
            result = (String)this.mySymlinkCache.get((Object)filePath);
            if (result != null) {
                String string = result;
                // MONITOREXIT @DISABLED, blocks:[3, 7] lbl8 : MonitorExitStatement: MONITOREXIT : var3_3
                if (string == null) {
                    RemoteHost.$$$reportNull$$$0(20);
                }
                return string;
            }
        }
        Path path = this.getPath(filePath, new String[0]).normalize();
        result = resolveSymlink && Files.isSymbolicLink(path) ? RemoteHostUtil.resolveSymlink((HostMachine)this, (String)path.toString()) : path.toString();
        SLRUMap<String, String> sLRUMap2 = this.mySymlinkCache;
        synchronized (sLRUMap2) {
            this.mySymlinkCache.put((Object)filePath, (Object)result);
        }
        String string = result;
        if (string == null) {
            RemoteHost.$$$reportNull$$$0(21);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public @NotNull String @NotNull [] toCanonicalPath(@NotNull List<@NonNls String> paths, boolean resolveSymlink) {
        int i;
        if (paths == null) {
            RemoteHost.$$$reportNull$$$0(22);
        }
        String[] result = new String[paths.size()];
        LinkedHashMap<Integer, String> nonResolvedPaths = new LinkedHashMap<Integer, String>();
        SLRUMap<String, String> sLRUMap = this.mySymlinkCache;
        synchronized (sLRUMap) {
            for (i = 0; i < paths.size(); ++i) {
                String path = paths.get(i);
                String cachedPath = (String)this.mySymlinkCache.get((Object)path);
                if (cachedPath != null) {
                    result[i] = cachedPath;
                    continue;
                }
                nonResolvedPaths.put(i, path);
            }
        }
        if (nonResolvedPaths.isEmpty()) {
            if (result == null) {
                RemoteHost.$$$reportNull$$$0(23);
            }
            return result;
        }
        String[] resolvedPaths = RemoteHostUtil.resolveSymlink((HostMachine)this, nonResolvedPaths.values());
        i = 0;
        Set entries = nonResolvedPaths.entrySet();
        assert (resolvedPaths.length == entries.size());
        for (Map.Entry entry : entries) {
            String resolvedPath;
            int idx = (Integer)entry.getKey();
            String unresolvedPath = (String)entry.getValue();
            result[idx] = resolvedPath = resolvedPaths[i];
            SLRUMap<String, String> sLRUMap2 = this.mySymlinkCache;
            synchronized (sLRUMap2) {
                this.mySymlinkCache.put((Object)unresolvedPath, (Object)resolvedPath);
            }
            ++i;
        }
        if (result == null) {
            RemoteHost.$$$reportNull$$$0(24);
        }
        return result;
    }

    @NotNull
    public PathMapper getPathMapper() {
        PathMapper pathMapper = this.myPathMapper;
        if (pathMapper == null) {
            RemoteHost.$$$reportNull$$$0(25);
        }
        return pathMapper;
    }

    @NotNull
    public Path getTempDirectory() {
        if (this.myTempDirectory == null) {
            try {
                String tempFileName = RemoteUtil.generateTempFileName(this);
                this.myTempDirectory = this.getPath(tempFileName, new String[0]).getParent();
            }
            catch (Exception e) {
                RemoteHostUtil.LOG.warn("Cannot get temp file name", (Throwable)e);
                this.myTempDirectory = this.getPath("/tmp/", new String[0]);
            }
        }
        Path path = this.myTempDirectory;
        if (path == null) {
            RemoteHost.$$$reportNull$$$0(26);
        }
        return path;
    }

    @NotNull
    public Path createTempDirectory(@NotNull String prefix, @Nullable String suffix) throws IOException {
        if (prefix == null) {
            RemoteHost.$$$reportNull$$$0(27);
        }
        prefix = (String)prefix + StringUtil.notNullize((String)suffix);
        Path path = Files.createTempDirectory(this.getTempDirectory(), (String)prefix, new FileAttribute[0]);
        if (path == null) {
            RemoteHost.$$$reportNull$$$0(28);
        }
        return path;
    }

    @NotNull
    public NamedPipe openNamedPipe() throws ExecutionException {
        NamedPipe namedPipe = RemoteUtil.openPipe(this);
        if (namedPipe == null) {
            RemoteHost.$$$reportNull$$$0(29);
        }
        return namedPipe;
    }

    @NotNull
    public String getHostId() {
        String string = this.myId;
        if (string == null) {
            RemoteHost.$$$reportNull$$$0(30);
        }
        return string;
    }

    @NotNull
    public File resolvePath(@NotNull Path remoteFile) throws IOException {
        if (remoteFile == null) {
            RemoteHost.$$$reportNull$$$0(31);
        }
        String remotePath = remoteFile.toString();
        String localPath = this.myPathMapper.convertToLocal(remotePath);
        return this.syncToLocal(remoteFile, remotePath, localPath);
    }

    @NotNull
    public File resolvePath(@NotNull File localFile) throws IOException {
        if (localFile == null) {
            RemoteHost.$$$reportNull$$$0(32);
        }
        String localPath = localFile.getPath();
        String remotePath = this.myPathMapper.convertToRemote(localPath);
        Path remoteFile = this.getPath(remotePath, new String[0]);
        return this.syncToLocal(remoteFile, remotePath, localPath);
    }

    @NotNull
    public List<String> resolveAndCache(@NotNull List<String> remotePaths) {
        if (remotePaths == null) {
            RemoteHost.$$$reportNull$$$0(33);
        }
        long start = System.currentTimeMillis();
        List<String> result = this.optimiseAndResolveAndCache(remotePaths);
        if (RemoteHostUtil.LOG.isTraceEnabled()) {
            RemoteHostUtil.LOG.trace("RemoteHost: resolveAndCache took " + StringUtil.formatDuration((long)(System.currentTimeMillis() - start)));
        }
        List<String> list = result;
        if (list == null) {
            RemoteHost.$$$reportNull$$$0(34);
        }
        return list;
    }

    public void invalidateCache() {
        FileUtil.asyncDelete((File)this.myCacheDirectory);
        this.myDownloadCache.clear();
    }

    @NotNull
    public Map<String, String> readEnvironmentFile(@NotNull String file) throws IOException, ExecutionException {
        if (file == null) {
            RemoteHost.$$$reportNull$$$0(35);
        }
        String path = this.getPathMapper().convertToRemote(file);
        Map map2 = CidrToolsUtil.readLinuxEnvironmentFromFile((String)path, (HostMachine)this);
        if (map2 == null) {
            RemoteHost.$$$reportNull$$$0(36);
        }
        return map2;
    }

    @NotNull
    public List<Path> findFilesWithExtension(@NotNull Path rootPath, Boolean recursive, String ... extensions) throws IOException, ExecutionException {
        if (rootPath == null) {
            RemoteHost.$$$reportNull$$$0(37);
        }
        if (!Files.exists(rootPath, new LinkOption[0])) {
            List<Path> list = Collections.emptyList();
            if (list == null) {
                RemoteHost.$$$reportNull$$$0(38);
            }
            return list;
        }
        List list = recursive != false ? this.findFilesWithExtension(rootPath.toString(), extensions) : LocalHost.INSTANCE.findFilesWithExtension(rootPath, Boolean.valueOf(false), extensions);
        if (list == null) {
            RemoteHost.$$$reportNull$$$0(39);
        }
        return list;
    }

    private List<Path> findFilesWithExtension(@NotNull String workingDir, String ... extensions) throws ExecutionException {
        if (workingDir == null) {
            RemoteHost.$$$reportNull$$$0(40);
        }
        if (extensions == null) {
            RemoteHost.$$$reportNull$$$0(41);
        }
        GeneralCommandLine find = new GeneralCommandLine(new String[]{"find", workingDir});
        boolean isFirstElement = true;
        for (String extension : extensions) {
            if (isFirstElement) {
                isFirstElement = false;
            } else {
                find.addParameter("-or");
            }
            find.addParameter("-type");
            find.addParameter("f");
            find.addParameter("-name");
            find.addParameter("*" + extension);
        }
        find.setWorkDirectory(workingDir);
        ProcessOutput output = this.runProcess(find, 60000);
        if (CidrToolsUtil.checkSuccess((GeneralCommandLine)find, (ProcessOutput)output, (Logger)RemoteHostUtil.LOG)) {
            return ContainerUtil.mapNotNull((Collection)output.getStdoutLines(), path -> this.getPath((String)path, new String[0]));
        }
        return Collections.emptyList();
    }

    @NotNull
    private List<String> optimiseAndResolveAndCache(@NotNull List<String> remotePaths) {
        if (remotePaths == null) {
            RemoteHost.$$$reportNull$$$0(42);
        }
        if (remotePaths.isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                RemoteHost.$$$reportNull$$$0(43);
            }
            return list;
        }
        ProgressIndicator progressIndicator = RemoteHost.getProgressIndicator();
        List<String> paths = SystemUtil.removeRedundant(remotePaths);
        for (String path : paths) {
            this.resolveAndCache(path, progressIndicator);
        }
        ArrayList<String> result = new ArrayList<String>(remotePaths.size());
        for (String remotePath : remotePaths) {
            Object localPath = this.myPathMapper.canReplaceRemote(remotePath) ? this.myPathMapper.convertToLocal(remotePath) : this.myCacheDirectory.getPath() + "/" + remotePath;
            result.add((String)localPath);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            LocalFileSystem.getInstance().refreshIoFiles((Iterable)ContainerUtil.map(result, p -> new File((String)p)));
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            RemoteHost.$$$reportNull$$$0(44);
        }
        return arrayList;
    }

    private void resolveAndCache(@NotNull String remotePath, @NotNull ProgressIndicator progressIndicator) {
        boolean success;
        String cachedPath;
        if (remotePath == null) {
            RemoteHost.$$$reportNull$$$0(45);
        }
        if (progressIndicator == null) {
            RemoteHost.$$$reportNull$$$0(46);
        }
        if ((cachedPath = (String)this.myDownloadCache.get(remotePath)) != null) {
            return;
        }
        if (this.myPathMapper.canReplaceRemote(remotePath)) {
            return;
        }
        String localPath = this.myCacheDirectory.getPath() + "/" + remotePath;
        String storedPath = this.myDownloadCache.putIfAbsent(remotePath, localPath);
        if (storedPath == null && !FileUtil.exists((String)localPath) && !(success = this.syncToLocal(remotePath, localPath, progressIndicator))) {
            this.myDownloadCache.remove(remotePath);
        }
    }

    private boolean syncToLocal(@NotNull String remotePath, @NotNull String localPath, @NotNull ProgressIndicator progressIndicator) {
        if (remotePath == null) {
            RemoteHost.$$$reportNull$$$0(47);
        }
        if (localPath == null) {
            RemoteHost.$$$reportNull$$$0(48);
        }
        if (progressIndicator == null) {
            RemoteHost.$$$reportNull$$$0(49);
        }
        if (RemoteHostUtil.LOG.isDebugEnabled()) {
            RemoteHostUtil.LOG.debug("RemoteHost: resolve and cache: " + remotePath + " -> " + localPath);
        }
        try {
            File result = this.syncToLocal(this.getPath(remotePath, new String[0]), remotePath, localPath, true, progressIndicator);
            return result.exists();
        }
        catch (IOException e) {
            RemoteHostUtil.LOG.error((Throwable)e);
            return false;
        }
    }

    @NotNull
    private File syncToLocal(@NotNull Path remoteFile, @NotNull String remotePath, @NotNull String localPath) throws IOException {
        if (remoteFile == null) {
            RemoteHost.$$$reportNull$$$0(50);
        }
        if (remotePath == null) {
            RemoteHost.$$$reportNull$$$0(51);
        }
        if (localPath == null) {
            RemoteHost.$$$reportNull$$$0(52);
        }
        ProgressIndicator progressIndicator = RemoteHost.getProgressIndicator();
        return this.syncToLocal(remoteFile, remotePath, localPath, true, progressIndicator);
    }

    @NotNull
    private File syncToLocal(@NotNull Path remoteFile, @NotNull String remotePath, @NotNull String localPath, boolean resolveSymlink, @NotNull ProgressIndicator progressIndicator) throws IOException {
        BasicFileAttributes attributes;
        if (remoteFile == null) {
            RemoteHost.$$$reportNull$$$0(53);
        }
        if (remotePath == null) {
            RemoteHost.$$$reportNull$$$0(54);
        }
        if (localPath == null) {
            RemoteHost.$$$reportNull$$$0(55);
        }
        if (progressIndicator == null) {
            RemoteHost.$$$reportNull$$$0(56);
        }
        if (PathKt.isDirectory((BasicFileAttributes)(attributes = PathKt.basicAttributesIfExists((Path)remoteFile)))) {
            return this.syncDirToLocal(this.myId, this.myProject, remotePath, localPath, progressIndicator);
        }
        if (resolveSymlink && PathKt.isSymbolicLink((BasicFileAttributes)attributes)) {
            String resolvedPath = RemoteHostUtil.resolveSymlink((HostMachine)this, (String)remotePath);
            return this.syncToLocal(this.getPath(resolvedPath, new String[0]), remotePath, localPath, false, progressIndicator);
        }
        return this.syncToLocal(this.myId, this.myProject, remotePath, localPath, progressIndicator);
    }

    @NotNull
    private File syncDirToLocal(String hostId, Project project, @NotNull String remotePath, @NotNull String localPath, @NotNull ProgressIndicator progressIndicator) throws IOException {
        if (remotePath == null) {
            RemoteHost.$$$reportNull$$$0(57);
        }
        if (localPath == null) {
            RemoteHost.$$$reportNull$$$0(58);
        }
        if (progressIndicator == null) {
            RemoteHost.$$$reportNull$$$0(59);
        }
        if (RSyncUtil.canUseRSync() && Registry.is((String)"clion.remote.use.rsync")) {
            File file = CidrRSyncUtil.rsyncDirToLocal(this.myCredentials, remotePath, localPath, progressIndicator);
            if (file == null) {
                RemoteHost.$$$reportNull$$$0(60);
            }
            return file;
        }
        if (this.isTarAvailable() && Registry.is((String)"clion.remote.compress.tar")) {
            return this.tarDirAndSyncToLocal(hostId, project, remotePath, localPath, progressIndicator);
        }
        return this.syncToLocal(hostId, project, remotePath, localPath, progressIndicator);
    }

    private boolean isTarAvailable() {
        if (this.myIsTarAvailable == null) {
            this.myIsTarAvailable = RemoteUtil.isTarInstalled(this.myCredentials);
        }
        return this.myIsTarAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private File tarDirAndSyncToLocal(String hostId, Project project, @NotNull String remotePath, @NotNull String localPath, @NotNull ProgressIndicator progressIndicator) throws IOException {
        String remoteArchivePath;
        File localDir;
        block9: {
            if (remotePath == null) {
                RemoteHost.$$$reportNull$$$0(61);
            }
            if (localPath == null) {
                RemoteHost.$$$reportNull$$$0(62);
            }
            if (progressIndicator == null) {
                RemoteHost.$$$reportNull$$$0(63);
            }
            progressIndicator.checkCanceled();
            localDir = new File(localPath);
            remoteArchivePath = null;
            File archive = null;
            try {
                String localArchivePath = FileUtil.createTempFile((String)"clion_remote_archive", (String)".tar.gz", (boolean)false).getPath();
                remoteArchivePath = TarUtil.tar(this, remotePath, progressIndicator, RemoteUtil.isTextFilesSyncEnabled());
                archive = this.syncToLocal(hostId, project, remoteArchivePath, localArchivePath, progressIndicator);
                TarUtil.decompress(archive, localDir, progressIndicator);
                if (archive == null) break block9;
            }
            catch (Throwable throwable) {
                if (archive != null) {
                    FileUtil.delete(archive);
                }
                if (remoteArchivePath != null) {
                    PathKt.delete((Path)this.getPath(remoteArchivePath, new String[0]), (boolean)false);
                }
                throw throwable;
            }
            FileUtil.delete((File)archive);
        }
        if (remoteArchivePath != null) {
            PathKt.delete((Path)this.getPath(remoteArchivePath, new String[0]), (boolean)false);
        }
        File file = localDir;
        if (file == null) {
            RemoteHost.$$$reportNull$$$0(64);
        }
        return file;
    }

    @NotNull
    private File syncToLocal(String hostId, Project project, @NotNull String remotePath, @NotNull String localPath, @NotNull ProgressIndicator progressIndicator) {
        if (remotePath == null) {
            RemoteHost.$$$reportNull$$$0(65);
        }
        if (localPath == null) {
            RemoteHost.$$$reportNull$$$0(66);
        }
        if (progressIndicator == null) {
            RemoteHost.$$$reportNull$$$0(67);
        }
        progressIndicator.checkCanceled();
        File result = new File(localPath);
        try {
            if (RemoteHostUtil.LOG.isDebugEnabled()) {
                RemoteHostUtil.LOG.debug("RemoteHost: download: " + remotePath + " -> " + localPath);
            }
            assert (this.mySshConfig != null);
            RemoteDeploymentHelper.download(hostId, this.mySshConfig, project, remotePath, localPath, progressIndicator);
            if (!result.exists()) {
                RemoteHostUtil.LOG.warn("cannot download file: remote (" + remotePath + ") -> local (" + localPath + ")");
            }
        }
        catch (IOException e) {
            RemoteHostUtil.LOG.error("cannot download file: remote (" + remotePath + ") -> local (" + localPath + ")", (Throwable)e);
        }
        File file = result;
        if (file == null) {
            RemoteHost.$$$reportNull$$$0(68);
        }
        return file;
    }

    @NotNull
    public File getCacheDirectory() {
        File file = this.myCacheDirectory;
        if (file == null) {
            RemoteHost.$$$reportNull$$$0(69);
        }
        return file;
    }

    public void installDependencies() {
        this.installPrettyPrinters();
    }

    private void installPrettyPrinters() {
        Path remoteCache = this.getTempDirectory().resolve(this.getHostId()).resolve(".clion.resources");
        PathMappingSettings.PathMapping prettyPrinterMapping = new PathMappingSettings.PathMapping(CidrDebuggerPathManager.getBundledGDBSTLPrettyPrinters().getAbsolutePath(), remoteCache.resolve("pretty_printers/gdb").toString());
        String localPath = prettyPrinterMapping.getLocalRoot();
        String remotePath = prettyPrinterMapping.getRemoteRoot();
        try {
            if (!RemoteUtil.fileExists(this.myCredentials, remotePath) && this.myProject != null) {
                RemoteDeploymentHelper.upload(this.getHostId(), this.myProject, localPath, remotePath, RemoteHost.getProgressIndicator());
            }
            RemoteHost.addPathMapping(this.myPathMapper, prettyPrinterMapping);
        }
        catch (ExecutionException e) {
            RemoteHostUtil.LOG.warn("Failed to check if file exists: " + remotePath, (Throwable)e);
        }
        catch (IOException e) {
            RemoteHostUtil.LOG.warn("Uploading of `" + localPath + "` was failed", (Throwable)e);
        }
    }

    private static void addPathMapping(@NotNull PathMapper pathMapper, @NotNull PathMappingSettings.PathMapping pathMapping) {
        if (pathMapper == null) {
            RemoteHost.$$$reportNull$$$0(70);
        }
        if (pathMapping == null) {
            RemoteHost.$$$reportNull$$$0(71);
        }
        if (pathMapper instanceof PathMapperWrapper) {
            pathMapper = ((PathMapperWrapper)pathMapper).getOriginal();
        }
        if (pathMapper instanceof PathMappingSettings) {
            PathMappingSettings mapper = (PathMappingSettings)pathMapper;
            List original = mapper.getPathMappings();
            ArrayList<PathMappingSettings.PathMapping> mappings = new ArrayList<PathMappingSettings.PathMapping>(original);
            mappings.add(pathMapping);
            mapper.setPathMappings(mappings);
        }
    }

    @NotNull
    private static ProgressIndicator getProgressIndicator() {
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator == null) {
            progressIndicator = new EmptyProgressIndicator();
        }
        ProgressIndicator progressIndicator2 = progressIndicator;
        if (progressIndicator2 == null) {
            RemoteHost.$$$reportNull$$$0(72);
        }
        return progressIndicator2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 12: 
            case 13: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 43: 
            case 44: 
            case 60: 
            case 64: 
            case 68: 
            case 69: 
            case 72: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 12: 
            case 13: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 43: 
            case 44: 
            case 60: 
            case 64: 
            case 68: 
            case 69: 
            case 72: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sshConfig";
                break;
            }
            case 1: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "osType";
                break;
            }
            case 2: 
            case 5: 
            case 11: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 6: 
            case 8: 
            case 12: 
            case 13: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 43: 
            case 44: 
            case 60: 
            case 64: 
            case 68: 
            case 69: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/system/RemoteHost";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signalName";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 31: 
            case 50: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteFile";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localFile";
                break;
            }
            case 33: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePaths";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDir";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 45: 
            case 47: 
            case 51: 
            case 54: 
            case 57: 
            case 61: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePath";
                break;
            }
            case 46: 
            case 49: 
            case 56: 
            case 59: 
            case 63: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 48: 
            case 52: 
            case 55: 
            case 58: 
            case 62: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/system/RemoteHost";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCredentials";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getOSType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcessBuilder";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessList";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 20: 
            case 21: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "toCanonicalPath";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathMapper";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDirectory";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempDirectory";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "openNamedPipe";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getHostId";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveAndCache";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "readEnvironmentFile";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "findFilesWithExtension";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "optimiseAndResolveAndCache";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "syncDirToLocal";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "tarDirAndSyncToLocal";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "syncToLocal";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "getCacheDirectory";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "getProgressIndicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 8: 
            case 12: 
            case 13: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 43: 
            case 44: 
            case 60: 
            case 64: 
            case 68: 
            case 69: 
            case 72: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCredentials";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "destroyProcess";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "killProcessTree";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "sendSignal";
                break;
            }
            case 19: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "toCanonicalPath";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createTempDirectory";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "resolvePath";
                break;
            }
            case 33: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "resolveAndCache";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "readEnvironmentFile";
                break;
            }
            case 37: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "findFilesWithExtension";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "optimiseAndResolveAndCache";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "syncToLocal";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "syncDirToLocal";
                break;
            }
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "tarDirAndSyncToLocal";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "addPathMapping";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 12: 
            case 13: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 43: 
            case 44: 
            case 60: 
            case 64: 
            case 68: 
            case 69: 
            case 72: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

