/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.actions.newFile;

import com.intellij.ide.IdeView;
import com.intellij.ide.actions.TemplateKindCombo;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.FixedComboBoxEditor;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.cidr.lang.CidrLangBundle;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileLangBackendHandlerProvider;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileWithSelectedExtensionAction;
import com.jetbrains.cidr.lang.settings.FileExtensionPair;
import com.jetbrains.cidr.lang.settings.NamingConventionStyle;
import com.jetbrains.cidr.lang.ui.OCListWithEmptyItemHintRenderer;
import icons.CidrLangIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.Properties;
import javax.swing.ComboBoxEditor;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CPPQtUiClassAction
extends OCNewFileWithSelectedExtensionAction<MyCreateClassDialog> {
    @NonNls
    protected static final String QT_CLASS_TEMPLATE_NAME = "Qt Class.cpp";
    @NonNls
    protected static final String QT_CLASS_HEADER_TEMPLATE_NAME = "Qt Class Header.h";
    @NonNls
    protected static final String QT_FORM_UI_TEMPLATE_NAME = "Qt Designer Form.ui";
    @NonNls
    protected static final String QT_PARENT_CLASS_PROPERTY = "PARENT_CLASS";
    @NonNls
    protected static final String QT_USER_BEGIN_NAMESPACE_PROPERTY = "USER_BEGIN_NAMESPACE";
    @NonNls
    protected static final String QT_USER_END_NAMESPACE_PROPERTY = "USER_END_NAMESPACE";
    @NonNls
    protected static final String QT_NAMESPACE_SPECIFIER_PROPERTY = "NAMESPACE_SPECIFIER";
    @NonNls
    protected static final String QT_UI_HEADER_FILENAME_TEMPLATE_PROPERTY = "UI_HEADER_FILENAME";
    @NonNls
    protected String myFilename = "";
    @NonNls
    protected Ref<String> myParentClass = new Ref((Object)"");
    @NonNls
    protected Ref<String> myEnclosingNamespace = new Ref((Object)"");

    public CPPQtUiClassAction() {
        super((FileType)OCNewFileLangBackendHandlerProvider.getHandler().getFileType(), CidrLangBundle.message("create.cpp.qt.ui.class.title", new Object[0]), CidrLangBundle.message("create.cpp.qt.ui.class.description", new Object[0]), CidrLangIcons.FileTypes.UiForm);
    }

    @Override
    @NotNull
    protected OCNewFileActionBase.NewFileNames getNewFileNames(String selectedName) {
        LOG.assertTrue(this.getState() != null, (Object)"state");
        LOG.assertTrue(this.myFilename != null, (Object)"name");
        return CPPQtUiClassAction.getNewNames(this.myFilename, (FileExtensionPair)this.getExtensions(this.getState().project).get(0));
    }

    @Override
    @NotNull
    protected OCNewFileActionBase.NewFileNames getNewFileNames(String selectedName, @NotNull PsiFile sampleFile) {
        if (sampleFile == null) {
            CPPQtUiClassAction.$$$reportNull$$$0(0);
        }
        LOG.assertTrue(this.myFilename != null, (Object)"name");
        return CPPQtUiClassAction.getNewNames(this.myFilename, (FileExtensionPair)this.getExtensions(this.getState().project).get(0));
    }

    @NotNull
    private static OCNewFileActionBase.NewFileNames getNewNames(@NotNull String selectedName, FileExtensionPair pair) {
        if (selectedName == null) {
            CPPQtUiClassAction.$$$reportNull$$$0(1);
        }
        return new OCNewFileActionBase.NewFileNames(selectedName + "." + pair.mySourceExt, selectedName + "." + pair.myHeaderExt, Collections.singletonList(selectedName + ".ui"));
    }

    @Override
    protected boolean isValidName(@NotNull String selectedName) {
        if (selectedName == null) {
            CPPQtUiClassAction.$$$reportNull$$$0(2);
        }
        return StringUtil.isJavaIdentifier((String)selectedName);
    }

    @Override
    protected void setAdditionalProperties(Properties properties, String fileName, PsiFile sampleFile, Project project) {
        String headerName;
        properties.setProperty(QT_PARENT_CLASS_PROPERTY, (String)this.myParentClass.get());
        if (!((String)this.myEnclosingNamespace.get()).isEmpty()) {
            String enclosingNamespace = (String)this.myEnclosingNamespace.get();
            properties.setProperty(QT_NAMESPACE_SPECIFIER_PROPERTY, enclosingNamespace + "::");
            properties.setProperty(QT_USER_BEGIN_NAMESPACE_PROPERTY, "namespace " + enclosingNamespace + " {");
            properties.setProperty(QT_USER_END_NAMESPACE_PROPERTY, "} // " + enclosingNamespace);
        } else {
            properties.setProperty(QT_NAMESPACE_SPECIFIER_PROPERTY, "");
            properties.setProperty(QT_USER_BEGIN_NAMESPACE_PROPERTY, "");
            properties.setProperty(QT_USER_END_NAMESPACE_PROPERTY, "");
        }
        if (this.getState() != null) {
            headerName = this.getNewFileNames(this.mySelectedName).getHeaderName();
        } else {
            assert (sampleFile != null);
            headerName = this.getNewFileNames(this.mySelectedName, sampleFile).getHeaderName();
        }
        properties.setProperty("HEADER_FILENAME", headerName);
        String uiHeaderName = this.mySelectedName.equalsIgnoreCase(this.myFilename) ? "ui_" + this.mySelectedName + ".h" : "ui_" + this.myFilename + ".h";
        properties.setProperty(QT_UI_HEADER_FILENAME_TEMPLATE_PROPERTY, uiHeaderName);
    }

    @Override
    protected String getFileTemplate(String fileName) {
        if (OCFileTypeHelpers.isSourceFile(fileName)) {
            return QT_CLASS_TEMPLATE_NAME;
        }
        if (OCFileTypeHelpers.isHeaderFile(fileName)) {
            return QT_CLASS_HEADER_TEMPLATE_NAME;
        }
        if (fileName.endsWith(".ui")) {
            return QT_FORM_UI_TEMPLATE_NAME;
        }
        assert (false);
        return null;
    }

    @Override
    @NotNull
    protected MyCreateClassDialog createDialog(@NotNull @NlsContexts.Label String defaultName) {
        if (defaultName == null) {
            CPPQtUiClassAction.$$$reportNull$$$0(3);
        }
        return new MyCreateClassDialog(defaultName);
    }

    @NotNull
    protected ImmutableList<FileExtensionPair> getExtensions(@NotNull Project project) {
        FileExtensionPair extensionPair;
        if (project == null) {
            CPPQtUiClassAction.$$$reportNull$$$0(4);
        }
        if ((extensionPair = (FileExtensionPair)ContainerUtil.find(super.getExtensions(project), pair -> OCNewFileLangBackendHandlerProvider.getHandler().isCppFileExtension("." + pair.mySourceExt, project))) == null) {
            extensionPair = new FileExtensionPair("cpp", "h", NamingConventionStyle.NONE);
        }
        ImmutableList immutableList = ContainerUtil.immutableList(Collections.singletonList(extensionPair));
        if (immutableList == null) {
            CPPQtUiClassAction.$$$reportNull$$$0(5);
        }
        return immutableList;
    }

    @Override
    protected void selectResult(@NotNull IdeView view, PsiFile @NotNull [] createdElements) {
        if (view == null) {
            CPPQtUiClassAction.$$$reportNull$$$0(6);
        }
        if (createdElements == null) {
            CPPQtUiClassAction.$$$reportNull$$$0(7);
        }
        ContainerUtil.sort((Object[])createdElements, Comparator.comparing(psiFile -> psiFile.getName().endsWith(".h")));
        super.selectResult(view, createdElements);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sampleFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/actions/newFile/CPPQtUiClassAction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createdElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/actions/newFile/CPPQtUiClassAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNewFileNames";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getNewNames";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isValidName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDialog";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getExtensions";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "selectResult";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class MyCreateClassDialog
    extends OCNewFileWithSelectedExtensionAction.CreateFileDialog {
        @NlsSafe
        private static final String DUMMY = "Dummy";
        private JTextField myFilenameBaseField;
        @NotNull
        private final @NlsContexts.Label String myFilenameBaseFieldTitle;
        @NlsSafe
        private final String[] myAllowedParentClasses;
        private boolean mySyncFilename;
        private boolean myChangedFromCode;

        public MyCreateClassDialog(String defaultName) {
            super(CPPQtUiClassAction.this, CidrLangBundle.message("create.cpp.qt.ui.class.title", new Object[0]), defaultName);
            this.myAllowedParentClasses = new String[]{"QWidget", "QMainWindow", "QDialog"};
            this.mySyncFilename = true;
            this.myChangedFromCode = false;
            this.myFilenameBaseFieldTitle = CidrLangBundle.message("create.cpp.qt.filename.base.title", new Object[0]);
        }

        @Override
        @Nullable
        protected String collectOkActionErrors() {
            if (StringUtil.isEmptyOrSpaces((String)this.myFilenameBaseField.getText())) {
                return "";
            }
            String parent = (String)CPPQtUiClassAction.this.myParentClass.get();
            if (!StringUtil.isJavaIdentifier((String)parent)) {
                return CidrLangBundle.message("create.cpp.qt.ui.invalid.parent.message", new Object[0]);
            }
            return super.collectOkActionErrors();
        }

        @Override
        public void fillGenericControls(FormBuilder formBuilder) {
            super.fillGenericControls(formBuilder);
            this.addFilenameField(formBuilder);
            this.addParentCombobox(formBuilder);
            this.addTextEdit(formBuilder, CPPQtUiClassAction.this.myEnclosingNamespace, "", CidrLangBundle.message("create.cpp.qt.enclosing.namespace.title", new Object[0]));
        }

        @Override
        protected void addNameField(FormBuilder formBuilder) {
            this.addNameField(formBuilder, false);
        }

        private void addFilenameField(FormBuilder formBuilder) {
            this.myFilenameBaseField = new JTextField();
            this.myFilenameBaseField.setText(this.myNameField.getText());
            this.myFilenameBaseField.setMinimumSize(new Dimension(250, this.myNameField.getPreferredSize().height));
            this.myFilenameBaseField.getDocument().addDocumentListener(new DocumentListener(){

                private void handleChange() {
                    MyCreateClassDialog.this.validateOkAction();
                    if (!MyCreateClassDialog.this.myChangedFromCode && MyCreateClassDialog.this.mySyncFilename) {
                        MyCreateClassDialog.this.mySyncFilename = false;
                    }
                    CPPQtUiClassAction.this.myFilename = MyCreateClassDialog.this.myFilenameBaseField.getText();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.handleChange();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.handleChange();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.handleChange();
                }
            });
            JTextField nameFieldComponent = this.myFilenameBaseField;
            formBuilder.addLabeledComponent(this.myFilenameBaseFieldTitle, (JComponent)nameFieldComponent);
            this.myFilenameBaseField.setEnabled(this.isNameFieldEnabled());
            this.myNameField.getDocument().addDocumentListener(new DocumentListener(){

                private void handleChange() {
                    if (MyCreateClassDialog.this.mySyncFilename) {
                        try {
                            MyCreateClassDialog.this.myChangedFromCode = true;
                            MyCreateClassDialog.this.myFilenameBaseField.setText(MyCreateClassDialog.this.myNameField.getText().toLowerCase(Locale.ENGLISH));
                        }
                        finally {
                            MyCreateClassDialog.this.myChangedFromCode = false;
                        }
                    }
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.handleChange();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.handleChange();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.handleChange();
                }
            });
        }

        private void initPropertyField(final JTextField textEdit, final Ref<String> property) {
            textEdit.setMinimumSize(new Dimension(250, textEdit.getPreferredSize().height));
            textEdit.getDocument().addDocumentListener(new DocumentListener(){

                private void handleChange() {
                    property.set((Object)textEdit.getText());
                    MyCreateClassDialog.this.validateOkAction();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.handleChange();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.handleChange();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.handleChange();
                }
            });
        }

        private void addParentCombobox(FormBuilder formBuilder) {
            ComboBox combo = new ComboBox();
            FixedComboBoxEditor comboEditor = new FixedComboBoxEditor();
            combo.setEditor((ComboBoxEditor)comboEditor);
            combo.setEditable(true);
            combo.setRenderer((ListCellRenderer)new OCListWithEmptyItemHintRenderer(CidrLangBundle.message("create.cpp.qt.custom.class.title", new Object[0])));
            for (String parentClass : this.myAllowedParentClasses) {
                combo.addItem((Object)parentClass);
            }
            combo.addItem((Object)"");
            JTextField textEdit = (JTextField)comboEditor.getEditorComponent();
            this.initPropertyField(textEdit, CPPQtUiClassAction.this.myParentClass);
            combo.setSelectedIndex(0);
            CPPQtUiClassAction.this.myParentClass.set((Object)((String)combo.getItem()));
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)combo);
            formBuilder.addLabeledComponent(CidrLangBundle.message("create.cpp.qt.parent.class.title", new Object[0]), (JComponent)panel);
        }

        private void addTextEdit(FormBuilder formBuilder, @NotNull @NonNls Ref<String> property, @NotNull @NonNls String defaultValue, @NotNull @NlsContexts.Label String label) {
            if (property == null) {
                MyCreateClassDialog.$$$reportNull$$$0(0);
            }
            if (defaultValue == null) {
                MyCreateClassDialog.$$$reportNull$$$0(1);
            }
            if (label == null) {
                MyCreateClassDialog.$$$reportNull$$$0(2);
            }
            JTextField textEdit = new JTextField();
            textEdit.setText(defaultValue);
            this.initPropertyField(textEdit, property);
            formBuilder.addLabeledComponent(label, (JComponent)textEdit);
        }

        @Override
        protected void createFileTypesCombo(FormBuilder formBuilder) {
            this.myKindCombo = new TemplateKindCombo();
            this.myKindCombo.addItem(DUMMY, null, DUMMY);
        }

        @Override
        @NotNull
        protected String getPresentableName(@NotNull FileExtensionPair pair) {
            if (pair == null) {
                MyCreateClassDialog.$$$reportNull$$$0(3);
            }
            String name = super.getPresentableName(pair);
            NamingConventionStyle nc = pair.myFileNamingConvention;
            Object object = nc == NamingConventionStyle.NONE ? name : name + "  [" + nc + "]";
            if (object == null) {
                MyCreateClassDialog.$$$reportNull$$$0(4);
            }
            return object;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "property";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultValue";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "label";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pair";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/actions/newFile/CPPQtUiClassAction$MyCreateClassDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/actions/newFile/CPPQtUiClassAction$MyCreateClassDialog";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addTextEdit";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentableName";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

