/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.extensions.InternalIgnoreDependencyViolation;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.cpp.toolchains.CMakeExecutableTool;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.cpp.toolchains.GDB;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalIgnoreDependencyViolation
public class CPPToolchainUsageCollector
extends ApplicationUsagesCollector {
    @NotNull
    public String getGroupId() {
        return "cidr.toolchains";
    }

    public int getVersion() {
        return 2;
    }

    @NotNull
    public Set<MetricEvent> getMetrics() {
        Set<MetricEvent> set = new Impl().doWork();
        if (set == null) {
            CPPToolchainUsageCollector.$$$reportNull$$$0(0);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/cpp/toolchains/CPPToolchainUsageCollector", "getMetrics"));
    }

    private static class Impl {
        Set<MetricEvent> result = new HashSet<MetricEvent>();

        private Impl() {
        }

        public Set<MetricEvent> doWork() {
            List<CPPToolchains.Toolchain> toolchains = CPPToolchains.getInstance().getToolchains();
            this.result.add(MetricEventFactoryKt.newMetric((String)"Toolchains.number", (int)toolchains.size()));
            for (CPPToolchains.Toolchain toolchain : toolchains) {
                CPPToolSet toolset = toolchain.getToolSet();
                boolean canReportID = PluginInfoDetectorKt.getPluginInfo(toolset.getClass()).isDevelopedByJetBrains();
                String toolsetType = canReportID ? toolset.getName() : "third.party";
                this.addUsage("Toolset", toolsetType, null, Impl.anonymizeVersion(toolset.readToolVersion()));
                boolean isCustomCMakePath = toolchain.getCustomCMakePath() == null;
                this.addUsage("CMake", toolsetType, isCustomCMakePath ? "bundled" : "custom", isCustomCMakePath ? null : Impl.anonymizeVersion(CMakeExecutableTool.readCMakeToolVersion(toolchain)));
                this.addUsage("Make", toolsetType, toolchain.getCustomMakeToolPath() == null ? "default" : "custom", null);
                this.addUsage("C.Compiler", toolsetType, toolchain.getCustomCCompilerPath() == null ? "default" : "custom", null);
                this.addUsage("CXX.Compiler", toolsetType, toolchain.getCustomCXXCompilerPath() == null ? "default" : "custom", null);
                if (toolset.isDebugSupportDisabled() != null) continue;
                switch (toolchain.getDebuggerKind()) {
                    case BUNDLED_LLDB: {
                        this.addDebuggerUsage("LLDB", toolsetType, "bundled", null);
                        break;
                    }
                    case BUNDLED_GDB: {
                        this.addDebuggerUsage("GDB", toolsetType, "bundled", null);
                        break;
                    }
                    case CUSTOM_GDB: {
                        GDB gdb = new CPPEnvironment(toolchain).getGDB();
                        if (gdb == null) break;
                        this.addDebuggerUsage("GDB", toolsetType, "custom", Impl.anonymizeVersion(gdb.readToolVersion()));
                    }
                }
            }
            return this.result;
        }

        private static FeatureUsageData newData(@Nullable String toolsetType, @Nullable String versionType, @Nullable String version) {
            FeatureUsageData data = new FeatureUsageData();
            if (toolsetType != null) {
                data.addData("toolset", toolsetType);
            }
            if (versionType != null) {
                data.addData("version_type", versionType);
            }
            if (version != null) {
                data.addData("version", version);
            }
            return data;
        }

        private void addUsage(@NotNull String name, @Nullable String toolsetType, @Nullable String versionType, @Nullable String version) {
            if (name == null) {
                Impl.$$$reportNull$$$0(0);
            }
            this.result.add(MetricEventFactoryKt.newMetric((String)name, (FeatureUsageData)Impl.newData(toolsetType, versionType, version)));
        }

        private void addDebuggerUsage(@NotNull String debuggerKind, @Nullable String toolsetType, @Nullable String versionType, @Nullable String version) {
            if (debuggerKind == null) {
                Impl.$$$reportNull$$$0(1);
            }
            FeatureUsageData data = Impl.newData(toolsetType, versionType, version).addData("debugger", debuggerKind);
            this.result.add(MetricEventFactoryKt.newMetric((String)"Debugger", (FeatureUsageData)data));
        }

        @NotNull
        private static String anonymizeVersion(@Nullable ToolVersion version) {
            String string = version == null ? "unknown" : version.toCompactString();
            if (string == null) {
                Impl.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "debuggerKind";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/CPPToolchainUsageCollector$Impl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/CPPToolchainUsageCollector$Impl";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "anonymizeVersion";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addUsage";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "addDebuggerUsage";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

