/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp;

import com.intellij.execution.RunManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.jetbrains.cidr.cpp.CPPSettingsUtil;
import com.jetbrains.cidr.cpp.ToolchainsBundle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\u001a\u0014\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u001a\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u001a\"\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0007\u001a\u00020\u0004\u001a\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004\u001a\u001c\u0010\n\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a8\u0006\u000b"}, d2={"checkDuplicatingToolchainNames", "", "allNames", "", "", "deduplicateNames", "originalNames", "format", "extractBaseName", "originalName", "suggestNextName", "intellij.cidr.toolchains"})
@JvmName(name="CPPSettingsUtil")
public final class CPPSettingsUtil {
    @NotNull
    public static final String suggestNextName(@NotNull String originalName, @NotNull List<String> allNames) {
        Intrinsics.checkNotNullParameter((Object)originalName, (String)"originalName");
        Intrinsics.checkNotNullParameter(allNames, (String)"allNames");
        return RunManager.Companion.suggestUniqueName(originalName, (Collection)allNames);
    }

    @NotNull
    public static final String extractBaseName(@NotNull String originalName) {
        Intrinsics.checkNotNullParameter((Object)originalName, (String)"originalName");
        return RunManager.Companion.extractBaseName(originalName);
    }

    @NotNull
    public static final List<String> deduplicateNames(@NotNull List<String> originalNames) {
        Intrinsics.checkNotNullParameter(originalNames, (String)"originalNames");
        return CPPSettingsUtil.deduplicateNames(originalNames, "name (number)");
    }

    @NotNull
    public static final List<String> deduplicateNames(@NotNull List<String> originalNames, @NotNull String format) {
        Intrinsics.checkNotNullParameter(originalNames, (String)"originalNames");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        ArrayList<String> result = new ArrayList<String>((Collection)originalNames);
        String string = Pattern.quote(format);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Pattern.quote(format)");
        String patterFormat = StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)"name", (String)"\\E(.*)\\Q", (boolean)false, (int)4, null), (String)"number", (String)"\\E(\\d+)\\Q", (boolean)false, (int)4, null);
        String stringFormat = StringsKt.replace$default((String)StringsKt.replace$default((String)format, (String)"name", (String)"%1$s", (boolean)false, (int)4, null), (String)"number", (String)"%2$d", (boolean)false, (int)4, null);
        Pattern pattern = Pattern.compile(patterFormat);
        boolean hasDuplicates = false;
        do {
            hasDuplicates = false;
            HashSet<String> added = new HashSet<String>();
            int size = result.size();
            for (int i = 0; i < size; ++i) {
                String name = (String)result.get(i);
                if (added.add(name)) continue;
                hasDuplicates = true;
                int number = 0;
                Matcher matcher = pattern.matcher(name);
                if (matcher.matches()) {
                    name = matcher.group(1);
                    number = StringUtil.parseInt((String)matcher.group(2), (int)number);
                }
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                Object[] objectArray = new Object[]{name, number + 1};
                boolean bl = false;
                String string2 = String.format(stringFormat, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                result.set(i, string2);
            }
        } while (hasDuplicates);
        return result;
    }

    public static final void checkDuplicatingToolchainNames(@NotNull List<String> allNames) throws ConfigurationException {
        Intrinsics.checkNotNullParameter(allNames, (String)"allNames");
        HashSet<String> uniqueNames = new HashSet<String>();
        LinkedHashSet<String> duplicatingNames = new LinkedHashSet<String>();
        Iterable $this$forEach$iv = allNames;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            if (uniqueNames.add(it)) continue;
            duplicatingNames.add(it);
        }
        if (!duplicatingNames.isEmpty()) {
            boolean isPlural = duplicatingNames.size() > 1;
            String key = isPlural ? "cpp.toolchains.error.duplicates.exist" : "cpp.toolchains.error.duplicate.exists";
            throw (Throwable)new ConfigurationException(ToolchainsBundle.message(key, StringUtil.join((Collection)duplicatingNames, (Function)checkDuplicatingToolchainNames.2.INSTANCE, (String)", ")));
        }
    }
}

