/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FileCollectionFactory;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FilesModificationsListener {
    public FilesModificationsListener install(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            FilesModificationsListener.$$$reportNull$$$0(0);
        }
        VirtualFileManager.getInstance().addAsyncFileListener(new AsyncFileListener(){

            @Nullable
            public AsyncFileListener.ChangeApplier prepareChange(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                Set<File> watchedFiles = FilesModificationsListener.this.getWatchedFiles();
                final Set structurallyChangedFiles = FileCollectionFactory.createCanonicalFileSet();
                final HashSet filesWithContentChanges = new HashSet();
                boolean externalChange = false;
                boolean fromSave = false;
                for (VFileEvent vFileEvent : events) {
                    VFilePropertyChangeEvent propEvent;
                    ProgressManager.checkCanceled();
                    File recreatedFile = null;
                    File changedFile = null;
                    externalChange |= vFileEvent.isFromRefresh();
                    fromSave |= vFileEvent.isFromSave();
                    if (vFileEvent instanceof VFileContentChangeEvent) {
                        changedFile = new File(vFileEvent.getPath());
                    } else if (vFileEvent instanceof VFileDeleteEvent || vFileEvent instanceof VFileCreateEvent) {
                        changedFile = new File(vFileEvent.getPath());
                    } else if (vFileEvent instanceof VFileCopyEvent) {
                        VFileCopyEvent copyEvent = (VFileCopyEvent)vFileEvent;
                        recreatedFile = new File(copyEvent.getNewParent().getPath(), copyEvent.getNewChildName());
                    } else if (vFileEvent instanceof VFileMoveEvent) {
                        changedFile = new File(((VFileMoveEvent)vFileEvent).getOldPath());
                        recreatedFile = new File(((VFileMoveEvent)vFileEvent).getNewPath());
                    } else if (vFileEvent instanceof VFilePropertyChangeEvent && (propEvent = (VFilePropertyChangeEvent)vFileEvent).getPropertyName() == "name") {
                        changedFile = new File(propEvent.getOldPath());
                        recreatedFile = new File(propEvent.getNewPath());
                    }
                    if (changedFile == null && recreatedFile == null) continue;
                    for (File eachWatchedFile : watchedFiles) {
                        ProgressManager.checkCanceled();
                        if (changedFile != null && FileUtil.isAncestor((File)changedFile, (File)eachWatchedFile, (boolean)false)) {
                            if (vFileEvent instanceof VFileContentChangeEvent) {
                                ContainerUtil.addIfNotNull(filesWithContentChanges, (Object)vFileEvent.getFile());
                            } else {
                                structurallyChangedFiles.add(eachWatchedFile);
                            }
                        }
                        if (recreatedFile == null || !FileUtil.isAncestor((File)recreatedFile, (File)eachWatchedFile, (boolean)false) || !eachWatchedFile.exists()) continue;
                        structurallyChangedFiles.add(eachWatchedFile);
                    }
                }
                if (!structurallyChangedFiles.isEmpty() || !filesWithContentChanges.isEmpty()) {
                    final boolean finalExternalChange = externalChange;
                    final boolean bl = fromSave;
                    return new AsyncFileListener.ChangeApplier(){

                        public void afterVfsChange() {
                            FilesModificationsListener.this.watchedFilesChanged(structurallyChangedFiles, filesWithContentChanges, finalExternalChange, bl);
                        }
                    };
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/jetbrains/cidr/FilesModificationsListener$1", "prepareChange"));
            }
        }, parentDisposable);
        return this;
    }

    @NotNull
    protected abstract Set<File> getWatchedFiles();

    protected abstract void watchedFilesChanged(@NotNull Set<File> var1, @NotNull Set<VirtualFile> var2, boolean var3, boolean var4);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/jetbrains/cidr/FilesModificationsListener", "install"));
    }
}

