/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.go.swing.sgf.movie;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.igoweb.go.swing.FwdBackIcon;
import org.igoweb.util.Defs;

public abstract class Controller
extends JSlider {
    private JLabel playbackProgressReadout = new JLabel("", 0);
    private float speedWanted = 1.0f;
    private float playbackSpeed = -1.0f;
    private JButton homeBut;
    private JButton pauseBut;
    private JButton fwdBut;
    private JButton ffBut;
    private JButton endBut;
    private Timer playbackProgressTimer;

    public Controller() {
        SliderListener listener = new SliderListener();
        this.addChangeListener(listener);
        this.addMouseListener(listener);
        this.homeBut = new JButton(new FwdBackIcon(7));
        this.homeBut.addActionListener(new ChangeSpeedListener(7));
        this.pauseBut = new JButton(new FwdBackIcon(6));
        this.pauseBut.addActionListener(new ChangeSpeedListener(6));
        this.fwdBut = new JButton(new FwdBackIcon(2));
        this.fwdBut.addActionListener(new ChangeSpeedListener(2));
        this.ffBut = new JButton(new FwdBackIcon(3));
        this.ffBut.addActionListener(new ChangeSpeedListener(3));
        this.ffBut.setToolTipText(Defs.getString(-1776683315));
        this.endBut = new JButton(new FwdBackIcon(8));
        this.endBut.addActionListener(new ChangeSpeedListener(8));
    }

    public void init() {
        this.setMaximum((int)this.getPlaybackLength());
        this.speedChanged(0.0f);
    }

    protected abstract void setPlaybackParams(float var1, long var2);

    public void speedChanged(float newSpeed) {
        if (this.playbackSpeed == newSpeed) {
            return;
        }
        this.playbackSpeed = newSpeed;
        Color current = Color.red;
        Color normal = Color.black;
        this.pauseBut.setForeground(newSpeed == 0.0f ? current : normal);
        this.fwdBut.setForeground(newSpeed == 1.0f ? current : normal);
        this.ffBut.setForeground(newSpeed > 1.0f ? current : normal);
        if (this.playbackProgressTimer != null) {
            if (newSpeed == 0.0f) {
                this.updatePlaybackProgress();
                this.playbackProgressTimer.stop();
            } else {
                this.playbackProgressTimer.start();
            }
        }
    }

    protected abstract long getPlaybackPosition();

    protected abstract long getPlaybackLength();

    public void updatePlaybackProgress() {
        if (!this.getValueIsAdjusting()) {
            this.setValue((int)this.getPlaybackPosition());
        }
    }

    public JComponent getReadoutPanel() {
        JPanel result = new JPanel(new CardLayout());
        String minTxt = Defs.getString(-900134593, new Object[]{new Integer(199), new Integer(59)});
        result.add("a", this.playbackProgressReadout);
        result.add("b", new JLabel(minTxt + '/' + minTxt));
        return result;
    }

    public JComponent getButtonPanel() {
        JPanel speedPanel = new JPanel(new GridLayout(1, 3));
        speedPanel.add(this.pauseBut);
        speedPanel.add(this.fwdBut);
        speedPanel.add(this.ffBut);
        return speedPanel;
    }

    @Override
    public void addNotify() {
        if (this.playbackProgressTimer == null) {
            this.playbackProgressTimer = new Timer(500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    Controller.this.updatePlaybackProgress();
                }
            });
            if (this.playbackSpeed != 0.0f) {
                this.playbackProgressTimer.start();
            }
        }
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        if (this.playbackProgressTimer != null) {
            this.updatePlaybackProgress();
            this.playbackProgressTimer.stop();
            this.playbackProgressTimer = null;
        }
        super.removeNotify();
    }

    public float getPlaybackSpeed() {
        return this.playbackSpeed;
    }

    private class SliderListener
    extends MouseAdapter
    implements ChangeListener {
        private boolean dragging;
        private boolean mouseDown;
        private int startPos;
        private int displayedValue = -1;
        private String maxText;
        private int maxValue = -1;

        private SliderListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            int newPos = Controller.this.getValue();
            if (this.mouseDown && Controller.this.getValueIsAdjusting() && this.startPos != newPos) {
                this.dragging = true;
                if (Controller.this.speedWanted != 0.0f) {
                    Controller.this.speedWanted = 0.0f;
                    Controller.this.setPlaybackParams(0.0f, -1L);
                }
            }
            newPos /= 1000;
            int newMax = Controller.this.getMaximum();
            if (this.maxValue != newMax) {
                this.displayedValue = -1;
                this.maxValue = newMax;
                this.maxText = '/' + Defs.getString(-900134593, new Object[]{new Integer(newMax / 60000), new Integer(newMax / 1000 % 60)});
            }
            if (newPos != this.displayedValue) {
                this.displayedValue = newPos;
                Object[] args = new Object[]{new Integer(newPos / 60), new Integer(newPos % 60)};
                int len = (int)Controller.this.getPlaybackLength();
                args[0] = new Integer(len / 60000);
                args[1] = new Integer(len / 1000 % 60);
                Controller.this.playbackProgressReadout.setText(Defs.getString(-900134593, new Object[]{new Integer(newPos / 60), new Integer(newPos % 60)}) + this.maxText);
            }
        }

        @Override
        public void mousePressed(MouseEvent event) {
            this.dragging = false;
            this.mouseDown = true;
            this.startPos = Controller.this.getValue();
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            this.mouseDown = false;
            if (this.dragging) {
                this.dragging = false;
                int newPos = Controller.this.getValue();
                if (newPos != this.startPos) {
                    Controller.this.speedWanted = 0.0f;
                    Controller.this.setPlaybackParams(0.0f, newPos);
                }
            }
        }
    }

    private class ChangeSpeedListener
    implements ActionListener {
        private final int butId;

        public ChangeSpeedListener(int butId) {
            this.butId = butId;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            long newPos = -1L;
            switch (this.butId) {
                case 7: {
                    Controller.this.speedWanted = 0.0f;
                    newPos = 0L;
                    break;
                }
                case 6: {
                    Controller.this.speedWanted = 0.0f;
                    break;
                }
                case 2: {
                    Controller.this.speedWanted = 1.0f;
                    break;
                }
                case 3: {
                    Controller.this.speedWanted = Controller.this.speedWanted < 1.0f ? 2.0f : Controller.this.speedWanted + 1.0f;
                    break;
                }
                case 8: {
                    Controller.this.speedWanted = 0.0f;
                    newPos = Controller.this.getPlaybackLength() + 1L;
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            Controller.this.setPlaybackParams(Controller.this.speedWanted, newPos);
            if (newPos != -1L) {
                Controller.this.setValue((int)newPos);
            }
        }
    }
}

