/*
 * Decompiled with CFR 0.152.
 */
package phase;

import java.util.concurrent.ConcurrentLinkedQueue;

public class ParamEstimates {
    private final ConcurrentLinkedQueue<RecombData> switchData = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<MismatchData> mismatchData = new ConcurrentLinkedQueue();

    public void addMismatchData(int n, double d) {
        if (n > 0) {
            this.mismatchData.add(new MismatchData(n, d));
        }
    }

    public void addSwitchData(double d, double d2) {
        if (d > 0.0) {
            this.switchData.add(new RecombData(d, d2));
        }
    }

    public float pMismatch() {
        MismatchData[] mismatchDataArray = this.mismatchData.toArray(new MismatchData[0]);
        int n = 0;
        double d = 0.0;
        for (MismatchData mismatchData : mismatchDataArray) {
            n += mismatchData.markerCnt;
            d += mismatchData.pMismatchSum;
        }
        return n == 0 ? 0.0f : (float)(d / (double)n);
    }

    public void clear() {
        this.switchData.clear();
        this.mismatchData.clear();
    }

    public float recombIntensity() {
        RecombData[] recombDataArray = this.switchData.toArray(new RecombData[0]);
        double d = 0.0;
        double d2 = 0.0;
        for (RecombData recombData : recombDataArray) {
            d += recombData.switchProb;
            d2 += recombData.genDistance;
        }
        return d2 == 0.0 ? 0.0f : (float)(d / d2);
    }

    private static class MismatchData {
        private final int markerCnt;
        private final double pMismatchSum;

        public MismatchData(int n, double d) {
            this.markerCnt = n;
            this.pMismatchSum = d;
        }
    }

    private static class RecombData {
        private final double genDistance;
        private final double switchProb;

        public RecombData(double d, double d2) {
            this.genDistance = d;
            this.switchProb = d2;
        }
    }
}

