/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.catalina.Executor;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.util.LifecycleSupport;

public class StandardThreadExecutor
implements Executor {
    protected int threadPriority = 5;
    protected boolean daemon = true;
    protected String namePrefix = "tomcat-exec-";
    protected int maxThreads = 200;
    protected int minSpareThreads = 25;
    protected int maxIdleTime = 60000;
    protected ThreadPoolExecutor executor = null;
    protected String name;
    protected AtomicInteger submittedTasksCount;
    protected int maxQueueSize = Integer.MAX_VALUE;
    private LifecycleSupport lifecycle = new LifecycleSupport(this);

    public void start() throws LifecycleException {
        this.lifecycle.fireLifecycleEvent("before_start", null);
        TaskQueue taskqueue = new TaskQueue(this.maxQueueSize);
        TaskThreadFactory tf = new TaskThreadFactory(this.namePrefix);
        this.lifecycle.fireLifecycleEvent("start", null);
        this.executor = new ThreadPoolExecutor(this.getMinSpareThreads(), this.getMaxThreads(), this.maxIdleTime, TimeUnit.MILLISECONDS, taskqueue, tf){

            protected void afterExecute(Runnable r, Throwable t) {
                AtomicInteger atomic = StandardThreadExecutor.this.submittedTasksCount;
                if (atomic != null) {
                    atomic.decrementAndGet();
                }
            }
        };
        taskqueue.setParent(this.executor);
        this.submittedTasksCount = new AtomicInteger();
        this.lifecycle.fireLifecycleEvent("after_start", null);
    }

    public void stop() throws LifecycleException {
        this.lifecycle.fireLifecycleEvent("before_stop", null);
        this.lifecycle.fireLifecycleEvent("stop", null);
        if (this.executor != null) {
            this.executor.shutdown();
        }
        this.executor = null;
        this.submittedTasksCount = null;
        this.lifecycle.fireLifecycleEvent("after_stop", null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(Runnable command, long timeout, TimeUnit unit) {
        if (this.executor == null) throw new IllegalStateException("StandardThreadPool not started.");
        this.submittedTasksCount.incrementAndGet();
        try {
            this.executor.execute(command);
            return;
        }
        catch (RejectedExecutionException rx) {
            try {
                if (((TaskQueue)this.executor.getQueue()).force(command, timeout, unit)) return;
                this.submittedTasksCount.decrementAndGet();
                throw new RejectedExecutionException("Work queue full.");
            }
            catch (InterruptedException x) {
                throw new RejectedExecutionException("Interrupted.", x);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(Runnable command) {
        if (this.executor == null) throw new IllegalStateException("StandardThreadPool not started.");
        this.submittedTasksCount.incrementAndGet();
        try {
            this.executor.execute(command);
            return;
        }
        catch (RejectedExecutionException rx) {
            if (((TaskQueue)this.executor.getQueue()).force(command)) return;
            this.submittedTasksCount.decrementAndGet();
            throw new RejectedExecutionException("Work queue full.");
        }
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public int getMinSpareThreads() {
        return this.minSpareThreads;
    }

    public String getName() {
        return this.name;
    }

    public void setThreadPriority(int threadPriority) {
        this.threadPriority = threadPriority;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public void setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
        if (this.executor != null) {
            this.executor.setKeepAliveTime(maxIdleTime, TimeUnit.MILLISECONDS);
        }
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
        if (this.executor != null) {
            this.executor.setMaximumPoolSize(maxThreads);
        }
    }

    public void setMinSpareThreads(int minSpareThreads) {
        this.minSpareThreads = minSpareThreads;
        if (this.executor != null) {
            this.executor.setCorePoolSize(minSpareThreads);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMaxQueueSize(int size) {
        this.maxQueueSize = size;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public int getActiveCount() {
        return this.executor != null ? this.executor.getActiveCount() : 0;
    }

    public long getCompletedTaskCount() {
        return this.executor != null ? this.executor.getCompletedTaskCount() : 0L;
    }

    public int getCorePoolSize() {
        return this.executor != null ? this.executor.getCorePoolSize() : 0;
    }

    public int getLargestPoolSize() {
        return this.executor != null ? this.executor.getLargestPoolSize() : 0;
    }

    public int getPoolSize() {
        return this.executor != null ? this.executor.getPoolSize() : 0;
    }

    public int getQueueSize() {
        return this.executor != null ? this.executor.getQueue().size() : -1;
    }

    class TaskThreadFactory
    implements ThreadFactory {
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        TaskThreadFactory(String namePrefix) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = namePrefix;
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement());
            t.setDaemon(StandardThreadExecutor.this.daemon);
            t.setPriority(StandardThreadExecutor.this.getThreadPriority());
            return t;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TaskQueue
    extends LinkedBlockingQueue<Runnable> {
        ThreadPoolExecutor parent;

        public TaskQueue() {
            this.parent = null;
        }

        public TaskQueue(int capacity) {
            super(capacity);
            this.parent = null;
        }

        public TaskQueue(Collection<? extends Runnable> c) {
            super(c);
            this.parent = null;
        }

        public void setParent(ThreadPoolExecutor tp) {
            this.parent = tp;
        }

        public boolean force(Runnable o) {
            if (this.parent.isShutdown()) {
                throw new RejectedExecutionException("Executor not running, can't force a command into the queue");
            }
            return super.offer(o);
        }

        public boolean force(Runnable o, long timeout, TimeUnit unit) throws InterruptedException {
            if (this.parent.isShutdown()) {
                throw new RejectedExecutionException("Executor not running, can't force a command into the queue");
            }
            return super.offer(o, timeout, unit);
        }

        @Override
        public boolean offer(Runnable o) {
            if (this.parent == null) {
                return super.offer(o);
            }
            int poolSize = this.parent.getPoolSize();
            if (this.parent.getPoolSize() == this.parent.getMaximumPoolSize()) {
                return super.offer(o);
            }
            AtomicInteger submittedTasksCount = StandardThreadExecutor.this.submittedTasksCount;
            if (submittedTasksCount != null && submittedTasksCount.get() <= poolSize) {
                return super.offer(o);
            }
            if (poolSize < this.parent.getMaximumPoolSize()) {
                return false;
            }
            return super.offer(o);
        }
    }
}

