/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.BufferCell;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnSerializer;
import org.apache.cassandra.db.CounterCell;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.cassandra.utils.memory.AbstractAllocator;
import org.apache.cassandra.utils.memory.MemtableAllocator;

public class BufferCounterCell
extends BufferCell
implements CounterCell {
    private final long timestampOfLastDelete;

    public BufferCounterCell(CellName name, ByteBuffer value, long timestamp) {
        this(name, value, timestamp, Long.MIN_VALUE);
    }

    public BufferCounterCell(CellName name, ByteBuffer value, long timestamp, long timestampOfLastDelete) {
        super(name, value, timestamp);
        this.timestampOfLastDelete = timestampOfLastDelete;
    }

    public static CounterCell create(CellName name, ByteBuffer value, long timestamp, long timestampOfLastDelete, ColumnSerializer.Flag flag) {
        if (flag == ColumnSerializer.Flag.FROM_REMOTE || flag == ColumnSerializer.Flag.LOCAL && contextManager.shouldClearLocal(value)) {
            value = contextManager.clearAllLocal(value);
        }
        return new BufferCounterCell(name, value, timestamp, timestampOfLastDelete);
    }

    public static CounterCell createLocal(CellName name, long value, long timestamp, long timestampOfLastDelete) {
        return new BufferCounterCell(name, contextManager.createLocal(value), timestamp, timestampOfLastDelete);
    }

    @Override
    public Cell withUpdatedName(CellName newName) {
        return new BufferCounterCell(newName, this.value, this.timestamp, this.timestampOfLastDelete);
    }

    @Override
    public long timestampOfLastDelete() {
        return this.timestampOfLastDelete;
    }

    @Override
    public long total() {
        return contextManager.total(this.value);
    }

    @Override
    public int cellDataSize() {
        return super.cellDataSize() + TypeSizes.NATIVE.sizeof(this.timestampOfLastDelete);
    }

    @Override
    public int serializedSize(CellNameType type, TypeSizes typeSizes) {
        return super.serializedSize(type, typeSizes) + typeSizes.sizeof(this.timestampOfLastDelete);
    }

    @Override
    public Cell diff(Cell cell) {
        return this.diffCounter(cell);
    }

    @Override
    public void updateDigest(MessageDigest digest) {
        digest.update(this.name().toByteBuffer().duplicate());
        contextManager.updateDigest(digest, this.value());
        FBUtilities.updateWithLong(digest, this.timestamp);
        FBUtilities.updateWithByte(digest, this.serializationFlags());
        FBUtilities.updateWithLong(digest, this.timestampOfLastDelete);
    }

    @Override
    public Cell reconcile(Cell cell) {
        return this.reconcileCounter(cell);
    }

    @Override
    public boolean hasLegacyShards() {
        return contextManager.hasLegacyShards(this.value);
    }

    @Override
    public CounterCell localCopy(CFMetaData metadata, AbstractAllocator allocator) {
        return new BufferCounterCell(this.name.copy(metadata, allocator), allocator.clone(this.value), this.timestamp, this.timestampOfLastDelete);
    }

    @Override
    public CounterCell localCopy(CFMetaData metadata, MemtableAllocator allocator, OpOrder.Group opGroup) {
        return allocator.clone(this, metadata, opGroup);
    }

    @Override
    public String getString(CellNameType comparator) {
        return String.format("%s:false:%s@%d!%d", comparator.getString(this.name()), contextManager.toString(this.value()), this.timestamp(), this.timestampOfLastDelete);
    }

    @Override
    public int serializationFlags() {
        return 4;
    }

    @Override
    public void validateFields(CFMetaData metadata) throws MarshalException {
        this.validateName(metadata);
        contextManager.validateContext(this.value());
    }

    @Override
    public Cell markLocalToBeCleared() {
        ByteBuffer marked = contextManager.markLocalToBeCleared(this.value());
        return marked == this.value() ? this : new BufferCounterCell(this.name(), marked, this.timestamp(), this.timestampOfLastDelete);
    }

    @Override
    public boolean equals(Cell cell) {
        return super.equals(cell) && this.timestampOfLastDelete == ((CounterCell)cell).timestampOfLastDelete();
    }
}

