# Copyright (C) 2002-2003 Hewlett Packard
# Licensed under the GNU General Public License

# This is to be pulled into the API to define tests
# currently these only work for HP-UX

$GLOBAL_TEST{'HP_UX'}{'stack_execute'} = 
    sub { 
      # checking to see if the executable_stack bit
      # is set to zero
	
	my $exportpath=&getGlobal('BIN',"umask") ." 077; export PATH=/usr/bin;";
	my $kmtune = &getGlobal('BIN', "kmtune");       #kmtune's path
	my $kctune = &getGlobal('BIN', "kctune");       #kmtune's path
	my @kmq;     # will hold executable stack query information
	my @kmexecq; #

	# get the current kernel parameter information...
        if ( -x "$kctune") {
	    @kmq=`$exportpath $kctune -q executable_stack -P current,next_boot`;
            # @kmq will contain values of executable stack in this format:
            # current 0
            # next_boot       0

            # Put the whole thing into an array
	    @kmexecq = split /\s+/, "@kmq";
        } else {
	    @kmq = `$exportpath $kmtune -q executable_stack`;
            # @kmq will contain values of executable stack in this format:
            #Parameter             Current Dyn Planned             Module
            #============================================================
            #executable_stack            0  Y  0

            # Put only the last line into an array
	    @kmexecq = split /\s+/, $kmq[2];
        }

        # in both of the above cases, the results are in the same places in the 
        # array
	if(($kmexecq[1] ne 0) || ($kmexecq[3] ne 0)){
	    #executable stack protection is not set
	    return 0;
	} 
	else {
	    return 1;
	}
  };


$GLOBAL_TEST{'HP_UX'}{'restrict_swacls'} = 
  sub { 

      my $swagentd = &getGlobal('BIN',"swagentd");
      my $ps = &getGlobal('BIN',"ps");

      # is swagentd running
      my $isRunning= &isProcessRunning($swagentd);

      if($isRunning) {
	  my $swacl = &getGlobal('BIN','swacl');
	  my @host_swacl = `$swacl -l host`;
	  foreach my $definition (@host_swacl){
              # look for at least one non-'-' in any_other
              # by default this is a -r---
	      chomp $definition; #otherwise, \n matches as "non-dash" in regex
	      if($definition =~ /^any_other:.*[^-]+.*$/) {  # we have a winner
		  return $ASKQ;
	      }
	  }
	  
	  my @root_swacl = `$swacl -l root`;
	  foreach my $definition (@root_swacl){
              # look for at least one non-'-' in any_other
              # by default this is a -r---
	      chomp $definition; #otherwise, \n matches as "non-dash" in regex
	      if($definition =~ /^any_other:.*[^-]+.*$/) {  # we have a winner
		  return $ASKQ;
	      }
	  }

	  return $SKIPQ;
      }

      return undef;

  };


$GLOBAL_TEST{'HP_UX'}{'ndd'} = 
  sub { 

      my %newNDD = (
		    "ip_forward_directed_broadcasts" =>["ip",   "0"],
		    "ip_forward_src_routed"          =>["ip",   "0"],
		    "ip_forwarding"                  =>["ip",   "0"],
		    "ip_ire_gw_probe"                =>["ip",   "0"],
		    "ip_pmtu_strategy"               =>["ip",   "1"],
		    "ip_respond_to_echo_broadcast"   =>["ip",   "0"],
		    "ip_send_redirects"              =>["ip",   "0"],
		    "ip_send_source_quench"          =>["ip",   "0"],
		    "tcp_syn_rcvd_max"               =>["tcp","1000"],
		    "tcp_conn_request_max"           =>["tcp","4096"] );
      
      
      # get all current values (-A) starting with any of the given names
      my $ch_rc = &getGlobal('BIN','ch_rc');
      my @origParams =
	  `$ch_rc -l -A -v -p TRANSPORT_NAME -p NDD_NAME -p NDD_VALUE`;
      my $ndd_call = &getGlobal('BIN','ndd');
      
      my $nddComplete = 1;
      for my $newNDDKey (keys %newNDD){
	  my $nddGetValue = `$ndd_call -get /dev/$newNDD{$newNDDKey}[0] $newNDDKey`;
	  chomp $nddGetValue;
	  if($nddGetValue ne $newNDD{$newNDDKey}[1]) {
	      $nddComplete = 0;  # if the machine already has the proper ndd values
           }                      # then mark nddComplete.
      }  

      return $nddComplete;
      
  };


$GLOBAL_TEST{'HP_UX'}{'scan_ports'} =
    sub {
	
	if(&B_match_line(&getGlobal('BFILE',"TODO"),"Port Scan:")) {
	    # if the port scanning information is already in the TODO list then
	    # don't ask the question.
	    return 1;
	}
	else {
	    # otherwise ask the question.
	    return 0;
	}
    };

$GLOBAL_TEST{'HP_UX'}{'other_tools'} = 
    sub {
	if(&B_match_line(&getGlobal('BFILE',"TODO"),"Other Tool Information:")) {
	    # if the other security tools information is already in the TODO list then
	    # don't ask the question.
	    return 1;
	}
	else {
	    # otherwise ask the question.
	    return 0;
	}
  
    };

1;
