/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.filesystems.declmime;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.openide.filesystems.declmime.DefaultParser;
import org.netbeans.modules.openide.filesystems.declmime.FileElement;
import org.netbeans.modules.openide.filesystems.declmime.MIMEResolverProcessor;
import org.netbeans.modules.openide.filesystems.declmime.Util;
import org.netbeans.modules.openide.filesystems.declmime.XMLMIMEComponent;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MIMEResolver;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class MIMEResolverImpl {
    private static final Logger ERR = Logger.getLogger(MIMEResolverImpl.class.getName());
    static final boolean CASE_INSENSITIVE = BaseUtilities.getOperatingSystem() == 16384;
    private static final int READ_LIMIT = 4000;
    private static Set<String> readLimitReported = new HashSet<String>();
    private static final String MIME_RESOLVERS_PATH = "Services/MIMEResolver";
    private static final String USER_DEFINED_MIME_RESOLVER = "user-defined-mime-resolver";
    private static final int USER_DEFINED_MIME_RESOLVER_POSITION = 10;

    public static MIMEResolver forDescriptor(FileObject fileObject) throws IOException {
        if (fileObject.getSize() == 0L && !MIMEResolverImpl.isUserDefined(fileObject)) {
            return MIMEResolverImpl.create(fileObject);
        }
        return MIMEResolverImpl.forDescriptor(fileObject, true);
    }

    static MIMEResolver forDescriptor(FileObject fileObject, boolean bl) {
        if (bl && !MIMEResolverImpl.isUserDefined(fileObject)) {
            ERR.log(Level.WARNING, "Ineffective registration of resolver {0} use @MIMEResolver.Registration! See bug #191777.", fileObject.getPath());
            if (ERR.isLoggable(Level.FINE)) {
                try {
                    ERR.fine(fileObject.asText());
                }
                catch (IOException iOException) {
                    ERR.log(Level.FINE, null, iOException);
                }
            }
        }
        return new Impl(fileObject);
    }

    static MIMEResolver forStream(FileObject fileObject, byte[] byArray) throws IOException {
        return new Impl(fileObject, byArray);
    }

    static byte[] toStream(MIMEResolver mIMEResolver) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        ((Impl)mIMEResolver).writeExternal(dataOutputStream);
        dataOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static boolean isDeclarative(MIMEResolver mIMEResolver) {
        return mIMEResolver instanceof Impl;
    }

    public static String[] getMIMETypes(MIMEResolver mIMEResolver) {
        ((Impl)mIMEResolver).init();
        return ((Impl)mIMEResolver).implResolvableMIMETypes;
    }

    public static boolean isUserDefined(FileObject fileObject) {
        return fileObject.getAttribute(USER_DEFINED_MIME_RESOLVER) != null || fileObject.getName().equals(USER_DEFINED_MIME_RESOLVER);
    }

    public static Map<String, Set<String>> getMIMEToExtensions(FileObject fileObject) {
        FileElement[] fileElementArray;
        Impl impl;
        if (!fileObject.hasExt("xml") || fileObject.getSize() == 0L) {
            try {
                impl = (Impl)MIMEResolverImpl.create(fileObject);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                impl = null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (MIMEResolverImpl.isUserDefined(fileObject)) {
                    fileElementArray = FileUtil.toFile(fileObject);
                    ERR.log(Level.INFO, "User-defined file association settings are corrupted. Delete file " + (fileElementArray == null ? fileObject.getPath() : fileElementArray.getPath()), illegalArgumentException);
                    impl = null;
                }
                throw illegalArgumentException;
            }
            if (impl == null) {
                return Collections.emptyMap();
            }
            impl.init();
        } else {
            impl = new Impl(fileObject);
            impl.parseDesc();
        }
        HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>();
        fileElementArray = impl.smell;
        if (fileElementArray != null) {
            for (FileElement fileElement : fileElementArray) {
                Object object;
                String string = fileElement.getMimeType();
                if (string == null) continue;
                String[] stringArray = fileElement.getExtensions();
                HashSet<String> hashSet = new HashSet<String>();
                if (stringArray != null) {
                    object = stringArray;
                    int n = ((String[])object).length;
                    for (int i = 0; i < n; ++i) {
                        String string2 = object[i];
                        if (string2.length() <= 0) continue;
                        hashSet.add(string2);
                    }
                }
                if ((object = (Set)hashMap.get(string)) != null) {
                    hashSet.addAll((Collection<String>)object);
                }
                hashMap.put(string, hashSet);
            }
        }
        return hashMap;
    }

    public static FileObject getUserDefinedResolver() {
        FileObject fileObject = FileUtil.getConfigFile(MIME_RESOLVERS_PATH);
        if (fileObject != null) {
            FileObject[] fileObjectArray;
            for (FileObject fileObject2 : fileObjectArray = fileObject.getChildren()) {
                if (fileObject2.getAttribute(USER_DEFINED_MIME_RESOLVER) == null) continue;
                return fileObject2;
            }
        }
        return null;
    }

    public static synchronized boolean storeUserDefinedResolver(final Map<String, Set<String>> map) {
        Parameters.notNull((CharSequence)"mimeToExtensions", map);
        FileObject fileObject = MIMEResolverImpl.getUserDefinedResolver();
        if (fileObject != null) {
            try {
                fileObject.delete();
            }
            catch (IOException iOException) {
                ERR.log(Level.SEVERE, "Cannot delete resolver " + FileUtil.toFile(fileObject), iOException);
                return false;
            }
        }
        if (map.isEmpty()) {
            return false;
        }
        FileUtil.runAtomicAction(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                Object object;
                Document document = XMLUtil.createDocument((String)"MIME-resolver", null, (String)"-//NetBeans//DTD MIME Resolver 1.1//EN", (String)"http://www.netbeans.org/dtds/mime-resolver-1_1.dtd");
                for (Map.Entry entry : map.entrySet()) {
                    object = (String)entry.getKey();
                    Set set = (Set)entry.getValue();
                    if (set.isEmpty()) continue;
                    Element element = document.createElement("file");
                    for (String string : (Set)map.get(object)) {
                        Element element2 = document.createElement("ext");
                        element2.setAttribute("name", string);
                        element.appendChild(element2);
                    }
                    Element element3 = document.createElement("resolver");
                    element3.setAttribute("mime", (String)object);
                    element.appendChild(element3);
                    document.getDocumentElement().appendChild(element);
                }
                if (!document.getDocumentElement().hasChildNodes()) {
                    return;
                }
                Object object2 = null;
                FileObject fileObject = null;
                object = FileUtil.getConfigFile(MIMEResolverImpl.MIME_RESOLVERS_PATH);
                if (object == null) {
                    object = FileUtil.createFolder(FileUtil.getConfigRoot(), MIMEResolverImpl.MIME_RESOLVERS_PATH);
                }
                FileObject fileObject2 = ((FileObject)object).createData(MIMEResolverImpl.USER_DEFINED_MIME_RESOLVER, "xml");
                fileObject2.setAttribute(MIMEResolverImpl.USER_DEFINED_MIME_RESOLVER, Boolean.TRUE);
                fileObject2.setAttribute("position", 10);
                object2 = fileObject2.getOutputStream();
                XMLUtil.write((Document)document, (OutputStream)object2, (String)"UTF-8");
                if (object2 == null) return;
                try {
                    ((OutputStream)object2).close();
                    return;
                }
                catch (IOException iOException) {
                    ERR.log(Level.SEVERE, "Cannot close OutputStream of file " + (fileObject2 == null ? "" : FileUtil.toFile(fileObject2)), iOException);
                }
                return;
                catch (IOException iOException) {
                    try {
                        ERR.log(Level.SEVERE, "Cannot write resolver " + (fileObject == null ? "" : FileUtil.toFile(fileObject)), iOException);
                        if (object2 == null) return;
                    }
                    catch (Throwable throwable) {
                        if (object2 == null) throw throwable;
                        try {
                            ((OutputStream)object2).close();
                            throw throwable;
                        }
                        catch (IOException iOException2) {
                            ERR.log(Level.SEVERE, "Cannot close OutputStream of file " + (fileObject == null ? "" : FileUtil.toFile(fileObject)), iOException2);
                        }
                        throw throwable;
                    }
                    try {
                        ((OutputStream)object2).close();
                        return;
                    }
                    catch (IOException iOException3) {
                        ERR.log(Level.SEVERE, "Cannot close OutputStream of file " + (fileObject == null ? "" : FileUtil.toFile(fileObject)), iOException3);
                    }
                    return;
                }
            }
        });
        return fileObject == null;
    }

    public static Collection<? extends FileObject> getOrderedResolvers() {
        FileObject[] fileObjectArray = FileUtil.getConfigFile(MIME_RESOLVERS_PATH).getChildren();
        TreeMap treeMap = new TreeMap(Collections.reverseOrder());
        for (FileObject fileObject : fileObjectArray) {
            Integer n = (Integer)fileObject.getAttribute("position");
            if (n == null) {
                n = Integer.MAX_VALUE;
            }
            while (treeMap.containsKey(n)) {
                Integer n2 = n;
                Integer n3 = n = Integer.valueOf(n - 1);
            }
            treeMap.put(n, fileObject);
        }
        return treeMap.values();
    }

    private static FileElement extensionElem(List<String> list, String string) {
        FileElement fileElement = new FileElement();
        for (String string2 : list) {
            fileElement.fileCheck.addExt(string2);
        }
        fileElement.setMIME(string);
        return fileElement;
    }

    private static MIMEResolver forExts(FileObject fileObject, String string, List<String> list) throws IOException {
        FileElement[] fileElementArray = new FileElement[]{MIMEResolverImpl.extensionElem(list, string)};
        return new Impl(fileObject, fileElementArray, new String[]{string});
    }

    private static MIMEResolver forXML(FileObject fileObject, String string, List<String> list, List<String> list2, String string2, List<String> list3, List<String> list4) throws IOException {
        FileElement fileElement = new FileElement();
        for (String string3 : list) {
            fileElement.fileCheck.addExt(string3);
        }
        fileElement.rule = new XMLMIMEComponent(string2, list3, list4);
        fileElement.setMIME(string);
        if (list2.isEmpty()) {
            return new Impl(fileObject, new FileElement[]{fileElement}, new String[]{string});
        }
        FileElement fileElement2 = MIMEResolverImpl.extensionElem(list2, string);
        return new Impl(fileObject, new FileElement[]{fileElement, fileElement2}, new String[]{string});
    }

    public static MIMEResolver create(FileObject fileObject) throws IOException {
        byte[] byArray = (byte[])fileObject.getAttribute("bytes");
        if (byArray != null) {
            return MIMEResolverImpl.forStream(fileObject, byArray);
        }
        String string = (String)fileObject.getAttribute("mimeType");
        String string2 = (String)fileObject.getAttribute("element");
        List<String> list = MIMEResolverImpl.readArray(fileObject, "ext.");
        if (string2 != null) {
            List<String> list2 = MIMEResolverImpl.readArray(fileObject, "accept.");
            List<String> list3 = MIMEResolverImpl.readArray(fileObject, "ns.");
            List<String> list4 = MIMEResolverImpl.readArray(fileObject, "doctype.");
            return MIMEResolverImpl.forXML(fileObject, string, list, list2, string2, list3, list4);
        }
        if (!list.isEmpty()) {
            return MIMEResolverImpl.forExts(fileObject, string, list);
        }
        throw new IllegalArgumentException("" + fileObject);
    }

    private static List<String> readArray(FileObject fileObject, String string) {
        String string2;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while ((string2 = (String)fileObject.getAttribute(string + n++)) != null) {
            arrayList.add(string2);
        }
        return arrayList;
    }

    private static class DescParser
    extends DefaultParser {
        private FileElement[] template = null;
        private short file_state = 0;
        private XMLMIMEComponent component = null;
        private String componentDelimiter = null;
        private int patternLevel = 0;
        Set<Integer> patternLevelSet;
        private static final short IN_ROOT = 1;
        private static final short IN_FILE = 2;
        private static final short IN_RESOLVER = 3;
        private static final short IN_COMPONENT = 4;
        private static final short IN_PATTERN = 5;
        private static final short IN_EXIT = 1;
        private static final String ROOT = "MIME-resolver";
        private static final String FILE = "file";
        private static final String MIME = "mime";
        private static final String EXT = "ext";
        private static final String RESOLVER = "resolver";
        private static final String FATTR = "fattr";
        private static final String NAME = "name";
        private static final String PATTERN = "pattern";
        private static final String VALUE = "value";
        private static final String RANGE = "range";
        private static final String IGNORE_CASE = "ignorecase";
        private static final String SUBSTRING = "substring";
        private static final String MAGIC = "magic";
        private static final String HEX = "hex";
        private static final String MASK = "mask";
        private static final String TEXT = "text";
        private static final String EXIT = "exit";
        private static final String XML_RULE_COMPONENT = "xml-rule";

        DescParser(FileObject fileObject) {
            super(fileObject);
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            switch (this.state) {
                case 0: {
                    if (!ROOT.equals(string3)) {
                        this.error();
                    }
                    this.state = 1;
                    break;
                }
                case 1: {
                    if (!FILE.equals(string3)) {
                        this.error();
                    }
                    if (this.template == null) {
                        this.template = new FileElement[]{new FileElement()};
                    } else {
                        FileElement[] fileElementArray = new FileElement[this.template.length + 1];
                        System.arraycopy(this.template, 0, fileElementArray, 1, this.template.length);
                        fileElementArray[0] = new FileElement();
                        this.template = fileElementArray;
                    }
                    this.state = (short)2;
                    break;
                }
                case 2: {
                    if (this.file_state == 1) {
                        this.error();
                    }
                    if (EXT.equals(string3)) {
                        String string4 = attributes.getValue(NAME);
                        if (string4 == null) {
                            this.error();
                        }
                        this.template[0].fileCheck.addExt(string4);
                        break;
                    }
                    if (MAGIC.equals(string3)) {
                        String string5 = attributes.getValue(HEX);
                        if (string5 == null) {
                            this.error();
                        }
                        String string6 = attributes.getValue(MASK);
                        char[] cArray = string5.toCharArray();
                        byte[] byArray = null;
                        try {
                            Object[] objectArray;
                            if (string6 != null) {
                                objectArray = string6.toCharArray();
                                byArray = XMLUtil.fromHex((char[])objectArray, (int)0, (int)objectArray.length);
                            }
                            if (this.template[0].fileCheck.setMagic((byte[])(objectArray = (Object[])XMLUtil.fromHex((char[])cArray, (int)0, (int)cArray.length)), byArray)) break;
                            this.error();
                        }
                        catch (IOException iOException) {
                            this.error();
                        }
                        break;
                    }
                    if (MIME.equals(string3)) {
                        String string7 = attributes.getValue(NAME);
                        if (string7 == null) {
                            this.error();
                        }
                        this.template[0].fileCheck.addMIME(string7);
                        break;
                    }
                    if (FATTR.equals(string3)) {
                        String string8 = attributes.getValue(NAME);
                        if (string8 == null) {
                            this.error();
                        }
                        String string9 = attributes.getValue(TEXT);
                        this.template[0].fileCheck.addAttr(string8, string9);
                        break;
                    }
                    if (PATTERN.equals(string3)) {
                        String string10 = attributes.getValue(VALUE);
                        if (string10 == null) {
                            this.error();
                        }
                        int n = Integer.valueOf(attributes.getValue(RANGE));
                        assert (n <= 4000 || !readLimitReported.add(this.fo.getPath())) : "MIME resolver " + this.fo.getPath() + " should not exceed " + 4000 + " bytes limit for files content check.";
                        boolean bl = false;
                        String string11 = attributes.getValue(IGNORE_CASE);
                        if (string11 != null) {
                            bl = Boolean.valueOf(string11);
                        }
                        if (this.file_state == 5) {
                            if (this.patternLevelSet == null) {
                                this.patternLevelSet = new HashSet<Integer>();
                            }
                            if (!this.patternLevelSet.add(this.patternLevel)) {
                                this.error("Second pattern element on the same level not allowed");
                            }
                            this.template[0].fileCheck.addInnerPattern(string10, n, bl);
                        } else {
                            this.template[0].fileCheck.addPattern(string10, n, bl);
                            this.file_state = (short)5;
                        }
                        ++this.patternLevel;
                        break;
                    }
                    if (NAME.equals(string3)) {
                        String string12 = attributes.getValue(NAME);
                        if (string12 == null) {
                            this.error();
                        }
                        String string13 = attributes.getValue(SUBSTRING);
                        boolean bl = false;
                        if (string13 != null) {
                            bl = Boolean.valueOf(string13);
                        }
                        boolean bl2 = true;
                        String string14 = attributes.getValue(IGNORE_CASE);
                        if (string14 != null) {
                            bl2 = Boolean.valueOf(string14);
                        }
                        this.template[0].fileCheck.addName(string12, bl, bl2);
                        break;
                    }
                    if (RESOLVER.equals(string3)) {
                        String string15;
                        if (!this.template[0].fileCheck.isValid()) {
                            this.error();
                        }
                        if ((string15 = attributes.getValue(MIME)) == null) {
                            this.error();
                        }
                        this.template[0].setMIME(string15);
                        this.state = (short)3;
                        break;
                    }
                    if (EXIT.equals(string3)) {
                        this.template[0].fileCheck.setExit();
                        this.file_state = 1;
                        break;
                    }
                    String string16 = "Unexpected element:  " + string3;
                    this.error(string16);
                    break;
                }
                case 3: {
                    if (!XML_RULE_COMPONENT.equals(string3)) break;
                    this.enterComponent(XML_RULE_COMPONENT, new XMLMIMEComponent());
                    this.component.startElement(string, string2, string3, attributes);
                    break;
                }
                case 4: {
                    this.component.startElement(string, string2, string3, attributes);
                    break;
                }
            }
        }

        private void enterComponent(String string, XMLMIMEComponent xMLMIMEComponent) {
            this.component = xMLMIMEComponent;
            this.componentDelimiter = string;
            xMLMIMEComponent.setDocumentLocator(this.getLocator());
            this.template[0].rule = xMLMIMEComponent;
            this.state = (short)4;
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            switch (this.state) {
                case 2: {
                    if (FILE.equals(string3)) {
                        this.state = 1;
                        this.file_state = 0;
                    }
                    if (!PATTERN.equals(string3) || --this.patternLevel != 0) break;
                    this.patternLevelSet = null;
                    this.file_state = 0;
                    break;
                }
                case 3: {
                    if (!RESOLVER.equals(string3)) break;
                    this.state = (short)2;
                    break;
                }
                case 4: {
                    this.component.endElement(string, string2, string3);
                    if (!this.componentDelimiter.equals(string3)) break;
                    this.state = (short)3;
                    this.component.setDocumentLocator(null);
                }
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.state == 4) {
                this.component.characters(cArray, n, n2);
            }
        }
    }

    private static final class Impl
    extends MIMEResolver
    implements MIMEResolverProcessor.FilterInfo {
        private final FileObject data;
        private final FileChangeListener listener = new FileChangeAdapter(this){
            final /* synthetic */ Impl this$0;
            {
                this.this$0 = impl;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void fileChanged(FileEvent fileEvent) {
                Impl impl = this.this$0;
                synchronized (impl) {
                    this.this$0.state = (short)0;
                    Impl.access$202(this.this$0, null);
                }
            }
        };
        private FileElement[] smell;
        private short state;
        private String[] implResolvableMIMETypes;

        Impl(FileObject fileObject) {
            if (ERR.isLoggable(Level.FINE)) {
                ERR.log(Level.FINE, "MIMEResolverImpl.Impl.<init>({0})", fileObject);
            }
            this.state = 0;
            this.data = fileObject;
            this.data.addFileChangeListener(FileUtil.weakFileChangeListener(this.listener, this.data));
        }

        private Impl(FileObject fileObject, byte[] byArray) throws IOException {
            this.data = fileObject;
            this.state = 1;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            this.readExternal(dataInputStream);
        }

        private Impl(FileObject fileObject, FileElement[] fileElementArray, String ... stringArray) throws IOException {
            this.data = fileObject;
            this.implResolvableMIMETypes = stringArray;
            this.smell = fileElementArray;
            this.state = (short)1000;
        }

        @Override
        public String findMIMEType(FileObject fileObject) {
            if (fileObject.hasExt("xml") && fileObject.getPath().startsWith(MIMEResolverImpl.MIME_RESOLVERS_PATH)) {
                return null;
            }
            this.init();
            if (this.state == -1) {
                return null;
            }
            FileElement[] fileElementArray = this.smell;
            for (int i = fileElementArray.length - 1; i >= 0; --i) {
                String string;
                if (ERR.isLoggable(Level.FINE)) {
                    ERR.fine("findMIMEType - smell.resolve.");
                }
                if ((string = fileElementArray[i].resolve(fileObject)) == null) continue;
                if (string.equals("mime-type-to-exit")) {
                    return null;
                }
                if (ERR.isLoggable(Level.FINE)) {
                    ERR.log(Level.FINE, "MIMEResolverImpl.findMIMEType({0})={1}", new Object[]{fileObject, string});
                }
                return string;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void init() {
            Impl impl = this;
            synchronized (impl) {
                if (this.state == 0) {
                    this.state = this.parseDesc();
                }
            }
        }

        private short parseDesc() {
            this.smell = new FileElement[0];
            DescParser descParser = new DescParser(this.data);
            descParser.parse();
            FileElement[] fileElementArray = this.smell = descParser.template != null ? descParser.template : this.smell;
            if (ERR.isLoggable(Level.FINE)) {
                if (descParser.state == -1) {
                    ERR.fine("MIMEResolverImpl.Impl parsing error!");
                } else {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Parse: ");
                    for (int i = 0; i < this.smell.length; ++i) {
                        stringBuilder.append('\n').append(this.smell[i]);
                    }
                    ERR.fine(stringBuilder.toString());
                }
            }
            if (descParser.state != -1) {
                for (int i = 0; i < this.smell.length; ++i) {
                    String string = this.smell[i].getMimeType();
                    if (string == null) continue;
                    this.implResolvableMIMETypes = Util.addString(this.implResolvableMIMETypes, string);
                }
            }
            return descParser.state;
        }

        public String toString() {
            return "MIMEResolverImpl.Impl[" + this.data + "]";
        }

        public void writeExternal(DataOutput dataOutput) throws IOException {
            this.init();
            if (this.state == -1) {
                throw new IOException();
            }
            Util.writeStrings(dataOutput, this.implResolvableMIMETypes);
            dataOutput.writeInt(this.smell.length);
            for (FileElement fileElement : this.smell) {
                fileElement.writeExternal(dataOutput);
            }
        }

        private void readExternal(DataInput dataInput) throws IOException {
            if (this.state != 1) {
                throw new IOException();
            }
            try {
                this.implResolvableMIMETypes = Util.readStrings(dataInput);
                this.smell = new FileElement[dataInput.readInt()];
                for (int i = 0; i < this.smell.length; ++i) {
                    this.smell[i] = new FileElement();
                    this.smell[i].readExternal(dataInput);
                }
                this.state = (short)1000;
            }
            finally {
                if (this.state == 1) {
                    this.state = (short)-1;
                }
            }
        }

        @Override
        public List<String> getExtensions() {
            if (this.smell == null) {
                return Collections.emptyList();
            }
            LinkedList<String> linkedList = new LinkedList<String>();
            for (FileElement fileElement : this.smell) {
                if (fileElement == null || fileElement.getExtensions() == null || fileElement.getNames() != null && !fileElement.getNames().isEmpty()) continue;
                for (String string : fileElement.getExtensions()) {
                    if (string == null || string.isEmpty()) continue;
                    linkedList.add(string);
                }
            }
            return linkedList;
        }

        @Override
        public List<String> getFileNames() {
            if (this.smell == null) {
                return Collections.emptyList();
            }
            LinkedList<String> linkedList = new LinkedList<String>();
            for (FileElement fileElement : this.smell) {
                if (fileElement == null || fileElement.getNames() == null) continue;
                for (FileElement.Type.FileName fileName : fileElement.getNames()) {
                    String[] stringArray = fileElement.getExtensions();
                    if (stringArray == null || stringArray.length == 0) continue;
                    for (String string : stringArray) {
                        linkedList.add(fileName.toString() + string);
                    }
                }
            }
            return linkedList;
        }

        static /* synthetic */ String[] access$202(Impl impl, String[] stringArray) {
            impl.implResolvableMIMETypes = stringArray;
            return stringArray;
        }
    }
}

