'\"
'\" Copyright (c) 2022 Marc Culler
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
.TH nsimage n 9.0 Tk "Tk Built-In Commands"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
nsimage \- A Tk image type for macOS based on the NSImage class.
.BE
.SH DESCRIPTION
The nsimage is implemented as a Tk image type.  The \fBimage\fR
command is used to create, delete, and query all images, including
images of type \fBnsimage\fR.  The options that are available are
specific to the nsimage type and are described below.
.PP
The command to create an \fBnsimage\fR:
.TP
\fBimage create nsimage \fR?\fIname\fR? ?\fIoption value ...\fR?
.PP
creates a new nsimage and a command with the same name and returns its
name.
.SH OPTIONS
.PP
Valid \fIoptions\fR are:
.\" OPTION: -source
.TP
\fB\-source\fI string\fR
.PP
The value of the \fB\-source\fR option is a string describing an
NSimage.  There are several ways to interpret this string, and the
interpretation is determined by the value of the \fB\-as\fR option.
This option is required.
.PP
.\" OPTION: -as
.TP
\fB\-as\fI type\fR
.PP
There are four possible values for the \fB\-as\fR option which specify
how the source string should be interpreted.  The allowed values and
their meanings are:
.RS
.IP \fBname\fR
The source should be interpreted as the name of a named NSImage
provided by the system.
This is the default if the \fB\-as\fR option is not specified.
.IP \fBfile\fR
The source should be interpreted as a path to an image
file in one of the formats understood by the NSImage class.
.IP \fBpath\fR
The source should be interpreted as a path to an arbitrary
file. The type of the file will be examined and the resulting image
will be the system icon for files of that type.
.IP \fBfiletype\fR
The source is interpreted as a string identifying a
particular file type.  It may be a filename extension, an Apple Uniform Type
Identifier or a 4-character OSType value as used in the HFS filesystem.
.RE
.\" OPTION: -width
.TP
\fB\-width\fI pixels\fR
.PP
The value of the \fIwidth\fR option is an integer specifying the width
in pixels of the nsimage.  If the width is not specified it will be
computed from the height so as to preserve the aspect ration.  If
neither width nor height are specified then the width and height of
the underlying NSImage will be used.
.\" OPTION: -height
.TP
\fB\-height\fI pixels\fR
.PP
The value of the \fIheight\fR option is an integer specifying the
height in pixels of the nsimage. If the height is not specified it
will be computed from the height so as to preserve the aspect ration.
If neither width nor height are specified then the width and height of
the underlying NSImage will be used.
.\" OPTION: -radius
.TP
\fB\-radius\fI pixels\fR
.PP
The value of the \fIradius\fR option is an integer.  If non-zero the
image will be clipped to a rounded rectangle with the same width and
height as the image, but with circular arcs of the specified radius
cutting off the corners of the rectangle.
.\" OPTION: -ring
.TP
\fB\-ring\fI pixels\fR
.PP
The value of the \fIring\fR option is an integer.  If non-zero then it
specifies the thickness of a focus ring which will be drawn around the
image using the control accent color specified in the System
Preferences.  The image is resized to reduce its width and height by
twice the thickness of the ring.  Note that this may create a small
amount of distortion.  The aspect ration of a non-square image will
change slightly.
.\" OPTION: -alpha
.TP
\fB\-alpha\fI float\fR
.PP
The value of the \fIalpha\fR option should be a floating point number
between 0.0 and 1.0.  This alpha value will be applied to each pixel
of the nsimage, producing a partially transparent image.  The default value
is 1.0, which makes the image opaque.
.\" OPTION: -pressed
.TP
\fB\-pressed\fI boolean\fR
.PP
The \fIpressed\fR option takes a boolean value.  If the value is true
or 1 then the image will be algorithmically modified to become darker
in light mode or lighter in dark mode.  The default is false.  For an
image button, the primary image should use the value false while the
pressed image should be the same image but with the \fIpressed\fR
option set to true.
.\" OPTION: -template
.TP
\fB\-template\fI boolean\fR
.PP
The \fItemplate\fR option takes a boolean value.  If the value is true
or 1 then the image will be marked as being a template image.  This
means that the system will algorithmically convert the image to a
light colored image when in dark mode.  For the algorithm to work
correctly the image must consist only of black pixels with alpha
values.
.SH "SEE ALSO"
image(n), options(n), photo(n)
.SH KEYWORDS
height, image, types of images, width
'\" Local Variables:
'\" mode: nroff
'\" End:
