/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.util.file.cmd;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.jmeld.util.file.FileUtil;
import org.jmeld.util.file.cmd.AbstractCmd;
import org.jmeld.util.node.FileNode;
import org.jmeld.util.node.JMDiffNode;

public class CopyFileCmd
extends AbstractCmd {
    private JMDiffNode diffNode;
    private FileNode fromFileNode;
    private FileNode toFileNode;

    public CopyFileCmd(JMDiffNode diffNode, FileNode fromFileNode, FileNode toFileNode) throws Exception {
        this.diffNode = diffNode;
        this.fromFileNode = fromFileNode;
        this.toFileNode = toFileNode;
    }

    public void createCommands() throws Exception {
        File fromFile = this.fromFileNode.getFile().getCanonicalFile();
        File toFile = this.toFileNode.getFile().getCanonicalFile();
        List<File> parentFiles = FileUtil.getParentFiles(toFile);
        Collections.reverse(parentFiles);
        for (File parentFile : parentFiles) {
            if (parentFile.exists()) continue;
            this.addCommand(new MkDirCommand(parentFile));
        }
        this.addCommand(new CopyCommand(fromFile, toFile));
        this.addFinallyCommand(new ResetCommand(this.toFileNode));
    }

    class ResetCommand
    extends AbstractCmd.Command {
        private FileNode fileNode;

        ResetCommand(FileNode fileNode) {
            super(CopyFileCmd.this);
            this.fileNode = fileNode;
        }

        public void execute() throws Exception {
            this.reset();
        }

        public void undo() {
            this.reset();
        }

        public void discard() {
            this.reset();
        }

        private void reset() {
            this.fileNode.resetContent();
            CopyFileCmd.this.diffNode.compareContents();
        }
    }

    class CopyCommand
    extends AbstractCmd.Command {
        private File fromFile;
        private File toFile;
        private File backupFile;
        private boolean toFileExists;

        CopyCommand(File fromFile, File toFile) {
            super(CopyFileCmd.this);
            this.fromFile = fromFile;
            this.toFile = toFile;
        }

        public void execute() throws Exception {
            if (this.toFile.exists()) {
                this.toFileExists = true;
                this.backupFile = FileUtil.createTempFile("jmeld", "backup");
                if (CopyFileCmd.this.debug) {
                    System.out.println("copy : " + this.toFile + " -> " + this.backupFile);
                }
                FileUtil.copy(this.toFile, this.backupFile);
            }
            if (CopyFileCmd.this.debug) {
                System.out.println("copy : " + this.fromFile + " -> " + this.toFile);
            }
            FileUtil.copy(this.fromFile, this.toFile);
        }

        public void undo() {
            try {
                if (this.toFileExists) {
                    if (this.backupFile != null) {
                        if (CopyFileCmd.this.debug) {
                            System.out.println("copy : " + this.backupFile + " -> " + this.toFile);
                        }
                        FileUtil.copy(this.backupFile, this.toFile);
                        this.backupFile.delete();
                        this.backupFile = null;
                    }
                } else {
                    if (CopyFileCmd.this.debug) {
                        System.out.println("delete : " + this.toFile);
                    }
                    this.toFile.delete();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public void discard() {
            if (this.backupFile != null) {
                if (CopyFileCmd.this.debug) {
                    System.out.println("delete : " + this.backupFile);
                }
                this.backupFile.delete();
            }
        }
    }

    class MkDirCommand
    extends AbstractCmd.Command {
        private File dirFile;

        MkDirCommand(File dirFile) throws Exception {
            super(CopyFileCmd.this);
            this.dirFile = dirFile;
        }

        public void execute() throws Exception {
            if (CopyFileCmd.this.debug) {
                System.out.println("mkdir : " + this.dirFile);
            }
            this.dirFile.mkdir();
        }

        public void undo() {
            if (CopyFileCmd.this.debug) {
                System.out.println("rmdir : " + this.dirFile);
            }
            this.dirFile.delete();
        }
    }
}

