/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale;

import java.util.List;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.BooleanIndexedColumn;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.DoubleIndexedColumn;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.IndexedColumn;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.IntegerIndexedColumn;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.StringIndexedColumn;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.TimestampIndexedColumn;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;

public class IndexedColumnFactory {
    static IndexedColumn create(List<Object[]> rows, int colIx, ColumnDisplayDefinition colDef) {
        switch (colDef.getSqlType()) {
            case -5: 
            case 4: 
            case 5: {
                return new IntegerIndexedColumn(rows, colIx, colDef);
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                return new DoubleIndexedColumn(rows, colIx, colDef);
            }
            case 91: 
            case 92: 
            case 93: {
                return new TimestampIndexedColumn(rows, colIx, colDef);
            }
            case -7: 
            case 16: {
                return new BooleanIndexedColumn(rows, colIx, colDef);
            }
        }
        return new StringIndexedColumn(rows, colIx, colDef);
    }

    public static boolean isNumber(ColumnDisplayDefinition columnDisplayDefinition) {
        switch (columnDisplayDefinition.getSqlType()) {
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public static boolean isOrderable(ColumnDisplayDefinition columnDisplayDefinition) {
        switch (columnDisplayDefinition.getSqlType()) {
            case -7: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 16: 
            case 91: 
            case 92: 
            case 93: {
                return true;
            }
        }
        return false;
    }
}

