/*
 * Decompiled with CFR 0.152.
 */
package com.digitprop.tonic;

import com.digitprop.tonic.IntelligentLineBorder;
import com.digitprop.tonic.ScrollButton;
import com.digitprop.tonic.TonicBumps;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.UIManager;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class ScrollBarUI
extends BasicScrollBarUI {
    private static Color shadowColor;
    private static Color highlightColor;
    private static Color darkShadowColor;
    private static Color thumbColor;
    private static Color thumbShadow;
    private static Color thumbHighlightColor;
    private static Color thumbStripeColor;
    protected TonicBumps bumps;
    protected ScrollButton increaseButton;
    protected ScrollButton decreaseButton;
    protected int scrollBarWidth;
    public static final String FREE_STANDING_PROP = "JScrollBar.isFreeStanding";
    protected boolean isFreeStanding = true;

    static void scrollTonicByBlock(JScrollBar scrollbar, int direction) {
        int oldValue = scrollbar.getValue();
        int blockIncrement = scrollbar.getBlockIncrement(direction);
        int delta = blockIncrement * (direction > 0 ? 1 : -1);
        scrollbar.setValue(oldValue + delta);
    }

    static void scrollTonicByUnits(JScrollBar scrollbar, int direction, int units) {
        int delta = units;
        delta = direction > 0 ? (delta *= scrollbar.getUnitIncrement(direction)) : (delta *= -scrollbar.getUnitIncrement(direction));
        int oldValue = scrollbar.getValue();
        int newValue = oldValue + delta;
        if (delta > 0 && newValue < oldValue) {
            newValue = scrollbar.getMaximum();
        } else if (delta < 0 && newValue > oldValue) {
            newValue = scrollbar.getMinimum();
        }
        scrollbar.setValue(newValue);
    }

    public static ComponentUI createUI(JComponent c) {
        return new ScrollBarUI();
    }

    protected void installDefaults() {
        this.scrollBarWidth = (Integer)UIManager.get("ScrollBar.width");
        super.installDefaults();
        this.bumps = new TonicBumps(10, 10, thumbHighlightColor, thumbShadow, thumbColor);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        if (c instanceof JScrollBar && (c.getBorder() == null || c.getBorder() instanceof BorderUIResource)) {
            c.setBorder(new IntelligentLineBorder(UIManager.getColor("Button.borderColor"), true));
        }
    }

    protected void installListeners() {
        super.installListeners();
        ((ScrollBarListener)this.propertyChangeListener).handlePropertyChange(this.scrollbar.getClientProperty(FREE_STANDING_PROP));
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new ScrollBarListener();
    }

    protected void configureScrollBarColors() {
        super.configureScrollBarColors();
        shadowColor = UIManager.getColor("ScrollBar.shadow");
        highlightColor = UIManager.getColor("ScrollBar.highlight");
        darkShadowColor = UIManager.getColor("ScrollBar.darkShadow");
        thumbColor = UIManager.getColor("ScrollBar.thumb");
        thumbShadow = UIManager.getColor("ScrollBar.thumbShadow");
        thumbHighlightColor = UIManager.getColor("ScrollBar.thumbHighlight");
        thumbStripeColor = UIManager.getColor("ScrollBar.thumbStripes");
    }

    public Dimension getPreferredSize(JComponent c) {
        if (this.scrollbar.getOrientation() == 1) {
            return new Dimension(this.scrollBarWidth, this.scrollBarWidth * 3 + 10);
        }
        return new Dimension(this.scrollBarWidth * 3 + 10, this.scrollBarWidth);
    }

    protected JButton createDecreaseButton(int orientation) {
        this.decreaseButton = new ScrollButton(orientation, this.scrollBarWidth, this.isFreeStanding);
        return this.decreaseButton;
    }

    protected JButton createIncreaseButton(int orientation) {
        this.increaseButton = new ScrollButton(orientation, this.scrollBarWidth, this.isFreeStanding);
        return this.increaseButton;
    }

    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        g.setColor(c.getBackground());
        g.fillRect(trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height);
        Container container = c.getParent();
        boolean leftTouch = c.getX() == 0;
        boolean rightTouch = c.getX() + c.getWidth() + 1 == container.getWidth();
        boolean topTouch = c.getY() == 0;
        boolean bottomTouch = c.getY() + c.getHeight() + 1 == container.getHeight();
        g.setColor(UIManager.getColor("Button.borderColor"));
        if (this.scrollbar.getOrientation() == 1) {
            g.drawLine(trackBounds.x, trackBounds.y, trackBounds.x + trackBounds.width, trackBounds.y);
            g.drawLine(trackBounds.x, trackBounds.y + trackBounds.height - 1, trackBounds.x + trackBounds.width, trackBounds.y + trackBounds.height - 1);
        } else {
            g.drawLine(trackBounds.x, trackBounds.y, trackBounds.x, trackBounds.y + trackBounds.height);
            g.drawLine(trackBounds.x + trackBounds.width - 1, trackBounds.y, trackBounds.x + trackBounds.width - 1, trackBounds.y + trackBounds.height);
        }
    }

    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        if (c.isEnabled()) {
            boolean isVertical = this.scrollbar.getOrientation() == 1;
            boolean dx = false;
            boolean dy = false;
            if (isVertical) {
                g.setColor(thumbColor);
                g.fillRect(thumbBounds.x, thumbBounds.y, thumbBounds.width, thumbBounds.height);
                g.setColor(UIManager.getColor("Button.borderColor"));
                g.drawLine(thumbBounds.x, thumbBounds.y, thumbBounds.x + thumbBounds.width, thumbBounds.y);
                g.drawLine(thumbBounds.x, thumbBounds.y + thumbBounds.height - 1, thumbBounds.x + thumbBounds.width, thumbBounds.y + thumbBounds.height - 1);
                dx = true;
            } else {
                g.setColor(thumbColor);
                g.fillRect(thumbBounds.x, thumbBounds.y, thumbBounds.width, thumbBounds.height);
                g.setColor(UIManager.getColor("Button.borderColor"));
                g.drawLine(thumbBounds.x, thumbBounds.y, thumbBounds.x, thumbBounds.y + thumbBounds.height);
                g.drawLine(thumbBounds.x + thumbBounds.width - 1, thumbBounds.y, thumbBounds.x + thumbBounds.width - 1, thumbBounds.y + thumbBounds.height);
                dy = true;
            }
            if (isVertical) {
                if (thumbBounds.height >= 60) {
                    g.setColor(thumbStripeColor);
                    this.paintStripes(g, true, thumbBounds.x + 2, thumbBounds.y + thumbBounds.height / 2 - 15, thumbBounds.width - 5, 30);
                }
            } else if (thumbBounds.width >= 60) {
                g.setColor(thumbStripeColor);
                this.paintStripes(g, false, thumbBounds.x + thumbBounds.width / 2 - 15, thumbBounds.y + 2, 30, thumbBounds.height - 5);
            }
        }
    }

    private void paintStripes(Graphics g, boolean isVertical, int x, int y, int w, int h) {
        int i = isVertical ? y : x;
        while (i <= (isVertical ? y + h : x + w)) {
            if (isVertical) {
                g.drawLine(x, i, x + w, i);
            } else {
                g.drawLine(i, y, i, y + h);
            }
            i += 2;
        }
    }

    protected Dimension getMinimumThumbSize() {
        return new Dimension(this.scrollBarWidth, this.scrollBarWidth);
    }

    protected void setThumbBounds(int x, int y, int width, int height) {
        if (this.thumbRect.x == x && this.thumbRect.y == y && this.thumbRect.width == width && this.thumbRect.height == height) {
            return;
        }
        int minX = Math.min(x, this.thumbRect.x);
        int minY = Math.min(y, this.thumbRect.y);
        int maxX = Math.max(x + width, this.thumbRect.x + this.thumbRect.width);
        int maxY = Math.max(y + height, this.thumbRect.y + this.thumbRect.height);
        this.thumbRect.setBounds(x, y, width, height);
        this.scrollbar.repaint(minX, minY, maxX - minX + 1, maxY - minY + 1);
    }

    class ScrollBarListener
    extends BasicScrollBarUI.PropertyChangeHandler {
        ScrollBarListener() {
            super(ScrollBarUI.this);
        }

        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (name.equals(ScrollBarUI.FREE_STANDING_PROP)) {
                this.handlePropertyChange(e.getNewValue());
            } else {
                super.propertyChange(e);
            }
        }

        public void handlePropertyChange(Object newValue) {
            if (newValue != null) {
                boolean temp = (Boolean)newValue;
                boolean becameFlush = !temp && ScrollBarUI.this.isFreeStanding;
                boolean becameNormal = temp && !ScrollBarUI.this.isFreeStanding;
                ScrollBarUI.this.isFreeStanding = temp;
                if (becameFlush) {
                    this.toFlush();
                } else if (becameNormal) {
                    this.toFreeStanding();
                }
            } else if (!ScrollBarUI.this.isFreeStanding) {
                ScrollBarUI.this.isFreeStanding = true;
                this.toFreeStanding();
            }
            if (ScrollBarUI.this.increaseButton != null) {
                ScrollBarUI.this.increaseButton.setFreeStanding(ScrollBarUI.this.isFreeStanding);
            }
            if (ScrollBarUI.this.decreaseButton != null) {
                ScrollBarUI.this.decreaseButton.setFreeStanding(ScrollBarUI.this.isFreeStanding);
            }
        }

        protected void toFlush() {
            ScrollBarUI.this.scrollBarWidth -= 2;
        }

        protected void toFreeStanding() {
            ScrollBarUI.this.scrollBarWidth += 2;
        }
    }
}

