/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AttributeValue;

public final class JobAttributes
implements Cloneable {
    private int copies;
    private DefaultSelectionType selection;
    private DestinationType destination;
    private DialogType dialog;
    private String filename;
    private int maxPage;
    private int minPage;
    private MultipleDocumentHandlingType multiple;
    private int[][] pageRanges;
    private int fromPage;
    private int toPage;
    private String printer;
    private SidesType sides;

    public final Object clone() {
        return new JobAttributes(this);
    }

    public final void set(JobAttributes attr) {
        this.copies = attr.copies;
        this.selection = attr.selection;
        this.destination = attr.destination;
        this.dialog = attr.dialog;
        this.filename = attr.filename;
        this.maxPage = attr.maxPage;
        this.minPage = attr.minPage;
        this.multiple = attr.multiple;
        this.pageRanges = (int[][])attr.pageRanges.clone();
        this.printer = attr.printer;
        this.sides = attr.sides;
        this.fromPage = attr.fromPage;
        this.toPage = attr.toPage;
    }

    public final int getCopies() {
        return this.copies;
    }

    public final void setCopies(int copies) {
        if (copies <= 0) {
            throw new IllegalArgumentException();
        }
        this.copies = copies;
    }

    public final void setCopiesToDefault() {
        this.copies = 1;
    }

    public final DefaultSelectionType getDefaultSelection() {
        return this.selection;
    }

    public final void setDefaultSelection(DefaultSelectionType selection) {
        if (selection == null) {
            throw new IllegalArgumentException();
        }
        this.selection = selection;
    }

    public final DestinationType getDestination() {
        return this.destination;
    }

    public final void setDestination(DestinationType destination) {
        if (destination == null) {
            throw new IllegalArgumentException();
        }
        this.destination = destination;
    }

    public final DialogType getDialog() {
        return this.dialog;
    }

    public final void setDialog(DialogType dialog) {
        if (dialog == null) {
            throw new IllegalArgumentException();
        }
        this.dialog = dialog;
    }

    public final String getFileName() {
        return this.filename;
    }

    public final void setFileName(String filename) {
        this.filename = filename;
    }

    public final int getFromPage() {
        return this.fromPage != 0 ? this.fromPage : (this.pageRanges != null ? this.pageRanges[0][0] : (this.toPage != 0 ? this.toPage : this.minPage));
    }

    public final void setFromPage(int fromPage) {
        if (fromPage < this.minPage || fromPage > this.toPage && this.toPage != 0 || fromPage > this.maxPage) {
            throw new IllegalArgumentException();
        }
        if (this.pageRanges == null) {
            this.fromPage = fromPage;
        }
    }

    public final int getMaxPage() {
        return this.maxPage;
    }

    public final void setMaxPage(int maxPage) {
        if (maxPage < this.minPage) {
            throw new IllegalArgumentException();
        }
        this.maxPage = maxPage;
        if (maxPage < this.fromPage) {
            this.fromPage = maxPage;
        }
        if (maxPage < this.toPage) {
            this.toPage = maxPage;
        }
        if (this.pageRanges != null) {
            int i = this.pageRanges.length - 1;
            while (i >= 0 && maxPage < this.pageRanges[i][1]) {
                --i;
            }
            if (maxPage >= this.pageRanges[++i][0]) {
                this.pageRanges[i++][1] = maxPage;
            }
            if (i == 0) {
                this.pageRanges = null;
            } else if (i < this.pageRanges.length) {
                int[][] tmp = new int[i][];
                System.arraycopy(this.pageRanges, 0, tmp, 0, i);
                this.pageRanges = tmp;
            }
        }
    }

    public final int getMinPage() {
        return this.minPage;
    }

    public final void setMinPage(int minPage) {
        if (minPage <= 0 || minPage > this.maxPage) {
            throw new IllegalArgumentException();
        }
        this.minPage = minPage;
        if (minPage > this.toPage) {
            this.toPage = minPage;
        }
        if (minPage > this.fromPage) {
            this.fromPage = minPage;
        }
        if (this.pageRanges != null) {
            int size = this.pageRanges.length;
            int i = 0;
            while (i < size && minPage > this.pageRanges[i][0]) {
                ++i;
            }
            if (minPage <= this.pageRanges[i - 1][1]) {
                this.pageRanges[--i][0] = minPage;
            }
            if (i == size) {
                this.pageRanges = null;
            } else if (i > 0) {
                int[][] tmp = new int[size - i][];
                System.arraycopy(this.pageRanges, i, tmp, 0, size - i);
                this.pageRanges = tmp;
            }
        }
    }

    public final MultipleDocumentHandlingType getMultipleDocumentHandling() {
        return this.multiple;
    }

    public final void setMultipleDocumentHandling(MultipleDocumentHandlingType multiple) {
        if (multiple == null) {
            throw new IllegalArgumentException();
        }
        this.multiple = multiple;
    }

    public final void setMultipleDocumentHandlingToDefault() {
        this.multiple = MultipleDocumentHandlingType.SEPARATE_DOCUMENTS_UNCOLLATED_COPIES;
    }

    public final int[][] getPageRanges() {
        if (this.pageRanges == null) {
            return new int[][]{{this.getFromPage(), this.getToPage()}};
        }
        int i = this.pageRanges.length;
        int[][] result = new int[i][];
        while (--i >= 0) {
            result[i] = (int[])this.pageRanges[i].clone();
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public final void setPageRanges(int[][] pageRanges) {
        v0 = 0;
        if (pageRanges != null) {
            v0 = pageRanges.length;
        }
        if ((size = v0) != 0) ** GOTO lbl9
        throw new IllegalArgumentException();
lbl-1000:
        // 1 sources

        {
            range = pageRanges[size];
            if (range != null && range.length == 2 && range[0] >= this.minPage && range[1] >= range[0] && range[1] <= this.maxPage && (size == 0 || range[0] > pageRanges[size - 1][1])) continue;
            throw new IllegalArgumentException();
lbl9:
            // 2 sources

            ** while (--size >= 0)
        }
lbl10:
        // 1 sources

        size = pageRanges.length;
        if (this.fromPage > 0 && pageRanges[0][0] > this.fromPage) {
            this.fromPage = pageRanges[0][0];
        }
        if (this.toPage > 0 && pageRanges[size - 1][1] < this.toPage) {
            this.toPage = pageRanges[size - 1][1];
        }
        this.pageRanges = new int[size][];
        while (--size >= 0) {
            this.pageRanges[size] = (int[])pageRanges[size].clone();
        }
    }

    public final String getPrinter() {
        return this.printer;
    }

    public final void setPrinter(String printer) {
        this.printer = printer;
    }

    public final SidesType getSides() {
        return this.sides;
    }

    public final void setSides(SidesType sides) {
        if (sides == null) {
            throw new IllegalArgumentException();
        }
        this.sides = sides;
    }

    public final void setSidesToDefault() {
        this.sides = SidesType.ONE_SIDED;
    }

    public final int getToPage() {
        return this.toPage != 0 ? this.toPage : (this.pageRanges != null ? this.pageRanges[this.pageRanges.length - 1][1] : (this.fromPage != 0 ? this.fromPage : this.maxPage));
    }

    public final void setToPage(int toPage) {
        if (toPage < this.minPage || this.fromPage > toPage && this.fromPage != 0 || toPage > this.maxPage) {
            throw new IllegalArgumentException();
        }
        if (this.pageRanges == null) {
            this.toPage = toPage;
        }
    }

    public final boolean equals(Object o) {
        JobAttributes ja;
        block10: {
            block9: {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof JobAttributes)) {
                    return false;
                }
                ja = (JobAttributes)o;
                if (this.copies != ja.copies || this.selection != ja.selection || this.destination != ja.destination || this.dialog != ja.dialog || !this.filename.equals(ja.filename) || this.maxPage != ja.maxPage || this.minPage != ja.minPage || this.multiple != ja.multiple || this.fromPage != ja.fromPage || this.toPage != ja.toPage || !this.printer.equals(ja.printer) || this.sides != ja.sides) break block9;
                boolean bl = false;
                if (this.pageRanges == null) {
                    bl = true;
                }
                boolean bl2 = false;
                if (ja.pageRanges == null) {
                    bl2 = true;
                }
                if (bl == bl2) break block10;
            }
            return false;
        }
        if (this.pageRanges != ja.pageRanges) {
            int i = this.pageRanges.length;
            while (--i >= 0) {
                if (this.pageRanges[i][0] == ja.pageRanges[i][0] && this.pageRanges[i][1] == ja.pageRanges[i][1]) continue;
                return false;
            }
        }
        return true;
    }

    public final int hashCode() {
        int n = this.selection.value << 6 ^ this.destination.value << 5 ^ this.dialog.value << 3 ^ this.multiple.value << 2 ^ this.sides.value;
        int n2 = 0;
        if (this.filename != null) {
            n2 = this.filename.hashCode();
        }
        int n3 = n ^ n2;
        int n4 = 0;
        if (this.printer != null) {
            n4 = this.printer.hashCode();
        }
        int hash = n3 ^ n4;
        hash ^= this.copies << 27 ^ this.maxPage << 22 ^ this.minPage << 17;
        if (this.pageRanges == null) {
            hash ^= this.getFromPage() << 13 ^ this.getToPage() << 8;
        } else {
            int i = this.pageRanges.length;
            while (--i >= 0) {
                hash ^= this.pageRanges[i][0] << 13 ^ this.pageRanges[i][1] << 8;
            }
        }
        return hash;
    }

    public final String toString() {
        StringBuffer s = new StringBuffer("copies=").append(this.copies).append(",defaultSelection=").append(this.selection).append(",destination=").append(this.destination).append(",dialog=").append(this.dialog).append(",fileName=").append(this.filename).append(",fromPage=").append(this.getFromPage()).append(",maxPage=").append(this.maxPage).append(",minPage=").append(this.minPage).append(",multiple-document-handling=").append(this.multiple).append(",page-ranges=[");
        if (this.pageRanges == null) {
            s.append(this.minPage).append(':').append(this.minPage).append(']');
        } else {
            int i = 0;
            while (i < this.pageRanges.length) {
                s.append(this.pageRanges[i][0]).append(':').append(this.pageRanges[i][1]).append(',');
                ++i;
            }
        }
        s.setLength(s.length() - 1);
        return s.append("],printer=").append(this.printer).append(",sides=").append(this.sides).append(",toPage=").append(this.getToPage()).toString();
    }

    public JobAttributes() {
        this.copies = 1;
        this.selection = DefaultSelectionType.ALL;
        this.destination = DestinationType.PRINTER;
        this.dialog = DialogType.NATIVE;
        this.maxPage = Integer.MAX_VALUE;
        this.minPage = 1;
        this.multiple = MultipleDocumentHandlingType.SEPARATE_DOCUMENTS_UNCOLLATED_COPIES;
        this.sides = SidesType.ONE_SIDED;
    }

    public JobAttributes(JobAttributes attr) {
        this.set(attr);
    }

    public JobAttributes(int copies, DefaultSelectionType selection, DestinationType destination, DialogType dialog, String filename, int max, int min, MultipleDocumentHandlingType multiple, int[][] pageRanges, String printer, SidesType sides) {
        if (copies <= 0 || selection == null || destination == null || dialog == null || max < min || min <= 0 || multiple == null || sides == null) {
            throw new IllegalArgumentException();
        }
        this.copies = copies;
        this.selection = selection;
        this.destination = destination;
        this.dialog = dialog;
        this.filename = filename;
        this.maxPage = max;
        this.minPage = min;
        this.multiple = multiple;
        this.setPageRanges(pageRanges);
        this.printer = printer;
        this.sides = sides;
    }

    public static final class MultipleDocumentHandlingType
    extends AttributeValue {
        private static final String[] NAMES = new String[]{"separate-documents-collated-copies", "separate-documents-uncollated-copies"};
        public static final MultipleDocumentHandlingType SEPARATE_DOCUMENTS_COLLATED_COPIES = new MultipleDocumentHandlingType(0);
        public static final MultipleDocumentHandlingType SEPARATE_DOCUMENTS_UNCOLLATED_COPIES = new MultipleDocumentHandlingType(1);

        private MultipleDocumentHandlingType(int value) {
            super(value, NAMES);
        }
    }

    public static final class SidesType
    extends AttributeValue {
        private static final String[] NAMES = new String[]{"one-sided", "two-sided-long-edge", "two-sided-short-edge"};
        public static final SidesType ONE_SIDED = new SidesType(0);
        public static final SidesType TWO_SIDED_LONG_EDGE = new SidesType(1);
        public static final SidesType TWO_SIDED_SHORT_EDGE = new SidesType(2);

        private SidesType(int value) {
            super(value, NAMES);
        }
    }

    public static final class DefaultSelectionType
    extends AttributeValue {
        private static final String[] NAMES = new String[]{"all", "range", "selection"};
        public static final DefaultSelectionType ALL = new DefaultSelectionType(0);
        public static final DefaultSelectionType RANGE = new DefaultSelectionType(1);
        public static final DefaultSelectionType SELECTION = new DefaultSelectionType(2);

        private DefaultSelectionType(int value) {
            super(value, NAMES);
        }
    }

    public static final class DestinationType
    extends AttributeValue {
        private static final String[] NAMES = new String[]{"file", "printer"};
        public static final DestinationType FILE = new DestinationType(0);
        public static final DestinationType PRINTER = new DestinationType(1);

        private DestinationType(int value) {
            super(value, NAMES);
        }
    }

    public static final class DialogType
    extends AttributeValue {
        private static final String[] NAMES = new String[]{"common", "native", "none"};
        public static final DialogType COMMON = new DialogType(0);
        public static final DialogType NATIVE = new DialogType(1);
        public static final DialogType NONE = new DialogType(2);

        private DialogType(int value) {
            super(value, NAMES);
        }
    }
}

