/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.beans.decoder;

import gnu.java.beans.decoder.AbstractElementHandler;
import gnu.java.beans.decoder.AssemblyException;
import gnu.java.beans.decoder.ConstructorContext;
import gnu.java.beans.decoder.Context;
import gnu.java.beans.decoder.ElementHandler;
import gnu.java.beans.decoder.IndexContext;
import gnu.java.beans.decoder.MethodContext;
import gnu.java.beans.decoder.PropertyContext;
import gnu.java.beans.decoder.StaticMethodContext;
import java.beans.ExceptionListener;
import org.xml.sax.Attributes;

public class VoidHandler
extends AbstractElementHandler {
    protected Context startElement(Attributes attributes, ExceptionListener exceptionListener) throws AssemblyException {
        Context ctx = this.startElementImpl(attributes);
        ctx.setStatement(true);
        return ctx;
    }

    private final Context startElementImpl(Attributes attributes) throws AssemblyException {
        String id = attributes.getValue("id");
        String className = attributes.getValue("class");
        String methodName = attributes.getValue("method");
        String propertyName = attributes.getValue("property");
        String index = attributes.getValue("index");
        if (className != null) {
            try {
                Class klass = this.instantiateClass(className);
                if (methodName == null || methodName.equals("new")) {
                    return new ConstructorContext(id, klass);
                }
                return new StaticMethodContext(id, klass, methodName);
            }
            catch (ClassNotFoundException cnfe) {
                throw new AssemblyException(cnfe);
            }
        }
        if (index != null) {
            try {
                return new IndexContext(id, Integer.parseInt(index));
            }
            catch (NumberFormatException nfe) {
                throw new AssemblyException(nfe);
            }
        }
        if (methodName != null) {
            return new MethodContext(id, methodName);
        }
        if (propertyName != null && propertyName.length() > 0) {
            return new PropertyContext(id, propertyName);
        }
        throw new AssemblyException(new IllegalArgumentException(attributes.getValue("idref") == null ? "Missing attributes for <void> tag" : "<void> does not support 'idref' attribute."));
    }

    VoidHandler(ElementHandler parent) {
        super(parent, true);
    }
}

