/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.commons;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class Statistics {
    private static final String LOG_ARRAY_LENGTH_0 = "Length of array cannot be 0!";

    private Statistics() {
    }

    public static int mean(int[] list) throws IllegalArgumentException {
        if (list.length == 0) {
            throw new IllegalArgumentException(LOG_ARRAY_LENGTH_0);
        }
        int sum = 0;
        for (int n : list) {
            sum += n;
        }
        return sum / list.length;
    }

    public static long mean(long[] list) throws IllegalArgumentException {
        if (list.length == 0) {
            throw new IllegalArgumentException(LOG_ARRAY_LENGTH_0);
        }
        long sum = 0L;
        for (long n : list) {
            sum += n;
        }
        return sum / (long)list.length;
    }

    public static float mean(float[] list) throws IllegalArgumentException {
        if (list.length == 0) {
            throw new IllegalArgumentException(LOG_ARRAY_LENGTH_0);
        }
        float sum = 0.0f;
        for (float n : list) {
            sum += n;
        }
        return sum / (float)list.length;
    }

    public static double mean(double[] list) throws IllegalArgumentException {
        if (list.length == 0) {
            throw new IllegalArgumentException(LOG_ARRAY_LENGTH_0);
        }
        float sum = 0.0f;
        for (double n : list) {
            sum = (float)((double)sum + n);
        }
        return sum / (float)list.length;
    }

    public static int median(int[] list) throws IllegalArgumentException {
        if (list.length < 1) {
            throw new IllegalArgumentException();
        }
        Arrays.sort(list);
        if (list.length % 2 == 0) {
            int idx = list.length / 2;
            return (list[idx] + list[idx - 1]) / 2;
        }
        int idx = list.length / 2;
        return list[idx];
    }

    public static int[] mode(int[] list) throws IllegalArgumentException {
        if (list.length == 0) {
            throw new IllegalArgumentException(LOG_ARRAY_LENGTH_0);
        }
        ModeCompute<Integer> modeComp = new ModeCompute<Integer>();
        for (int i = 0; i < list.length; ++i) {
            modeComp.add(list[i]);
        }
        List l = modeComp.getMode();
        int[] out = new int[l.size()];
        Iterator itr = l.iterator();
        for (int i = 0; i < out.length; ++i) {
            out[i] = (Integer)itr.next();
        }
        return out;
    }

    private static class ModeCompute<T extends Number> {
        private Map<T, Integer> map = new HashMap<T, Integer>();
        private int maxFrequency = 0;

        private ModeCompute() {
        }

        void add(T t) {
            int count = this.map.get(t) == null ? 1 : this.map.get(t) + 1;
            this.map.put(t, count);
            if (count > this.maxFrequency) {
                this.maxFrequency = count;
            }
        }

        List<T> getMode() {
            ArrayList<T> out = new ArrayList<T>();
            for (Map.Entry<T, Integer> entry : this.map.entrySet()) {
                if (entry.getValue() != this.maxFrequency) continue;
                out.add(entry.getKey());
            }
            return out;
        }
    }
}

