/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization.r.inlays.dataframe.columns;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.dataframe.columns.Column;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.dataframe.columns.IntType;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.dataframe.columns.Type;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010(\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0006j\b\u0012\u0004\u0012\u00020\u0002`\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0017j\b\u0012\u0004\u0012\u00020\u0002`\u00182\u0006\u0010\u0019\u001a\u00020\nH\u0016J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u0002H\u0016J\u0010\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u0002H\u0016J\u0010\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u0002H\u0016J\u000f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u001fH\u0096\u0002R\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u000bR\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006 "}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/dataframe/columns/IntColumn;", "Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/dataframe/columns/Column;", "", "name", "", "data", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "(Ljava/lang/String;Ljava/util/ArrayList;)V", "isNumerical", "", "()Z", "lazyRange", "Lkotlin/ranges/ClosedRange;", "", "range", "getRange", "()Lkotlin/ranges/ClosedRange;", "type", "Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/dataframe/columns/Type;", "getType", "()Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/dataframe/columns/Type;", "getComparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "descendant", "getDouble", "index", "isNotNull", "isNull", "iterator", "", "intellij.notebooks.visualization"})
public final class IntColumn
extends Column<Integer> {
    private final boolean isNumerical;
    @Nullable
    private ClosedRange<Double> lazyRange;

    public IntColumn(@NotNull String name, @NotNull ArrayList<Integer> data) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        super(name, data);
        this.isNumerical = true;
    }

    @Override
    @NotNull
    public Type<Integer> getType() {
        return IntType.INSTANCE;
    }

    @Override
    public boolean isNumerical() {
        return this.isNumerical;
    }

    @Override
    public boolean isNotNull(int index) {
        Integer n = (Integer)this.getData().get(index);
        int n2 = Integer.MIN_VALUE;
        return n == null || n != n2;
    }

    @Override
    public boolean isNull(int index) {
        Integer n = (Integer)this.getData().get(index);
        int n2 = Integer.MIN_VALUE;
        return n != null && n == n2;
    }

    @Override
    public double getDouble(int index) {
        return ((Number)this.getData().get(index)).intValue();
    }

    @Override
    @NotNull
    public Comparator<Integer> getComparator(boolean descendant) {
        return descendant ? (arg_0, arg_1) -> IntColumn.getComparator$lambda$0(this, arg_0, arg_1) : (arg_0, arg_1) -> IntColumn.getComparator$lambda$1(this, arg_0, arg_1);
    }

    @Override
    @NotNull
    public ClosedRange<Double> getRange() {
        if (this.lazyRange != null) {
            ClosedRange<Double> closedRange = this.lazyRange;
            Intrinsics.checkNotNull(closedRange);
            return closedRange;
        }
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        int n = this.getData().size();
        for (int i = 0; i < n; ++i) {
            Integer n2 = (Integer)this.getData().get(i);
            int n3 = Integer.MIN_VALUE;
            if (n2 != null && n2 == n3) continue;
            Object t = this.getData().get(i);
            Intrinsics.checkNotNullExpressionValue(t, (String)"data[i]");
            if (min > ((Number)t).intValue()) {
                Object t2 = this.getData().get(i);
                Intrinsics.checkNotNullExpressionValue(t2, (String)"data[i]");
                min = ((Number)t2).intValue();
            }
            Object t3 = this.getData().get(i);
            Intrinsics.checkNotNullExpressionValue(t3, (String)"data[i]");
            if (max >= ((Number)t3).intValue()) continue;
            Object t4 = this.getData().get(i);
            Intrinsics.checkNotNullExpressionValue(t4, (String)"data[i]");
            max = ((Number)t4).intValue();
        }
        this.lazyRange = (ClosedRange)RangesKt.rangeTo((double)min, (double)max);
        ClosedRange<Double> closedRange = this.lazyRange;
        Intrinsics.checkNotNull(closedRange);
        return closedRange;
    }

    @Override
    @NotNull
    public Iterator<Integer> iterator() {
        Iterator<Integer> iterator = this.getData().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"data.iterator()");
        return iterator;
    }

    private static final int getComparator$lambda$0(IntColumn this$0, Integer i1, Integer i2) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)i2, (String)"i2");
        int n = ((Number)this$0.get(i2)).intValue();
        Intrinsics.checkNotNullExpressionValue((Object)i1, (String)"i1");
        return Intrinsics.compare((int)n, (int)((Number)this$0.get(i1)).intValue());
    }

    private static final int getComparator$lambda$1(IntColumn this$0, Integer i1, Integer i2) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)i1, (String)"i1");
        int n = ((Number)this$0.get(i1)).intValue();
        Intrinsics.checkNotNullExpressionValue((Object)i2, (String)"i2");
        return Intrinsics.compare((int)n, (int)((Number)this$0.get(i2)).intValue());
    }
}

