/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization.r.inlays.components;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.SoftWrapChangeListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapPainter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.awt.Dimension;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.visualization.r.VisualizationBundle;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.InlayExecutorKt;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.components.ColoredTextConsole;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.components.EmptySoftWrapPainter;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.components.InlayOutput;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.components.InlayOutputKt;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.components.InlayOutputText;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.components.ProcessOutput;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00112\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015J\u0018\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0017\u001a\u00020\bH\u0016J\b\u0010\u0018\u001a\u00020\u0011H\u0016J\b\u0010\u0019\u001a\u00020\bH\u0016J\b\u0010\u001a\u001a\u00020\bH\u0016J\u0010\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u001cH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/components/InlayOutputText;", "Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/components/InlayOutput;", "parent", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/Editor;", "clearAction", "Lkotlin/Function0;", "", "(Lcom/intellij/openapi/Disposable;Lcom/intellij/openapi/editor/Editor;Lkotlin/jvm/functions/Function0;)V", "console", "Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/components/ColoredTextConsole;", "scrollPaneTopBorderHeight", "", "acceptType", "", "type", "", "addData", "message", "outputType", "Lcom/intellij/openapi/util/Key;", "data", "clear", "getCollapsedDescription", "saveAs", "scrollToTop", "updateSize", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "intellij.notebooks.visualization"})
public final class InlayOutputText
extends InlayOutput {
    @NotNull
    private final ColoredTextConsole console;
    private final int scrollPaneTopBorderHeight;

    public InlayOutputText(@NotNull Disposable parent, @NotNull Editor editor, @NotNull Function0<Unit> clearAction2) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(clearAction2, (String)"clearAction");
        super(parent, editor, clearAction2);
        this.console = new ColoredTextConsole(this.getProject(), true);
        this.scrollPaneTopBorderHeight = 5;
        Disposer.register((Disposable)parent, (Disposable)((Disposable)this.console));
        this.getToolbarPane().setDataComponent(this.console.getComponent());
        InlayOutputKt.initOutputTextConsole(editor, parent, this.console, this.scrollPaneTopBorderHeight);
        MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.console);
        Topic topic = EditorColorsManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, arg_0 -> InlayOutputText._init_$lambda$1(this, editor, arg_0));
    }

    @Override
    public void clear() {
        this.console.clear();
    }

    @Override
    public void addData(@NotNull String data, @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        InlayExecutorKt.runAsyncInlay((Function0)new Function0<Unit>(data, this){
            final /* synthetic */ String $data;
            final /* synthetic */ InlayOutputText this$0;
            {
                this.$data = $data;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                List list;
                Object object = new File(this.$data);
                File it = object;
                boolean bl = false;
                Object object2 = it.exists() && Intrinsics.areEqual((Object)FilesKt.getExtension((File)it), (Object)"json") ? object : null;
                if (object2 != null) {
                    File file = object2;
                    boolean bl2 = false;
                    list = (List)new Gson().fromJson(FilesKt.readText$default((File)file, null, (int)1, null), new TypeToken<List<? extends ProcessOutput>>(){}.getType());
                } else {
                    list = null;
                }
                List list2 = list;
                object = this.this$0;
                String string = this.$data;
                List outputs = list2;
                boolean bl3 = false;
                SwingUtilities.invokeLater(() -> addData.1.invoke$lambda$5$lambda$4(outputs, (InlayOutputText)object, string));
            }

            private static final void invoke$lambda$5$lambda$4(List $outputs, InlayOutputText this$0, String $data) {
                block3: {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    Intrinsics.checkNotNullParameter((Object)$data, (String)"$data");
                    if ($outputs == null) {
                        ColoredTextConsole coloredTextConsole = InlayOutputText.access$getConsole$p(this$0);
                        char[] cArray = new char[]{'\n'};
                        String string = StringsKt.trimEnd((String)StringsKt.replace$default((String)$data, (String)"\r\n", (String)"\n", (boolean)false, (int)4, null), (char[])cArray);
                        ProcessOutputType processOutputType = ProcessOutputType.STDOUT;
                        Intrinsics.checkNotNullExpressionValue((Object)processOutputType, (String)"STDOUT");
                        coloredTextConsole.addData(string, (Key)processOutputType);
                    } else {
                        Iterable $this$forEach$iv = $outputs;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            ProcessOutput it = (ProcessOutput)element$iv;
                            boolean bl = false;
                            InlayOutputText.access$getConsole$p(this$0).addData(it.getText(), it.getKind());
                        }
                    }
                    InlayOutputText.access$getConsole$p(this$0).flushDeferredText();
                    Editor editor = InlayOutputText.access$getConsole$p(this$0).getEditor();
                    EditorImpl editorImpl = editor instanceof EditorImpl ? (EditorImpl)editor : null;
                    if (editorImpl == null) break block3;
                    Editor $this$invoke_u24lambda_u245_u24lambda_u244_u24lambda_u243 = editor = editorImpl;
                    boolean bl = false;
                    InlayOutputText.access$updateSize(this$0, (EditorImpl)$this$invoke_u24lambda_u245_u24lambda_u244_u24lambda_u243);
                    $this$invoke_u24lambda_u245_u24lambda_u244_u24lambda_u243.getSoftWrapModel().setSoftWrapPainter((SoftWrapPainter)EmptySoftWrapPainter.INSTANCE);
                    $this$invoke_u24lambda_u245_u24lambda_u244_u24lambda_u243.getSoftWrapModel().addSoftWrapChangeListener(new SoftWrapChangeListener(this$0, (EditorImpl)$this$invoke_u24lambda_u245_u24lambda_u244_u24lambda_u243){
                        final /* synthetic */ InlayOutputText this$0;
                        final /* synthetic */ EditorImpl $this_apply;
                        {
                            this.this$0 = $receiver;
                            this.$this_apply = $receiver2;
                        }

                        public void recalculationEnds() {
                            InlayOutputText.access$updateSize(this.this$0, this.$this_apply);
                        }

                        public void softWrapsChanged() {
                        }
                    });
                }
            }
        });
    }

    private final void updateSize(EditorImpl editor) {
        block0: {
            EditorImpl $this$updateSize_u24lambda_u242 = editor;
            boolean bl = false;
            int textHeight = $this$updateSize_u24lambda_u242.offsetToXY((int)$this$updateSize_u24lambda_u242.getDocument().getTextLength()).y + $this$updateSize_u24lambda_u242.getLineHeight() + this.scrollPaneTopBorderHeight;
            $this$updateSize_u24lambda_u242.getComponent().setPreferredSize(new Dimension($this$updateSize_u24lambda_u242.getPreferredSize().width, textHeight));
            Function1<Integer, Unit> function1 = this.getOnHeightCalculated();
            if (function1 == null) break block0;
            function1.invoke((Object)Math.max(textHeight, this.getToolbarPane().getPreferredSize().height));
        }
    }

    public final void addData(@NotNull String message, @NotNull Key<?> outputType) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
        this.console.addData(message, outputType);
    }

    @Override
    public void scrollToTop() {
        this.console.scrollTo(0);
    }

    @Override
    @NotNull
    public String getCollapsedDescription() {
        String string = this.console.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"console.text");
        String string2 = string;
        int n = 0;
        int n2 = Math.min(this.console.getText().length(), 60);
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string3 + " .....";
    }

    @Override
    public boolean acceptType(@NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return Intrinsics.areEqual((Object)type, (Object)"TEXT");
    }

    @Override
    public void saveAs() {
        String title = VisualizationBundle.INSTANCE.message("inlay.action.export.as.txt.title", new Object[0]);
        String description = VisualizationBundle.INSTANCE.message("inlay.action.export.as.txt.description", new Object[0]);
        String[] stringArray = new String[]{"txt"};
        this.saveWithFileChooser(title, description, stringArray, "output", (Function1<? super File, Unit>)((Function1)new Function1<File, Unit>(this){
            final /* synthetic */ InlayOutputText this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(@NotNull File destination) {
                Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
                Object object = destination;
                Object object2 = Charsets.UTF_8;
                int n = 8192;
                Object object3 = object;
                object3 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object3), (Charset)object2);
                object = object3 instanceof BufferedWriter ? (BufferedWriter)object3 : new BufferedWriter((Writer)object3, n);
                object2 = this.this$0;
                Throwable throwable = null;
                try {
                    BufferedWriter out = (BufferedWriter)object;
                    boolean bl = false;
                    out.write(InlayOutputText.access$getConsole$p((InlayOutputText)object2).getText());
                    object3 = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
        }));
    }

    private static final void _init_$lambda$1(InlayOutputText this$0, Editor $editor, EditorColorsScheme it) {
        EditorEx editorEx;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        Editor editor = this$0.console.getEditor();
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        EditorEx $this$lambda_u241_u24lambda_u240 = editorEx = (EditorEx)editor;
        boolean bl = false;
        InlayOutputKt.updateOutputTextConsoleUI(this$0.console, $editor);
        $this$lambda_u241_u24lambda_u240.getComponent().repaint();
    }

    public static final /* synthetic */ ColoredTextConsole access$getConsole$p(InlayOutputText $this) {
        return $this.console;
    }

    public static final /* synthetic */ void access$updateSize(InlayOutputText $this, EditorImpl editor) {
        $this.updateSize(editor);
    }
}

