/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization.r.inlays.components;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.BinaryLightVirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.JreHiDpiUtil;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import java.util.Base64;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.images.editor.ImageEditor;
import org.intellij.images.editor.ImageZoomModel;
import org.intellij.images.ui.ImageComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.plugins.notebooks.visualization.r.VisualizationBundle;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.components.DarkModeNotifier;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.components.EmptyComponentPanel;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.components.GraphicsManager;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.components.GraphicsPanelKt;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.components.ImageInverter;
import org.jetbrains.plugins.notebooks.visualization.r.ui.UiCustomizer;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0017\u0018\u0000 d2\u00020\u0001:\u0001dB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020BH\u0002J\u0012\u0010C\u001a\u00020@2\b\b\u0001\u0010D\u001a\u00020EH\u0002J*\u0010F\u001a\u00020\u000e2\b\b\u0001\u0010D\u001a\u00020E2\b\b\u0001\u0010G\u001a\u00020E2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020@0IH\u0002J\u0018\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020K2\u0006\u0010M\u001a\u00020NH\u0002J\b\u0010O\u001a\u00020/H\u0002J\u0010\u0010P\u001a\u00020@2\u0006\u0010Q\u001a\u00020\u0016H\u0002J\u0010\u0010R\u001a\u00020K2\u0006\u0010S\u001a\u00020\u0014H\u0002J\u0010\u0010T\u001a\u00020@2\u0006\u0010U\u001a\u00020\u0012H\u0002J\u0012\u0010V\u001a\u00020@2\n\b\u0003\u0010D\u001a\u0004\u0018\u00010EJ\u000e\u0010W\u001a\u00020@2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010X\u001a\u00020@2\u0006\u0010S\u001a\u00020\u0014J\u0010\u0010Y\u001a\u00020@2\u0006\u0010S\u001a\u00020\u0014H\u0002J\u000e\u0010Z\u001a\u00020@2\u0006\u0010[\u001a\u00020EJ\u0012\u0010\\\u001a\u00020@2\n\b\u0003\u0010D\u001a\u0004\u0018\u00010EJ\u0010\u0010]\u001a\u00020@2\b\b\u0001\u0010D\u001a\u00020EJ(\u0010^\u001a\u00020@2\b\b\u0001\u0010D\u001a\u00020E2\b\b\u0001\u0010G\u001a\u00020E2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020@0IJ\u000e\u0010_\u001a\u00020@2\u0006\u0010[\u001a\u00020EJ\u0018\u0010`\u001a\u00020K2\u0006\u0010L\u001a\u00020K2\u0006\u0010M\u001a\u00020NH\u0002J\u0010\u0010a\u001a\u00020\u00182\u0006\u0010S\u001a\u00020\u0014H\u0002J\u0016\u0010b\u001a\u00020@2\f\u0010c\u001a\b\u0012\u0004\u0012\u00020@0IH\u0002R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\u0004\u0018\u00010\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0013\u0010#\u001a\u0004\u0018\u00010 8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\"R\u0016\u0010%\u001a\u0004\u0018\u00010\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\nR$\u0010(\u001a\u00020\u00182\u0006\u0010'\u001a\u00020\u0018@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u00102\u001a\u0004\u0018\u00010 8F\u00a2\u0006\u0006\u001a\u0004\b3\u0010\"R\u001c\u00104\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010\n\"\u0004\b6\u00107R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u000209X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010:\u001a\u00020/8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010<R\u0018\u0010=\u001a\u00020\u0018*\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b=\u0010>\u00a8\u0006e"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/components/GraphicsPanel;", "", "project", "Lcom/intellij/openapi/project/Project;", "disposableParent", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "advancedModeComponent", "Ljavax/swing/JComponent;", "getAdvancedModeComponent", "()Ljavax/swing/JComponent;", "basicModeComponent", "getBasicModeComponent", "component", "Ljavax/swing/JPanel;", "getComponent", "()Ljavax/swing/JPanel;", "currentEditor", "Lorg/intellij/images/editor/ImageEditor;", "currentFile", "Ljava/io/File;", "currentImageFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "darkMode", "", "graphicsManager", "Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/components/GraphicsManager;", "image", "Ljava/awt/image/BufferedImage;", "getImage", "()Ljava/awt/image/BufferedImage;", "imageComponentSize", "Ljava/awt/Dimension;", "getImageComponentSize", "()Ljava/awt/Dimension;", "imageSize", "getImageSize", "internalComponent", "getInternalComponent", "mode", "isAdvancedMode", "()Z", "setAdvancedMode", "(Z)V", "label", "Ljavax/swing/JLabel;", "lastToolPanelHeight", "", "loadingPanel", "Lcom/intellij/ui/components/JBLoadingPanel;", "maximumSize", "getMaximumSize", "overlayComponent", "getOverlayComponent", "setOverlayComponent", "(Ljavax/swing/JComponent;)V", "rootPanel", "Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/components/EmptyComponentPanel;", "toolPanelHeight", "getToolPanelHeight", "()I", "isInvertible", "(Ljava/io/File;)Z", "adjustImageZoom", "", "zoomModel", "Lorg/intellij/images/editor/ImageZoomModel;", "closeEditor", "message", "", "createInfoPanelWithLink", "linkText", "linkAction", "Lkotlin/Function0;", "createInvertedImage", "", "content", "globalScheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "getAdvancedModeToolPanelHeight", "openEditor", "file", "readImageContent", "imageFile", "removeImageInfoLabelAndActionToolBar", "editor", "reset", "showBufferedImage", "showImage", "showImageAsync", "showImageBase64", "data", "showLoadingMessage", "showMessage", "showMessageWithLink", "showSvgImage", "tryCreateInvertedImage", "tryShowImage", "withOverlayComponentPreserved", "task", "Companion", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nGraphicsPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphicsPanel.kt\norg/jetbrains/plugins/notebooks/visualization/r/inlays/components/GraphicsPanel\n+ 2 promise.kt\norg/jetbrains/concurrency/Promises__PromiseKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,349:1\n210#2,12:350\n1#3:362\n*S KotlinDebug\n*F\n+ 1 GraphicsPanel.kt\norg/jetbrains/plugins/notebooks/visualization/r/inlays/components/GraphicsPanel\n*L\n135#1:350,12\n*E\n"})
public final class GraphicsPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Disposable disposableParent;
    @Nullable
    private final GraphicsManager graphicsManager;
    @NotNull
    private final JLabel label;
    @NotNull
    private final EmptyComponentPanel rootPanel;
    @NotNull
    private final JBLoadingPanel loadingPanel;
    @Nullable
    private volatile File currentFile;
    @Nullable
    private VirtualFile currentImageFile;
    @Nullable
    private ImageEditor currentEditor;
    private int lastToolPanelHeight;
    @NotNull
    private final JPanel component;
    private boolean isAdvancedMode;
    @Nullable
    private volatile JComponent overlayComponent;
    private volatile boolean darkMode;
    @NotNull
    private static final Logger LOGGER;
    private static final boolean isHiDpi;
    private static final int scaleMultiplier;
    private static final int imageInsets = 2;

    /*
     * WARNING - void declaration
     */
    public GraphicsPanel(@NotNull Project project, @NotNull Disposable disposableParent) {
        void $this$loadingPanel_u24lambda_u240;
        JBLoadingPanel jBLoadingPanel;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)disposableParent, (String)"disposableParent");
        this.project = project;
        this.disposableParent = disposableParent;
        this.graphicsManager = GraphicsManager.Companion.getInstance(this.project);
        this.label = new JLabel(VisualizationBundle.INSTANCE.message("graphics.not.available", new Object[0]), 0);
        this.rootPanel = new EmptyComponentPanel(this.label);
        JBLoadingPanel jBLoadingPanel2 = jBLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), this.disposableParent, 0, 4, null);
        GraphicsPanel graphicsPanel = this;
        boolean bl = false;
        $this$loadingPanel_u24lambda_u240.startLoading();
        graphicsPanel.loadingPanel = jBLoadingPanel;
        this.component = this.rootPanel.getComponent();
        GraphicsManager graphicsManager = this.graphicsManager;
        this.darkMode = graphicsManager != null ? graphicsManager.isDarkModeEnabled() : true;
        MessageBusConnection connect = this.project.getMessageBus().connect(this.disposableParent);
        Topic topic = EditorColorsManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connect.subscribe(topic, arg_0 -> GraphicsPanel._init_$lambda$5(this, arg_0));
        connect.subscribe(GraphicsPanelKt.getCHANGE_DARK_MODE_TOPIC(), (Object)new DarkModeNotifier(){

            @Override
            public void onDarkModeChanged(boolean isEnabled) {
                block1: {
                    if (darkMode == isEnabled) break block1;
                    darkMode = isEnabled;
                    File file = currentFile;
                    if (file != null) {
                        File file2 = file;
                        GraphicsPanel graphicsPanel = this;
                        File it = file2;
                        boolean bl = false;
                        graphicsPanel.showImageAsync(it);
                    }
                }
            }
        });
    }

    private final JComponent getAdvancedModeComponent() {
        ImageEditor imageEditor = this.currentEditor;
        return imageEditor != null ? imageEditor.getComponent() : null;
    }

    private final JComponent getBasicModeComponent() {
        ImageEditor imageEditor = this.currentEditor;
        return UIUtil.findComponentOfType((JComponent)(imageEditor != null ? imageEditor.getContentComponent() : null), ImageComponent.class);
    }

    private final JComponent getInternalComponent() {
        return this.isAdvancedMode ? this.getAdvancedModeComponent() : this.getBasicModeComponent();
    }

    private final int getToolPanelHeight() {
        return this.isAdvancedMode ? this.getAdvancedModeToolPanelHeight() : 0;
    }

    @NotNull
    public final JPanel getComponent() {
        return this.component;
    }

    @Nullable
    public final BufferedImage getImage() {
        ImageEditor imageEditor = this.currentEditor;
        return imageEditor != null && (imageEditor = imageEditor.getDocument()) != null ? imageEditor.getValue() : null;
    }

    @Nullable
    public final Dimension getImageSize() {
        Dimension dimension;
        BufferedImage bufferedImage = this.getImage();
        if (bufferedImage != null) {
            BufferedImage image = bufferedImage;
            boolean bl = false;
            dimension = new Dimension(image.getWidth() / scaleMultiplier, image.getHeight() / scaleMultiplier);
        } else {
            dimension = null;
        }
        return dimension;
    }

    @NotNull
    public final Dimension getImageComponentSize() {
        Dimension dimension = this.component.getSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"component.size");
        return Companion.calculateImageSizeForRegion(dimension, this.getToolPanelHeight());
    }

    @Nullable
    public final Dimension getMaximumSize() {
        Dimension dimension = this.getImageSize();
        if (dimension != null) {
            Dimension size = dimension;
            boolean bl = false;
            int insets = 2;
            return new Dimension(size.width + insets * 2, size.height + this.getToolPanelHeight() + insets * 2);
        }
        return null;
    }

    public final boolean isAdvancedMode() {
        return this.isAdvancedMode;
    }

    public final void setAdvancedMode(boolean mode) {
        block1: {
            if (this.isAdvancedMode == mode) break block1;
            this.isAdvancedMode = mode;
            VirtualFile virtualFile = this.currentImageFile;
            if (virtualFile != null) {
                VirtualFile file = virtualFile;
                boolean bl = false;
                this.openEditor(file);
            }
        }
    }

    @Nullable
    public final JComponent getOverlayComponent() {
        return this.overlayComponent;
    }

    public final void setOverlayComponent(@Nullable JComponent jComponent) {
        this.overlayComponent = jComponent;
    }

    private final void showImageAsync(File imageFile) {
        boolean $i$f$runAsync = false;
        AsyncPromise promise$iv = new AsyncPromise();
        AppExecutorUtil.getAppExecutorService().execute(new Runnable(promise$iv, this, imageFile){
            final /* synthetic */ AsyncPromise $promise;
            final /* synthetic */ GraphicsPanel this$0;
            final /* synthetic */ File $imageFile$inlined;
            {
                this.$promise = $promise;
                this.this$0 = graphicsPanel;
                this.$imageFile$inlined = file;
            }

            public final void run() {
                Unit unit;
                try {
                    boolean bl = false;
                    this.this$0.showImage(this.$imageFile$inlined);
                    unit = Unit.INSTANCE;
                }
                catch (Throwable e) {
                    this.$promise.setError(e);
                    return;
                }
                Unit result = unit;
                this.$promise.setResult((Object)result);
            }
        });
        Promise cfr_ignored_0 = (Promise)promise$iv;
    }

    public final void showImage(@NotNull File imageFile) {
        Intrinsics.checkNotNullParameter((Object)imageFile, (String)"imageFile");
        if (!this.tryShowImage(imageFile)) {
            this.closeEditor(VisualizationBundle.INSTANCE.message("graphics.could.not.be.loaded", new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void showBufferedImage(@NotNull BufferedImage image) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ByteArrayOutputStream outputStream = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            ImageIO.write((RenderedImage)image, "png", outputStream);
            outputStream.flush();
            byArray = outputStream.toByteArray();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        byte[] content = byArray;
        ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<Unit>(this, content){
            final /* synthetic */ GraphicsPanel this$0;
            final /* synthetic */ byte[] $content;
            {
                this.this$0 = $receiver;
                this.$content = $content;
                super(0);
            }

            public final void invoke() {
                if (Disposer.isDisposed((Disposable)GraphicsPanel.access$getDisposableParent$p(this.this$0))) {
                    return;
                }
                GraphicsPanel.access$setCurrentFile$p(this.this$0, null);
                GraphicsPanel.access$openEditor(this.this$0, (VirtualFile)new BinaryLightVirtualFile("image.png", this.$content));
            }
        }), (int)1, null);
    }

    public final void showImageBase64(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.setAdvancedMode(true);
        ApplicationManager.getApplication().invokeAndWait(() -> GraphicsPanel.showImageBase64$lambda$8(this, data));
    }

    public final void showSvgImage(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.setAdvancedMode(true);
        ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<Unit>(this, data){
            final /* synthetic */ GraphicsPanel this$0;
            final /* synthetic */ String $data;
            {
                this.this$0 = $receiver;
                this.$data = $data;
                super(0);
            }

            public final void invoke() {
                if (Disposer.isDisposed((Disposable)GraphicsPanel.access$getDisposableParent$p(this.this$0))) {
                    return;
                }
                GraphicsPanel.access$setCurrentFile$p(this.this$0, null);
                GraphicsPanel.access$openEditor(this.this$0, (VirtualFile)new LightVirtualFile("image.svg", (CharSequence)this.$data));
            }
        }), (int)1, null);
    }

    public final void showMessage(@Nls @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.reset(message);
    }

    public final void showLoadingMessage(@Nls @Nullable String message) {
        GraphicsPanel.reset$default(this, null, 1, null);
        this.rootPanel.setContentComponent((JComponent)this.loadingPanel);
        String string = message;
        if (string == null) {
            string = VisualizationBundle.INSTANCE.message("graphics.loading", new Object[0]);
        }
        this.loadingPanel.setLoadingText(string);
    }

    public static /* synthetic */ void showLoadingMessage$default(GraphicsPanel graphicsPanel, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        graphicsPanel.showLoadingMessage(string);
    }

    public final void showMessageWithLink(@Nls @NotNull String message, @Nls @NotNull String linkText, @NotNull Function0<Unit> linkAction) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)linkText, (String)"linkText");
        Intrinsics.checkNotNullParameter(linkAction, (String)"linkAction");
        GraphicsPanel.reset$default(this, null, 1, null);
        this.rootPanel.setContentComponent(this.createInfoPanelWithLink(message, linkText, linkAction));
    }

    public final void reset(@Nls @Nullable String message) {
        this.currentFile = null;
        String string = message;
        if (string == null) {
            string = VisualizationBundle.INSTANCE.message("graphics.not.available", new Object[0]);
        }
        this.closeEditor(string);
    }

    public static /* synthetic */ void reset$default(GraphicsPanel graphicsPanel, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        graphicsPanel.reset(string);
    }

    private final boolean tryShowImage(File imageFile) {
        try {
            if (!imageFile.exists()) {
                return false;
            }
            byte[] content = this.readImageContent(imageFile);
            this.currentFile = imageFile;
            Ref.BooleanRef result = new Ref.BooleanRef();
            result.element = true;
            ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<Unit>(this, result, imageFile, content){
                final /* synthetic */ GraphicsPanel this$0;
                final /* synthetic */ Ref.BooleanRef $result;
                final /* synthetic */ File $imageFile;
                final /* synthetic */ byte[] $content;
                {
                    this.this$0 = $receiver;
                    this.$result = $result;
                    this.$imageFile = $imageFile;
                    this.$content = $content;
                    super(0);
                }

                public final void invoke() {
                    if (Disposer.isDisposed((Disposable)GraphicsPanel.access$getDisposableParent$p(this.this$0))) {
                        this.$result.element = false;
                        return;
                    }
                    GraphicsPanel.access$openEditor(this.this$0, (VirtualFile)new BinaryLightVirtualFile(this.$imageFile.getName(), this.$content));
                }
            }), (int)1, null);
            return result.element;
        }
        catch (Exception e) {
            LOGGER.error("Failed to load graphics", (Throwable)e);
            return false;
        }
    }

    private final byte[] readImageContent(File imageFile) {
        byte[] byArray;
        byte[] bytes = FilesKt.readBytes((File)imageFile);
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        if (editorColorsManager.isDarkEditor() && this.darkMode && this.isInvertible(imageFile)) {
            EditorColorsScheme editorColorsScheme = editorColorsManager.getGlobalScheme();
            Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"editorColorsManager.globalScheme");
            byArray = this.tryCreateInvertedImage(bytes, editorColorsScheme);
        } else {
            byArray = bytes;
        }
        return byArray;
    }

    private final boolean isInvertible(File $this$isInvertible) {
        GraphicsManager graphicsManager = this.graphicsManager;
        return graphicsManager != null ? graphicsManager.isInvertible($this$isInvertible) : false;
    }

    private final byte[] tryCreateInvertedImage(byte[] content, EditorColorsScheme globalScheme) {
        byte[] byArray;
        try {
            byArray = this.createInvertedImage(content, globalScheme);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to invert image", (Throwable)e);
            byArray = content;
        }
        return byArray;
    }

    private final byte[] createInvertedImage(byte[] content, EditorColorsScheme globalScheme) {
        Color color = globalScheme.getDefaultForeground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"globalScheme.defaultForeground");
        Color color2 = globalScheme.getDefaultBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"globalScheme.defaultBackground");
        ImageInverter inverter = new ImageInverter(color, color2);
        return inverter.invert(content);
    }

    private final void openEditor(VirtualFile file) {
        ActionsKt.runInEdt$default(null, (Function0)((Function0)new Function0<Unit>(this, file){
            final /* synthetic */ GraphicsPanel this$0;
            final /* synthetic */ VirtualFile $file;
            {
                this.this$0 = $receiver;
                this.$file = $file;
                super(0);
            }

            public final void invoke() {
                if (Disposer.isDisposed((Disposable)GraphicsPanel.access$getDisposableParent$p(this.this$0))) {
                    return;
                }
                GraphicsPanel.access$closeEditor(this.this$0, VisualizationBundle.INSTANCE.message("graphics.not.available", new Object[0]));
                ImageEditor editor = UiCustomizer.Companion.getInstance().createImageEditor(GraphicsPanel.access$getProject$p(this.this$0), this.$file, this.this$0);
                ImageZoomModel imageZoomModel = editor.getZoomModel();
                Intrinsics.checkNotNullExpressionValue((Object)imageZoomModel, (String)"editor.zoomModel");
                GraphicsPanel.access$adjustImageZoom(this.this$0, imageZoomModel);
                GraphicsPanel.access$removeImageInfoLabelAndActionToolBar(this.this$0, editor);
                GraphicsPanel.access$setCurrentImageFile$p(this.this$0, this.$file);
                GraphicsPanel.access$setCurrentEditor$p(this.this$0, editor);
                GraphicsPanel.access$withOverlayComponentPreserved(this.this$0, (Function0)new Function0<Unit>(this.this$0){
                    final /* synthetic */ GraphicsPanel this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        GraphicsPanel.access$getRootPanel$p(this.this$0).setContentComponent(GraphicsPanel.access$getInternalComponent(this.this$0));
                    }
                });
                Disposer.register((Disposable)GraphicsPanel.access$getDisposableParent$p(this.this$0), (Disposable)((Disposable)editor));
            }
        }), (int)1, null);
    }

    private final void withOverlayComponentPreserved(Function0<Unit> task) {
        JComponent component = this.overlayComponent;
        if (component != null && component.isVisible()) {
            component.setVisible(false);
            task.invoke();
            component.setVisible(true);
        } else {
            task.invoke();
        }
    }

    private final void closeEditor(@Nls String message) {
        this.label.setText(message);
        ImageEditor imageEditor = this.currentEditor;
        if (imageEditor != null) {
            ImageEditor it = imageEditor;
            boolean bl = false;
            Disposer.dispose((Disposable)((Disposable)it));
        }
        this.rootPanel.setContentComponent(null);
        this.currentImageFile = null;
        this.currentEditor = null;
    }

    private final void adjustImageZoom(ImageZoomModel zoomModel) {
        if (!this.isAdvancedMode) {
            zoomModel.setZoomFactor(1.0 / (double)scaleMultiplier);
        } else {
            zoomModel.fitZoomToWindow();
        }
    }

    private final int getAdvancedModeToolPanelHeight() {
        block1: {
            if (this.lastToolPanelHeight != 0) break block1;
            ImageEditor imageEditor = this.currentEditor;
            if (imageEditor != null) {
                ImageEditor editor = imageEditor;
                boolean bl = false;
                Component[] componentArray = editor.getComponent().getComponents();
                Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"editor.component.components");
                Serializable serializable = (Component)ArraysKt.firstOrNull((Object[])componentArray);
                this.lastToolPanelHeight = serializable != null && (serializable = serializable.getPreferredSize()) != null ? ((Dimension)serializable).height : 0;
            }
        }
        return this.lastToolPanelHeight;
    }

    private final void removeImageInfoLabelAndActionToolBar(ImageEditor editor) {
        block1: {
            List list = UIUtil.findComponentsOfType((JComponent)editor.getComponent(), JLabel.class);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findComponentsOfType(edi\u2026nent, JLabel::class.java)");
            List labels = list;
            for (JLabel label : labels) {
                String text;
                if (label.getText() == null) continue;
                boolean bl = false;
                if (!StringsKt.contains((CharSequence)text, (CharSequence)"color", (boolean)true) || StringsKt.contains$default((CharSequence)text, (CharSequence)"<html>", (boolean)false, (int)2, null)) continue;
                label.getParent().remove(label);
            }
            ActionToolbarImpl actionToolbarImpl = (ActionToolbarImpl)UIUtil.findComponentOfType((JComponent)editor.getComponent(), ActionToolbarImpl.class);
            if (actionToolbarImpl == null) break block1;
            ActionToolbarImpl toolbar = actionToolbarImpl;
            boolean bl = false;
            toolbar.getParent().remove((Component)toolbar);
        }
    }

    private final JPanel createInfoPanelWithLink(@Nls String message, @Nls String linkText, Function0<Unit> linkAction) {
        ActionLink actionLink;
        JLabel jLabel;
        JPanel jPanel;
        JPanel $this$createInfoPanelWithLink_u24lambda_u2415 = jPanel = new JPanel();
        boolean bl = false;
        $this$createInfoPanelWithLink_u24lambda_u2415.setLayout(new BoxLayout($this$createInfoPanelWithLink_u24lambda_u2415, 1));
        $this$createInfoPanelWithLink_u24lambda_u2415.add(Box.createVerticalGlue());
        JLabel $this$createInfoPanelWithLink_u24lambda_u2415_u24lambda_u2413 = jLabel = new JLabel(message);
        boolean bl2 = false;
        $this$createInfoPanelWithLink_u24lambda_u2415_u24lambda_u2413.setAlignmentX(0.5f);
        JLabel infoLabel = jLabel;
        $this$createInfoPanelWithLink_u24lambda_u2415.add(infoLabel);
        $this$createInfoPanelWithLink_u24lambda_u2415.add(Box.createRigidArea(new Dimension(0, JBUIScale.scale((int)6))));
        ActionLink $this$createInfoPanelWithLink_u24lambda_u2415_u24lambda_u2414 = actionLink = new ActionLink(linkText, (Function1)new Function1<ActionEvent, Unit>(linkAction){
            final /* synthetic */ Function0<Unit> $linkAction;
            {
                this.$linkAction = $linkAction;
                super(1);
            }

            public final void invoke(@NotNull ActionEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$linkAction.invoke();
            }
        });
        boolean bl3 = false;
        $this$createInfoPanelWithLink_u24lambda_u2415_u24lambda_u2414.setAlignmentX(0.5f);
        ActionLink linkLabel2 = actionLink;
        $this$createInfoPanelWithLink_u24lambda_u2415.add((Component)linkLabel2);
        $this$createInfoPanelWithLink_u24lambda_u2415.add(Box.createVerticalGlue());
        return jPanel;
    }

    private static final void _init_$lambda$5(GraphicsPanel this$0, EditorColorsScheme it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            File file = this$0.currentFile;
            if (file == null) break block0;
            File it2 = file;
            boolean bl = false;
            this$0.showImageAsync(it2);
        }
    }

    private static final void showImageBase64$lambda$8(GraphicsPanel this$0, String $data) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$data, (String)"$data");
        if (Disposer.isDisposed((Disposable)this$0.disposableParent)) {
            return;
        }
        this$0.currentFile = null;
        this$0.openEditor((VirtualFile)new BinaryLightVirtualFile("image", Base64.getMimeDecoder().decode($data)));
    }

    public static final /* synthetic */ Disposable access$getDisposableParent$p(GraphicsPanel $this) {
        return $this.disposableParent;
    }

    public static final /* synthetic */ void access$setCurrentFile$p(GraphicsPanel $this, File file) {
        $this.currentFile = file;
    }

    public static final /* synthetic */ void access$openEditor(GraphicsPanel $this, VirtualFile file) {
        $this.openEditor(file);
    }

    public static final /* synthetic */ void access$closeEditor(GraphicsPanel $this, String message) {
        $this.closeEditor(message);
    }

    public static final /* synthetic */ Project access$getProject$p(GraphicsPanel $this) {
        return $this.project;
    }

    public static final /* synthetic */ void access$adjustImageZoom(GraphicsPanel $this, ImageZoomModel zoomModel) {
        $this.adjustImageZoom(zoomModel);
    }

    public static final /* synthetic */ void access$removeImageInfoLabelAndActionToolBar(GraphicsPanel $this, ImageEditor editor) {
        $this.removeImageInfoLabelAndActionToolBar(editor);
    }

    public static final /* synthetic */ void access$setCurrentImageFile$p(GraphicsPanel $this, VirtualFile virtualFile) {
        $this.currentImageFile = virtualFile;
    }

    public static final /* synthetic */ void access$setCurrentEditor$p(GraphicsPanel $this, ImageEditor imageEditor) {
        $this.currentEditor = imageEditor;
    }

    public static final /* synthetic */ void access$withOverlayComponentPreserved(GraphicsPanel $this, Function0 task) {
        $this.withOverlayComponentPreserved((Function0<Unit>)task);
    }

    public static final /* synthetic */ EmptyComponentPanel access$getRootPanel$p(GraphicsPanel $this) {
        return $this.rootPanel;
    }

    public static final /* synthetic */ JComponent access$getInternalComponent(GraphicsPanel $this) {
        return $this.getInternalComponent();
    }

    static {
        Logger logger = Logger.getInstance(GraphicsPanel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(GraphicsPanel::class.java)");
        LOGGER = logger;
        isHiDpi = JreHiDpiUtil.isJreHiDPI(null) || UIUtil.isRetina();
        scaleMultiplier = !isHiDpi ? 1 : 2;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\u0007J\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/components/GraphicsPanel$Companion;", "", "()V", "LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "imageInsets", "", "isHiDpi", "", "scaleMultiplier", "calculateImageSizeForRegion", "Ljava/awt/Dimension;", "region", "topOffset", "calculateRegionForImageSize", "imageSize", "intellij.notebooks.visualization"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Dimension calculateImageSizeForRegion(@NotNull Dimension region, int topOffset) {
            Intrinsics.checkNotNullParameter((Object)region, (String)"region");
            return new Dimension(region.width - 4, region.height - 4 - topOffset);
        }

        public static /* synthetic */ Dimension calculateImageSizeForRegion$default(Companion companion, Dimension dimension, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            return companion.calculateImageSizeForRegion(dimension, n);
        }

        @NotNull
        public final Dimension calculateRegionForImageSize(@NotNull Dimension imageSize, int topOffset) {
            Intrinsics.checkNotNullParameter((Object)imageSize, (String)"imageSize");
            return new Dimension(imageSize.width + 4, imageSize.height + 4 + topOffset);
        }

        public static /* synthetic */ Dimension calculateRegionForImageSize$default(Companion companion, Dimension dimension, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            return companion.calculateRegionForImageSize(dimension, n);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

