/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.providers;

import com.intellij.collaboration.ui.icon.AsyncImageIconsProvider;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.ImageUtil;
import icons.CollaborationToolsIcons;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gitlab.api.GitLabApi;
import org.jetbrains.plugins.gitlab.api.GitLabServerPath;
import org.jetbrains.plugins.gitlab.api.dto.GitLabUserDTO;
import org.jetbrains.plugins.gitlab.api.request.GitLabUsersApiKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\n\u001a\u00020\u0002H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ\u0019\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000eH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/gitlab/providers/GitLabImageLoader;", "Lcom/intellij/collaboration/ui/icon/AsyncImageIconsProvider$AsyncImageLoader;", "Lorg/jetbrains/plugins/gitlab/api/dto/GitLabUserDTO;", "apiClient", "Lorg/jetbrains/plugins/gitlab/api/GitLabApi;", "server", "Lorg/jetbrains/plugins/gitlab/api/GitLabServerPath;", "(Lorg/jetbrains/plugins/gitlab/api/GitLabApi;Lorg/jetbrains/plugins/gitlab/api/GitLabServerPath;)V", "createBaseIcon", "Ljavax/swing/Icon;", "key", "iconSize", "", "load", "Ljava/awt/Image;", "(Lorg/jetbrains/plugins/gitlab/api/dto/GitLabUserDTO;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "postProcess", "image", "(Ljava/awt/Image;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.vcs.gitlab"})
public final class GitLabImageLoader
implements AsyncImageIconsProvider.AsyncImageLoader<GitLabUserDTO> {
    @NotNull
    private final GitLabApi apiClient;
    @NotNull
    private final GitLabServerPath server;

    public GitLabImageLoader(@NotNull GitLabApi apiClient2, @NotNull GitLabServerPath server) {
        Intrinsics.checkNotNullParameter((Object)apiClient2, (String)"apiClient");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        this.apiClient = apiClient2;
        this.server = server;
    }

    @Nullable
    public Object load(@NotNull GitLabUserDTO key, @NotNull Continuation<? super Image> $completion) {
        Image image;
        String string = key.getAvatarUrl();
        if (string != null) {
            String avatarUrl = string;
            boolean bl = false;
            String actualUrl = StringsKt.startsWith$default((String)avatarUrl, (String)"http", (boolean)false, (int)2, null) ? avatarUrl : this.server.getUri() + avatarUrl;
            Object object = GitLabUsersApiKt.loadImage(this.apiClient, actualUrl, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            image = (Image)object;
        } else {
            image = null;
        }
        return image;
    }

    @NotNull
    public Icon createBaseIcon(@Nullable GitLabUserDTO key, int iconSize) {
        Icon icon = CollaborationToolsIcons.Review.DefaultAvatar;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"DefaultAvatar");
        return IconUtil.resizeSquared((Icon)icon, (int)iconSize);
    }

    @Nullable
    public Object postProcess(@NotNull Image image, @NotNull Continuation<? super Image> $completion) {
        BufferedImage bufferedImage = ImageUtil.createCircleImage((BufferedImage)ImageUtil.toBufferedImage((Image)image));
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"createCircleImage(ImageU\u2026l.toBufferedImage(image))");
        return bufferedImage;
    }
}

