/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.util;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.util.LinesUtil;
import com.intellij.rt.coverage.util.CoverageIOUtil;
import com.intellij.rt.coverage.util.ErrorReporter;
import com.intellij.rt.coverage.util.ReportSectionsUtil;
import com.intellij.rt.coverage.util.StringsPool;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import org.jetbrains.coverage.gnu.trove.TIntObjectHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectDataLoader {
    public static final int REPORT_VERSION = 1;

    public static ProjectData loadLocked(File sessionDataFile) {
        CoverageIOUtil.FileLock lock = null;
        try {
            lock = CoverageIOUtil.FileLock.lock(sessionDataFile);
            ProjectData projectData = ProjectDataLoader.load(sessionDataFile);
            return projectData;
        }
        finally {
            CoverageIOUtil.FileLock.unlock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProjectData load(File sessionDataFile) {
        ProjectData projectInfo = new ProjectData();
        DataInputStream in = null;
        if (sessionDataFile.length() == 0L) {
            return projectInfo;
        }
        try {
            ClassData classInfo;
            int c;
            in = CoverageIOUtil.openReadFile(sessionDataFile);
            TIntObjectHashMap<ClassData> dict = new TIntObjectHashMap<ClassData>(1000, 0.99f);
            int classCount = CoverageIOUtil.readINT(in);
            for (c = 0; c < classCount; ++c) {
                classInfo = projectInfo.getOrCreateClassData(StringsPool.getFromPool(CoverageIOUtil.readUTFFast(in)));
                dict.put(c, classInfo);
            }
            for (c = 0; c < classCount; ++c) {
                classInfo = (ClassData)dict.get(CoverageIOUtil.readINT(in));
                int methCount = CoverageIOUtil.readINT(in);
                TIntObjectHashMap<LineData> lines = new TIntObjectHashMap<LineData>(4, 0.99f);
                int maxLine = -1;
                for (int m = 0; m < methCount; ++m) {
                    String methodSig = ProjectDataLoader.expand(in, dict);
                    int lineCount = CoverageIOUtil.readINT(in);
                    for (int l = 0; l < lineCount; ++l) {
                        int line = CoverageIOUtil.readINT(in);
                        LineData lineInfo = lines.get(line);
                        if (lineInfo == null) {
                            lineInfo = new LineData(line, StringsPool.getFromPool(methodSig));
                            lines.put(line, lineInfo);
                            if (line > maxLine) {
                                maxLine = line;
                            }
                        }
                        classInfo.registerMethodSignature(lineInfo);
                        String testName = CoverageIOUtil.readUTFFast(in);
                        if (testName != null && testName.length() > 0) {
                            lineInfo.setTestName(testName);
                        }
                        int hits = CoverageIOUtil.readINT(in);
                        lineInfo.setHits(hits);
                        if (hits > 0) {
                            int jumpsNumber = CoverageIOUtil.readINT(in);
                            for (int j = 0; j < jumpsNumber; ++j) {
                                lineInfo.setTrueHits(j, CoverageIOUtil.readINT(in));
                                lineInfo.setFalseHits(j, CoverageIOUtil.readINT(in));
                            }
                            int switchesNumber = CoverageIOUtil.readINT(in);
                            for (int s = 0; s < switchesNumber; ++s) {
                                int defaultHit = CoverageIOUtil.readINT(in);
                                int keysLength = CoverageIOUtil.readINT(in);
                                int[] keys = new int[keysLength];
                                int[] keysHits = new int[keysLength];
                                for (int k = 0; k < keysLength; ++k) {
                                    keys[k] = CoverageIOUtil.readINT(in);
                                    keysHits[k] = CoverageIOUtil.readINT(in);
                                }
                                lineInfo.setDefaultHits(s, keys, defaultHit);
                                lineInfo.setSwitchHits(s, keys, keysHits);
                            }
                        }
                        lineInfo.fillArrays();
                    }
                }
                classInfo.setLines(LinesUtil.calcLineArray(maxLine, lines));
            }
            ProjectDataLoader.loadExtraInfo(projectInfo, in, dict);
        }
        catch (Exception e) {
            ErrorReporter.reportError("Failed to load coverage data from file: " + sessionDataFile.getAbsolutePath(), e);
        }
        finally {
            CoverageIOUtil.close(in);
        }
        return projectInfo;
    }

    private static String expand(DataInputStream in, final TIntObjectHashMap<ClassData> dict) throws IOException {
        return CoverageIOUtil.processWithDictionary(CoverageIOUtil.readUTFFast(in), new CoverageIOUtil.Consumer(){

            protected String consume(String type) {
                if (type.length() > 0 && Character.isDigit(type.charAt(0))) {
                    try {
                        int typeIdx = Integer.parseInt(type);
                        return ((ClassData)dict.get(typeIdx)).getName();
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return type;
            }
        });
    }

    private static void loadExtraInfo(ProjectData projectData, DataInputStream in, TIntObjectHashMap<ClassData> dict) throws IOException {
        int version;
        try {
            version = CoverageIOUtil.readINT(in);
        }
        catch (EOFException e) {
            return;
        }
        if (version > 1) {
            ErrorReporter.reportError("Report version " + version + " is greater than agent maximum support version " + 1 + "\nPlease try to update coverage agent.");
            return;
        }
        String ignored = CoverageIOUtil.readUTFFast(in);
        ReportSectionsUtil.loadSections(projectData, in, dict);
    }
}

