/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.util;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.internal.impl.util.NullableArrayMapAccessor;
import org.jetbrains.annotations.NotNull;

public abstract class TypeRegistry<K, V> {
    @NotNull
    private final ConcurrentHashMap<String, Integer> idPerType = new ConcurrentHashMap();
    @NotNull
    private final AtomicInteger idCounter = new AtomicInteger(0);

    @NotNull
    public final <T extends V, KK extends K> NullableArrayMapAccessor<K, V, T> generateNullableAccessor(@NotNull KClass<KK> kClass) {
        Intrinsics.checkNotNullParameter(kClass, "kClass");
        return new NullableArrayMapAccessor(kClass, this.getId(kClass));
    }

    public final <T extends K> int getId(@NotNull KClass<T> kClass) {
        Intrinsics.checkNotNullParameter(kClass, "kClass");
        String string2 = kClass.getQualifiedName();
        Intrinsics.checkNotNull(string2);
        return this.customComputeIfAbsent(this.idPerType, string2, (Function1<String, Integer>)new Function1<String, Integer>(this){
            final /* synthetic */ TypeRegistry<K, V> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Integer invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return TypeRegistry.access$getIdCounter$p(this.this$0).getAndIncrement();
            }
        });
    }

    public abstract int customComputeIfAbsent(@NotNull ConcurrentHashMap<String, Integer> var1, @NotNull String var2, @NotNull Function1<? super String, Integer> var3);

    @NotNull
    protected final Collection<Integer> getIndices() {
        Collection<Integer> collection = this.idPerType.values();
        Intrinsics.checkNotNullExpressionValue(collection, "idPerType.values");
        return collection;
    }

    public static final /* synthetic */ AtomicInteger access$getIdCounter$p(TypeRegistry $this) {
        return $this.idCounter;
    }
}

