/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl.forward;

import com.intellij.util.indexing.impl.forward.IntForwardIndex;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.MeasurableIndexStore;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.PersistentMap;
import com.intellij.util.io.PersistentMapBuilder;
import java.io.IOException;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

public class IntMapForwardIndex
implements IntForwardIndex,
MeasurableIndexStore {
    @NotNull
    private final Path myStorageFile;
    private final boolean myHasChunks;
    @NotNull
    private volatile PersistentMap<Integer, Integer> myPersistentMap;

    public IntMapForwardIndex(@NotNull Path storageFile, boolean hasChunks) throws IOException {
        if (storageFile == null) {
            IntMapForwardIndex.$$$reportNull$$$0(0);
        }
        this.myStorageFile = storageFile;
        this.myHasChunks = hasChunks;
        this.myPersistentMap = IntMapForwardIndex.createMap(this.myStorageFile, this.myHasChunks);
    }

    @NotNull
    private static PersistentMap<Integer, Integer> createMap(@NotNull Path storageFile, boolean hasChunks) throws IOException {
        if (storageFile == null) {
            IntMapForwardIndex.$$$reportNull$$$0(1);
        }
        PersistentHashMap<Integer, Integer> persistentHashMap = PersistentMapBuilder.newBuilder(storageFile, EnumeratorIntegerDescriptor.INSTANCE, EnumeratorIntegerDescriptor.INSTANCE).inlineValues().hasChunks(hasChunks).build();
        if (persistentHashMap == null) {
            IntMapForwardIndex.$$$reportNull$$$0(2);
        }
        return persistentHashMap;
    }

    @Override
    public int getInt(int key) throws IOException {
        return (Integer)this.myPersistentMap.get(key);
    }

    @Override
    public void putInt(int key, int value) throws IOException {
        this.myPersistentMap.put(key, value);
    }

    @Override
    public void force() {
        this.myPersistentMap.force();
    }

    @Override
    public boolean isDirty() {
        return this.myPersistentMap.isDirty();
    }

    @Override
    public int keysCountApproximately() {
        if (this.myPersistentMap instanceof MeasurableIndexStore) {
            return ((MeasurableIndexStore)((Object)this.myPersistentMap)).keysCountApproximately();
        }
        return -1;
    }

    @Override
    public void clear() throws IOException {
        this.myPersistentMap.closeAndClean();
        this.myPersistentMap = IntMapForwardIndex.createMap(this.myStorageFile, this.myHasChunks);
    }

    @Override
    public void close() throws IOException {
        this.myPersistentMap.close();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/impl/forward/IntMapForwardIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/impl/forward/IntMapForwardIndex";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createMap";
                break;
            }
            case 2: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

