/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.update;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.impl.VcsPathPresenter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBList;
import com.intellij.ui.dsl.listCellRenderer.BuilderKt;
import com.intellij.util.ui.AdjustComponentWhenShown;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.idea.svn.update.SvnPanel;

public class MultipleRootEditorWithSplitter
extends JPanel {
    private final JList<FilePath> myList;
    private final JPanel myConfigureRootPanel;
    @NonNls
    private static final String EMPTY = "empty";

    public MultipleRootEditorWithSplitter(Map<FilePath, SvnPanel> rootToPanel, Project project) {
        super(new BorderLayout());
        final Splitter splitter = new Splitter(false, 0.5f);
        splitter.setHonorComponentsMinimumSize(false);
        this.add((Component)splitter, "Center");
        this.myList = new JBList();
        Color borderColor = JBColor.border();
        this.myConfigureRootPanel = new JPanel();
        this.myConfigureRootPanel.setBorder(BorderFactory.createLineBorder(borderColor));
        splitter.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane(this.myList));
        splitter.setSecondComponent((JComponent)this.myConfigureRootPanel);
        CardLayout layout = new CardLayout();
        this.myConfigureRootPanel.setLayout(layout);
        DefaultListModel<FilePath> listModel = new DefaultListModel<FilePath>();
        layout.addLayoutComponent(new JPanel(), EMPTY);
        int minimumRightSize = 320;
        for (FilePath root : rootToPanel.keySet()) {
            JPanel panel2 = rootToPanel.get(root).getPanel();
            this.myConfigureRootPanel.add((Component)panel2, root.getPath());
            if (panel2.getMinimumSize().width > 0) {
                minimumRightSize = Math.max(minimumRightSize, panel2.getPreferredSize().width);
            }
            listModel.addElement(root);
        }
        this.myConfigureRootPanel.revalidate();
        this.myList.setModel(listModel);
        this.myList.getSelectionModel().setSelectionMode(0);
        this.myList.setCellRenderer(BuilderKt.simpleListCellRenderer(o -> {
            VcsPathPresenter presenter = VcsPathPresenter.getInstance((Project)project);
            VirtualFile file = o.getVirtualFile();
            return file != null ? presenter.getPresentableRelativePathFor(file) : FileUtil.join((String[])new String[]{presenter.getPresentableRelativePathFor(o.getVirtualFileParent()), o.getName()});
        }));
        this.myList.addListSelectionListener(e -> {
            FilePath root = this.myList.getSelectedValue();
            if (root != null) {
                layout.show(this.myConfigureRootPanel, root.getPath());
            } else {
                layout.show(this.myConfigureRootPanel, EMPTY);
            }
        });
        this.myList.setSelectedIndex(0);
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(this.myList, true));
        final int finalMinimumRightSize = minimumRightSize;
        new AdjustComponentWhenShown(){

            protected boolean init() {
                if (MultipleRootEditorWithSplitter.this.getWidth() < finalMinimumRightSize * 2) {
                    int left = MultipleRootEditorWithSplitter.this.getWidth() - finalMinimumRightSize;
                    float newProportion = left < 0 ? 0.2f : (float)left / (float)MultipleRootEditorWithSplitter.this.getWidth();
                    splitter.setProportion(newProportion);
                }
                return true;
            }

            protected boolean canExecute() {
                return MultipleRootEditorWithSplitter.this.getWidth() > 0;
            }
        }.install((Component)splitter);
    }
}

